/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointListener;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite3.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.StoragePartitionMeta;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineView;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.BlobStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.ConsistentGradualTaskExecutor;
import org.apache.ignite3.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.storage.util.LocalLocker;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.ByteUtils;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryMvPartitionStorage
extends AbstractPageMemoryMvPartitionStorage {
    private final CheckpointManager checkpointManager;
    private final CheckpointTimeoutLock checkpointTimeoutLock;
    private volatile StoragePartitionMeta meta;
    private final CheckpointListener checkpointListener;
    private volatile BlobStorage blobStorage;
    private final ReadWriteLock replicationProtocolGroupConfigReadWriteLock = new ReentrantReadWriteLock();
    @Nullable
    private volatile LeaseInfo leaseInfo;
    private final Object leaseInfoLock = new Object();

    public PersistentPageMemoryMvPartitionStorage(PersistentPageMemoryTableStorage tableStorage, int partitionId, StoragePartitionMeta meta, FreeListImpl freeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue, ExecutorService destructionExecutor, FailureProcessor failureProcessor) {
        super(partitionId, tableStorage, new RenewablePartitionStorageState(tableStorage, partitionId, versionChainTree, freeList, indexMetaTree, gcQueue), destructionExecutor, failureProcessor);
        this.checkpointManager = tableStorage.engine().checkpointManager();
        this.checkpointTimeoutLock = this.checkpointManager.checkpointTimeoutLock();
        PersistentPageMemoryDataRegion dataRegion = tableStorage.dataRegion();
        this.meta = meta;
        this.checkpointListener = new CheckpointListener(){

            @Override
            public void beforeCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }

            @Override
            public void onMarkCheckpointBegin(CheckpointProgress progress, @Nullable Executor exec) {
                PersistentPageMemoryMvPartitionStorage.this.syncMetadataOnCheckpoint(exec);
            }
        };
        this.checkpointManager.addCheckpointListener(this.checkpointListener, dataRegion);
        this.blobStorage = new BlobStorage(freeList, (PageMemory)dataRegion.pageMemory(), tableStorage.getTableId(), partitionId);
        this.leaseInfo = this.leaseInfoFromMeta();
    }

    @Override
    protected GradualTaskExecutor createGradualTaskExecutor(ExecutorService threadPool) {
        return new ConsistentGradualTaskExecutor(this, threadPool);
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        LocalLocker locker = (LocalLocker)THREAD_LOCAL_LOCKER.get();
        if (locker != null) {
            return closure.execute(locker);
        }
        return (V)this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            LocalLocker locker0 = new LocalLocker(this.lockByRowId);
            this.checkpointTimeoutLock.checkpointReadLock();
            THREAD_LOCAL_LOCKER.set(locker0);
            try {
                Object v = closure.execute(locker0);
                return v;
            }
            finally {
                THREAD_LOCAL_LOCKER.set(null);
                locker0.unlockAll();
                this.checkpointTimeoutLock.checkpointReadUnlock();
            }
        });
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        return this.busy(() -> {
            CheckpointProgress scheduledCheckpoint;
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
            if (!trigger) {
                scheduledCheckpoint = this.checkpointManager.scheduleCheckpoint(Integer.MAX_VALUE, "subscribe to next checkpoint");
            } else if (lastCheckpoint != null && this.meta.metaSnapshot(lastCheckpoint.id()).lastAppliedIndex() == this.meta.lastAppliedIndex()) {
                scheduledCheckpoint = lastCheckpoint;
            } else {
                PersistentPageMemoryTableStorage persistentTableStorage = (PersistentPageMemoryTableStorage)this.tableStorage;
                PersistentPageMemoryStorageEngineView engineCfg = (PersistentPageMemoryStorageEngineView)persistentTableStorage.engine().configuration().value();
                int checkpointDelayMillis = engineCfg.checkpoint().checkpointDelayMillis();
                scheduledCheckpoint = this.checkpointManager.scheduleCheckpoint(checkpointDelayMillis, "Triggered by replicator");
            }
            return scheduledCheckpoint.futureFor(CheckpointState.FINISHED);
        });
    }

    @Override
    public long lastAppliedIndex() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            return this.meta.lastAppliedIndex();
        });
    }

    @Override
    public long lastAppliedTerm() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            return this.meta.lastAppliedTerm();
        });
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.lastAppliedBusy(lastAppliedIndex, lastAppliedTerm);
            return null;
        });
    }

    private void lastAppliedBusy(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.updateMeta((lastCheckpointId, meta) -> meta.lastApplied(lastCheckpointId, lastAppliedIndex, lastAppliedTerm));
    }

    private void updateMeta(MetaUpdateClosure closure) {
        assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread());
        CheckpointProgress lastCheckpoint = this.checkpointManager.lastCheckpointProgress();
        UUID lastCheckpointId = lastCheckpoint == null ? null : lastCheckpoint.id();
        closure.update(lastCheckpointId, this.meta);
        this.checkpointManager.markPartitionAsDirty(this.tableStorage.dataRegion(), this.tableStorage.getTableId(), this.partitionId, this.meta.partitionGeneration());
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            try {
                this.replicationProtocolGroupConfigReadWriteLock.readLock().lock();
                try {
                    long configFirstPageId = this.meta.lastReplicationProtocolGroupConfigFirstPageId();
                    if (configFirstPageId == 0L) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    byte[] byArray = this.blobStorage.readBlob(this.meta.lastReplicationProtocolGroupConfigFirstPageId());
                    return byArray;
                }
                finally {
                    this.replicationProtocolGroupConfigReadWriteLock.readLock().unlock();
                }
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Failed to read group config: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
            }
        });
    }

    @Override
    public void committedGroupConfiguration(byte[] config) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.committedGroupConfigurationBusy(config);
            return null;
        });
    }

    @Override
    public void updateLease(LeaseInfo leaseInfo) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.updateLeaseBusy(leaseInfo);
            return null;
        });
    }

    private void updateLeaseBusy(LeaseInfo leaseInfo) {
        this.updateMeta((lastCheckpointId, meta) -> {
            Object object = this.leaseInfoLock;
            synchronized (object) {
                if (leaseInfo.leaseStartTime() <= meta.leaseStartTime()) {
                    return;
                }
                try {
                    byte[] primaryReplicaNodeNameBytes = ByteUtils.stringToBytes(leaseInfo.primaryReplicaNodeName());
                    if (meta.primaryReplicaNodeNameFirstPageId() == 0L) {
                        long primaryReplicaNodeNameFirstPageId = this.blobStorage.addBlob(primaryReplicaNodeNameBytes);
                        meta.primaryReplicaNodeNameFirstPageId(lastCheckpointId, primaryReplicaNodeNameFirstPageId);
                    } else {
                        this.blobStorage.updateBlob(meta.primaryReplicaNodeNameFirstPageId(), primaryReplicaNodeNameBytes);
                    }
                    meta.primaryReplicaNodeId(lastCheckpointId, leaseInfo.primaryReplicaNodeId());
                    meta.updateLease(lastCheckpointId, leaseInfo.leaseStartTime());
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Cannot save lease meta: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
                }
                this.leaseInfo = leaseInfo;
            }
        });
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return this.leaseInfo;
        });
    }

    @Nullable
    private LeaseInfo leaseInfoFromMeta() {
        String primaryReplicaNodeName;
        long primaryReplicaNodeNameFirstPageId = this.meta.primaryReplicaNodeNameFirstPageId();
        if (primaryReplicaNodeNameFirstPageId == 0L) {
            return null;
        }
        try {
            primaryReplicaNodeName = ByteUtils.stringFromBytes(this.blobStorage.readBlob(primaryReplicaNodeNameFirstPageId));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to read primary replica node name: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
        }
        return new LeaseInfo(this.meta.leaseStartTime(), this.meta.primaryReplicaNodeId(), primaryReplicaNodeName);
    }

    private void committedGroupConfigurationBusy(byte[] groupConfigBytes) {
        this.updateMeta((lastCheckpointId, meta) -> {
            this.replicationProtocolGroupConfigReadWriteLock.writeLock().lock();
            try {
                if (meta.lastReplicationProtocolGroupConfigFirstPageId() == 0L) {
                    long configPageId = this.blobStorage.addBlob(groupConfigBytes);
                    meta.lastReplicationProtocolGroupConfigFirstPageId(lastCheckpointId, configPageId);
                } else {
                    this.blobStorage.updateBlob(meta.lastReplicationProtocolGroupConfigFirstPageId(), groupConfigBytes);
                }
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Cannot save committed group configuration: [tableId={}, partitionId={}]", (Throwable)e, this.tableStorage.getTableId(), this.partitionId);
            }
            finally {
                this.replicationProtocolGroupConfigReadWriteLock.writeLock().unlock();
            }
        });
    }

    @Override
    public void createHashIndex(StorageHashIndexDescriptor indexDescriptor) {
        this.runConsistently(locker -> {
            super.createHashIndex(indexDescriptor);
            return null;
        });
    }

    @Override
    public void createSortedIndex(StorageSortedIndexDescriptor indexDescriptor) {
        this.runConsistently(locker -> {
            super.createSortedIndex(indexDescriptor);
            return null;
        });
    }

    @Override
    protected List<AutoCloseable> getResourcesToClose() {
        List<AutoCloseable> resourcesToClose = super.getResourcesToClose();
        resourcesToClose.add(() -> this.checkpointManager.removeCheckpointListener(this.checkpointListener));
        RenewablePartitionStorageState localState = this.renewableState;
        resourcesToClose.add(localState.freeList()::close);
        resourcesToClose.add(this.blobStorage::close);
        return resourcesToClose;
    }

    private void syncMetadataOnCheckpoint(@Nullable Executor executor) {
        RenewablePartitionStorageState localState = this.renewableState;
        if (executor == null) {
            this.busySafe(() -> this.saveFreeListMetadataBusy(localState));
        } else {
            executor.execute(() -> this.busySafe(() -> this.saveFreeListMetadataBusy(localState)));
        }
    }

    @Override
    public void lastAppliedOnRebalance(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.lastAppliedBusy(lastAppliedIndex, lastAppliedTerm);
    }

    public void updateDataStructures(StoragePartitionMeta meta, FreeListImpl freeList, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue) {
        StorageUtils.throwExceptionIfStorageNotInCleanupOrRebalancedState((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.meta = meta;
        this.blobStorage = new BlobStorage(freeList, (PageMemory)this.tableStorage.dataRegion().pageMemory(), this.tableStorage.getTableId(), this.partitionId);
        this.updateRenewableState(versionChainTree, freeList, indexMetaTree, gcQueue);
        this.checkpointManager.addCheckpointListener(this.checkpointListener, this.tableStorage.dataRegion());
    }

    @Override
    List<AutoCloseable> getResourcesToCloseOnCleanup() {
        RenewablePartitionStorageState localState = this.renewableState;
        return List.of(() -> this.checkpointManager.removeCheckpointListener(this.checkpointListener), localState.freeList()::close, localState.versionChainTree()::close, localState.indexMetaTree()::close, localState.gcQueue()::close, this.blobStorage::close);
    }

    @Override
    public void committedGroupConfigurationOnRebalance(byte[] config) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.committedGroupConfigurationBusy(config);
    }

    @Override
    public void updateLeaseOnRebalance(LeaseInfo leaseInfo) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((Object)this.state.get()), this::createStorageInfo);
        this.updateLeaseBusy(leaseInfo);
    }

    private void saveFreeListMetadataBusy(RenewablePartitionStorageState localState) {
        try {
            localState.freeList().saveMetadata();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Failed to save free list metadata: [{}]", (Throwable)e, this.createStorageInfo());
        }
    }

    @Override
    public long estimatedSize() {
        return this.meta.estimatedSize();
    }

    @Override
    public void incrementEstimatedSize() {
        this.updateMeta((lastCheckpointId, meta) -> meta.incrementEstimatedSize(lastCheckpointId));
    }

    @Override
    public void decrementEstimatedSize() {
        this.updateMeta((lastCheckpointId, meta) -> meta.decrementEstimatedSize(lastCheckpointId));
    }

    public int emptyDataPageCountInFreeList() {
        return this.renewableState.freeList().emptyDataPages();
    }

    @FunctionalInterface
    private static interface MetaUpdateClosure {
        public void update(UUID var1, StoragePartitionMeta var2);
    }
}

