/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.managers.deployment.GridDeploymentClassLoader;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDeployment
extends GridMetadataAwareAdapter
implements GridDeploymentInfo {
    private final long ts = U.currentTimeMillis();
    private final DeploymentMode depMode;
    private final ClassLoader clsLdr;
    private final IgniteUuid clsLdrId;
    private final String userVer;
    private final boolean loc;
    private final String sampleClsName;
    private volatile boolean pendingUndeploy;
    @GridToStringExclude
    private final AtomicStampedReference<Boolean> usage = new AtomicStampedReference<Boolean>(false, 0);
    @GridToStringExclude
    private final ConcurrentMap<Class<?>, ConcurrentMap<Class<? extends Annotation>, GridTuple<Annotation>>> anns = new ConcurrentHashMap();
    @GridToStringExclude
    private final ConcurrentMap<String, Class<?>> clss = new ConcurrentHashMap();
    @GridToStringExclude
    private final ConcurrentMap<Class<?>, Boolean> internalTasks = new ConcurrentHashMap();
    @GridToStringExclude
    private final ConcurrentMap<Class<?>, ConcurrentMap<Class<? extends Annotation>, Collection<Field>>> fieldCache = new ConcurrentHashMap();
    @GridToStringExclude
    private final ConcurrentMap<Class<?>, ConcurrentMap<Class<? extends Annotation>, Collection<Method>>> mtdCache = new ConcurrentHashMap();
    @GridToStringExclude
    private final ConcurrentMap<Class<?>, GridTuple<Constructor<?>>> dfltCtorsCache = new ConcurrentHashMap();

    GridDeployment(DeploymentMode depMode, ClassLoader clsLdr, IgniteUuid clsLdrId, String userVer, String sampleClsName, boolean loc) {
        assert (depMode != null);
        assert (clsLdr != null);
        assert (clsLdrId != null);
        assert (userVer != null);
        assert (sampleClsName != null);
        this.clsLdr = clsLdr;
        this.clsLdrId = clsLdrId;
        this.userVer = userVer;
        this.depMode = depMode;
        this.sampleClsName = sampleClsName;
        this.loc = loc;
    }

    public long timestamp() {
        return this.ts;
    }

    public String sampleClassName() {
        return this.sampleClsName;
    }

    @Override
    public DeploymentMode deployMode() {
        return this.depMode;
    }

    @Override
    public boolean localDeploymentOwner() {
        return false;
    }

    @Override
    public long sequenceNumber() {
        return this.clsLdrId.localId();
    }

    public ClassLoader classLoader() {
        return this.clsLdr;
    }

    @Override
    public IgniteUuid classLoaderId() {
        return this.clsLdrId;
    }

    @Override
    public String userVersion() {
        return this.userVer;
    }

    public boolean hasName(String name) {
        assert (name != null);
        return this.clss.containsKey(name);
    }

    public boolean local() {
        return this.loc;
    }

    public boolean undeployed() {
        return this.usage.getReference();
    }

    public void undeploy() {
        int r;
        int[] stamp = new int[1];
        do {
            boolean undeployed;
            if (undeployed = this.usage.get(stamp).booleanValue()) {
                return;
            }
            r = stamp[0];
        } while (!this.usage.compareAndSet(false, true, r, r));
    }

    public boolean pendingUndeploy() {
        return this.pendingUndeploy;
    }

    public void onUndeployScheduled() {
        this.pendingUndeploy = true;
    }

    public boolean acquire() {
        int r;
        boolean undeployed;
        int[] stamp = new int[1];
        do {
            undeployed = this.usage.get(stamp);
            r = stamp[0];
            if (!undeployed || r != 0) continue;
            return false;
        } while (!this.usage.compareAndSet(undeployed, undeployed, r, r + 1));
        return true;
    }

    public void release() {
        int r;
        boolean undeployed;
        int[] stamp = new int[1];
        do {
            undeployed = this.usage.get(stamp);
            r = stamp[0];
            assert (r > 0) : "Invalid usages count: " + r;
        } while (!this.usage.compareAndSet(undeployed, undeployed, r, r - 1));
    }

    public boolean obsolete() {
        int[] stamp = new int[1];
        boolean undeployed = this.usage.get(stamp);
        return undeployed && stamp[0] == 0;
    }

    @Override
    @Nullable
    public Map<UUID, IgniteUuid> participants() {
        if (this.clsLdr instanceof GridDeploymentClassLoader) {
            return ((GridDeploymentInfo)((Object)this.clsLdr)).participants();
        }
        return null;
    }

    public void onDeployed(Class<?> cls) {
    }

    public <T extends Annotation> T annotation(Class<?> cls, Class<T> annCls) {
        GridTuple<T> ann;
        ConcurrentMap old;
        ConcurrentMap<Class<Object>, GridTuple<Object>> clsAnns = (ConcurrentHashMap<Class<T>, GridTuple<T>>)this.anns.get(cls);
        if (clsAnns == null && (old = (ConcurrentMap)this.anns.putIfAbsent(cls, clsAnns = new ConcurrentHashMap<Class<T>, GridTuple<T>>())) != null) {
            clsAnns = old;
        }
        if ((ann = (GridTuple<T>)clsAnns.get(annCls)) == null) {
            ann = F.t(U.getAnnotation(cls, annCls));
            clsAnns.putIfAbsent(annCls, ann);
        }
        return (T)((Annotation)ann.get());
    }

    public boolean internalTask(@Nullable ComputeTask task, Class<?> taskCls) {
        assert (taskCls != null);
        Boolean res = (Boolean)this.internalTasks.get(taskCls);
        if (res == null) {
            res = this.annotation(task instanceof GridPeerDeployAware ? ((GridPeerDeployAware)((Object)task)).deployClass() : taskCls, GridInternal.class) != null;
            this.internalTasks.put(taskCls, res);
        }
        return res;
    }

    public boolean visorManagementTask(@Nullable ComputeTask task, @NotNull Class<?> taskCls) {
        return this.annotation(task instanceof GridPeerDeployAware ? ((GridPeerDeployAware)((Object)task)).deployClass() : taskCls, GridVisorManagementTask.class) != null;
    }

    @Nullable
    public <T> T newInstance(Class<T> cls) throws IgniteCheckedException {
        Constructor<T> ctor;
        assert (cls != null);
        GridTuple<Constructor<T>> t = (GridTuple<Constructor<T>>)this.dfltCtorsCache.get(cls);
        if (t == null) {
            try {
                ctor = cls.getDeclaredConstructor(new Class[0]);
                if (ctor != null && !ctor.isAccessible()) {
                    ctor.setAccessible(true);
                }
                t = F.t(ctor);
                this.dfltCtorsCache.putIfAbsent(cls, t);
            }
            catch (NoSuchMethodException e) {
                throw new IgniteCheckedException("Failed to find empty constructor for class: " + cls, e);
            }
        }
        if ((ctor = (Constructor<T>)t.get()) == null) {
            return null;
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IgniteCheckedException("Failed to create new instance for class: " + cls, e);
        }
    }

    public Class<?> existingDeployedClass(String clsName) {
        return (Class)this.clss.get(clsName);
    }

    @Nullable
    public Class<?> deployedClass(String clsName, String ... alias) {
        Class<?> cls;
        block12: {
            cls = (Class<?>)this.clss.get(clsName);
            if (cls == null) {
                try {
                    cls = U.forName(clsName, this.clsLdr);
                    Class<?> cur = this.clss.putIfAbsent(clsName, cls);
                    if (cur == null) {
                        for (String a : alias) {
                            this.clss.putIfAbsent(a, cls);
                        }
                        this.onDeployed(cls);
                    }
                }
                catch (ClassNotFoundException ignored) {
                    for (String a : alias) {
                        cls = (Class<?>)this.clss.get(a);
                        if (cls != null) {
                            return cls;
                        }
                        if (a.equals(clsName)) continue;
                        try {
                            cls = U.forName(a, this.clsLdr);
                        }
                        catch (ClassNotFoundException ignored0) {
                            continue;
                        }
                        Class<?> cur = this.clss.putIfAbsent(a, cls);
                        if (cur == null) {
                            for (String a1 : alias) {
                                if (a1 == a) continue;
                                this.clss.putIfAbsent(a1, cls);
                            }
                            this.onDeployed(cls);
                        }
                        return cls;
                    }
                }
                catch (IgniteException e) {
                    if (X.hasCause((Throwable)e, TimeoutException.class)) break block12;
                    throw e;
                }
            }
        }
        return cls;
    }

    public boolean addDeployedClass(Class<?> cls, String ... aliases) {
        boolean res = false;
        if (cls != null) {
            Class<?> cur = this.clss.putIfAbsent(cls.getName(), cls);
            if (cur == null) {
                this.onDeployed(cls);
                res = true;
            }
            for (String alias : aliases) {
                if (alias == null) continue;
                this.clss.putIfAbsent(alias, cls);
            }
        }
        return res;
    }

    public Collection<Class<?>> deployedClasses() {
        return Collections.unmodifiableCollection(this.clss.values());
    }

    public Map<String, Class<?>> deployedClassMap() {
        return Collections.unmodifiableMap(this.clss);
    }

    @Nullable
    public Object annotatedValue(Object target, Class<? extends Annotation> annCls) throws IgniteCheckedException {
        return this.annotatedValue(target, annCls, null, false).get1();
    }

    private IgniteBiTuple<Object, Boolean> annotatedValue(Object target, Class<? extends Annotation> annCls, @Nullable Set<Object> visited, boolean annFound) throws IgniteCheckedException {
        assert (target != null);
        if (visited != null && visited.contains(target)) {
            return F.t(null, annFound);
        }
        Object val = null;
        Class<?> cls = target.getClass();
        while (!cls.equals(Object.class)) {
            for (Field f : this.fieldsWithAnnotation(cls, annCls)) {
                Object fieldVal;
                f.setAccessible(true);
                try {
                    fieldVal = f.get(target);
                }
                catch (IllegalAccessException e) {
                    throw new IgniteCheckedException("Failed to get annotated field value [cls=" + cls.getName() + ", ann=" + annCls.getSimpleName(), e);
                }
                if (this.needsRecursion(f)) {
                    if (fieldVal == null) continue;
                    if (visited == null) {
                        visited = new GridLeanSet<Object>();
                    }
                    visited.add(target);
                    IgniteBiTuple<Object, Boolean> tup = this.annotatedValue(fieldVal, annCls, visited, annFound);
                    if (!annFound && tup.get2().booleanValue()) {
                        val = tup.get1();
                    }
                    annFound = tup.get2();
                    continue;
                }
                if (annFound) {
                    throw new IgniteCheckedException("Multiple annotations have been found [cls=" + cls.getName() + ", ann=" + annCls.getSimpleName() + "]");
                }
                val = fieldVal;
                annFound = true;
            }
            for (Method m : this.methodsWithAnnotation(cls, annCls)) {
                if (annFound) {
                    throw new IgniteCheckedException("Multiple annotations have been found [cls=" + cls.getName() + ", ann=" + annCls.getSimpleName() + "]");
                }
                m.setAccessible(true);
                try {
                    val = m.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException("Failed to get annotated method value [cls=" + cls.getName() + ", ann=" + annCls.getSimpleName(), e);
                }
                annFound = true;
            }
            cls = cls.getSuperclass();
        }
        return F.t(val, annFound);
    }

    private Iterable<Field> fieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annCls) {
        assert (cls != null);
        assert (annCls != null);
        Collection<Field> fields = this.fieldsFromCache(cls, annCls);
        if (fields == null) {
            fields = new ArrayList<Field>();
            for (Field field : cls.getDeclaredFields()) {
                Annotation ann = field.getAnnotation(annCls);
                if (ann == null && !this.needsRecursion(field)) continue;
                fields.add(field);
            }
            this.cacheFields(cls, annCls, fields);
        }
        return fields;
    }

    private Iterable<Method> methodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annCls) {
        assert (cls != null);
        assert (annCls != null);
        Collection<Method> mtds = this.methodsFromCache(cls, annCls);
        if (mtds == null) {
            mtds = new ArrayList<Method>();
            for (Method mtd : cls.getDeclaredMethods()) {
                Annotation ann = mtd.getAnnotation(annCls);
                if (ann == null) continue;
                mtds.add(mtd);
            }
            this.cacheMethods(cls, annCls, mtds);
        }
        return mtds;
    }

    private boolean needsRecursion(Field f) {
        assert (f != null);
        return f.getName().startsWith("this$") || f.getName().startsWith("val$") || Callable.class.isAssignableFrom(f.getType()) || Runnable.class.isAssignableFrom(f.getType());
    }

    @Nullable
    private Collection<Field> fieldsFromCache(Class<?> cls, Class<? extends Annotation> annCls) {
        assert (cls != null);
        assert (annCls != null);
        Map annCache = (Map)this.fieldCache.get(cls);
        return annCache != null ? (Collection)annCache.get(annCls) : null;
    }

    private void cacheFields(Class<?> cls, Class<? extends Annotation> annCls, Collection<Field> fields) {
        assert (cls != null);
        assert (annCls != null);
        assert (fields != null);
        Map annFields = (Map)((Object)F.addIfAbsent(this.fieldCache, cls, F.newCMap()));
        assert (annFields != null);
        annFields.put(annCls, fields);
    }

    @Nullable
    private Collection<Method> methodsFromCache(Class<?> cls, Class<? extends Annotation> annCls) {
        assert (cls != null);
        assert (annCls != null);
        Map annCache = (Map)this.mtdCache.get(cls);
        return annCache != null ? (Collection)annCache.get(annCls) : null;
    }

    private void cacheMethods(Class<?> cls, Class<? extends Annotation> annCls, Collection<Method> mtds) {
        assert (cls != null);
        assert (annCls != null);
        assert (mtds != null);
        Map annMtds = (Map)((Object)F.addIfAbsent(this.mtdCache, cls, F.newCMap()));
        assert (annMtds != null);
        annMtds.put(annCls, mtds);
    }

    public String toString() {
        int[] stamp = new int[1];
        boolean undeployed = this.usage.get(stamp);
        return S.toString(GridDeployment.class, this, "undeployed", (Object)undeployed, "usage", (Object)stamp[0]);
    }
}

