/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCacheRestartingException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicNearResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicCheckUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicFullUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.UpdateErrors;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicUpdateFuture
extends GridNearAtomicAbstractUpdateFuture {
    private Collection<?> keys;
    private Collection<?> vals;
    private Collection<GridCacheDrInfo> conflictPutVals;
    private Collection<GridCacheVersion> conflictRmvVals;
    @GridToStringInclude
    private Map<UUID, GridNearAtomicAbstractUpdateFuture.PrimaryRequestState> mappings;
    @GridToStringInclude
    private Collection<KeyCacheObject> remapKeys;
    @GridToStringInclude
    private GridNearAtomicAbstractUpdateFuture.PrimaryRequestState singleReq;
    private int resCnt;

    public GridNearAtomicUpdateFuture(GridCacheContext cctx, GridDhtAtomicCache cache, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, Collection<?> keys, @Nullable Collection<?> vals, @Nullable Object[] invokeArgs, @Nullable Collection<GridCacheDrInfo> conflictPutVals, @Nullable Collection<GridCacheVersion> conflictRmvVals, boolean retval, boolean rawRetval, @Nullable ExpiryPolicy expiryPlc, CacheEntryPredicate[] filter, UUID subjId, int taskNameHash, boolean skipStore, boolean keepBinary, boolean recovery, int remapCnt) {
        super(cctx, cache, syncMode, op, invokeArgs, retval, rawRetval, expiryPlc, filter, subjId, taskNameHash, skipStore, keepBinary, recovery, remapCnt);
        assert (vals == null || vals.size() == keys.size());
        assert (conflictPutVals == null || conflictPutVals.size() == keys.size());
        assert (conflictRmvVals == null || conflictRmvVals.size() == keys.size());
        assert (subjId != null);
        this.keys = keys;
        this.vals = vals;
        this.conflictPutVals = conflictPutVals;
        this.conflictRmvVals = conflictRmvVals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNodeLeft(UUID nodeId) {
        long futId;
        List<GridNearAtomicCheckUpdateRequest> checkReqs;
        boolean rcvAll;
        AffinityTopologyVersion remapTopVer0;
        CachePartialUpdateCheckedException err0;
        GridCacheReturn opRes0;
        block27: {
            opRes0 = null;
            err0 = null;
            remapTopVer0 = null;
            rcvAll = false;
            checkReqs = null;
            GridNearAtomicUpdateFuture gridNearAtomicUpdateFuture = this;
            synchronized (gridNearAtomicUpdateFuture) {
                block26: {
                    if (!this.futureMapped()) {
                        return false;
                    }
                    futId = this.futId;
                    if (this.singleReq == null) break block26;
                    if (this.singleReq.req.nodeId.equals(nodeId)) {
                        GridNearAtomicAbstractUpdateRequest req = this.singleReq.onPrimaryFail();
                        if (req != null) {
                            rcvAll = true;
                            GridNearAtomicUpdateResponse res = this.primaryFailedResponse(req);
                            this.singleReq.onPrimaryResponse(res, this.cctx);
                            this.onPrimaryError(req, res);
                        }
                    } else {
                        GridNearAtomicAbstractUpdateFuture.DhtLeftResult res = this.singleReq.onDhtNodeLeft(nodeId);
                        if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.DONE) {
                            rcvAll = true;
                        } else if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.ALL_RCVD_CHECK_PRIMARY) {
                            checkReqs = Collections.singletonList(new GridNearAtomicCheckUpdateRequest(this.singleReq.req));
                        }
                    }
                    if (!rcvAll) break block27;
                    opRes0 = this.opRes;
                    err0 = this.err;
                    remapTopVer0 = this.onAllReceived();
                    break block27;
                }
                if (this.mappings == null) {
                    return false;
                }
                for (Map.Entry<UUID, GridNearAtomicAbstractUpdateFuture.PrimaryRequestState> e : this.mappings.entrySet()) {
                    assert (e.getKey().equals(e.getValue().req.nodeId()));
                    GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState = e.getValue();
                    boolean reqDone = false;
                    if (e.getKey().equals(nodeId)) {
                        GridNearAtomicAbstractUpdateRequest req = reqState.onPrimaryFail();
                        if (req != null) {
                            reqDone = true;
                            GridNearAtomicUpdateResponse res = this.primaryFailedResponse(req);
                            reqState.onPrimaryResponse(res, this.cctx);
                            this.onPrimaryError(req, res);
                        }
                    } else {
                        GridNearAtomicAbstractUpdateFuture.DhtLeftResult res = reqState.onDhtNodeLeft(nodeId);
                        if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.DONE) {
                            reqDone = true;
                        } else if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.ALL_RCVD_CHECK_PRIMARY) {
                            if (checkReqs == null) {
                                checkReqs = new ArrayList<GridNearAtomicCheckUpdateRequest>();
                            }
                            checkReqs.add(new GridNearAtomicCheckUpdateRequest(reqState.req));
                        }
                    }
                    if (!reqDone) continue;
                    assert (this.mappings.size() > this.resCnt) : "[mappings=" + this.mappings.size() + ", cnt=" + this.resCnt + ']';
                    ++this.resCnt;
                    if (this.mappings.size() != this.resCnt) continue;
                    rcvAll = true;
                    opRes0 = this.opRes;
                    err0 = this.err;
                    remapTopVer0 = this.onAllReceived();
                    break;
                }
            }
        }
        if (checkReqs != null) {
            assert (!rcvAll);
            for (int i = 0; i < checkReqs.size(); ++i) {
                this.sendCheckUpdateRequest(checkReqs.get(i));
            }
        } else if (rcvAll) {
            this.finishUpdateFuture(opRes0, err0, remapTopVer0, futId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onDhtResponse(UUID nodeId, GridDhtAtomicNearResponse res) {
        AffinityTopologyVersion remapTopVer0;
        CachePartialUpdateCheckedException err0;
        GridCacheReturn opRes0;
        GridNearAtomicUpdateFuture gridNearAtomicUpdateFuture = this;
        synchronized (gridNearAtomicUpdateFuture) {
            if (!this.checkFutureId(res.futureId())) {
                return;
            }
            if (this.singleReq != null) {
                assert (this.singleReq.req.nodeId().equals(res.primaryId()));
                if (this.opRes == null && res.hasResult()) {
                    this.opRes = res.result();
                }
                if (!this.singleReq.onDhtResponse(nodeId, res)) return;
                opRes0 = this.opRes;
                err0 = this.err;
                remapTopVer0 = this.onAllReceived();
            } else {
                if (this.mappings == null) return;
                GridNearAtomicAbstractUpdateFuture.PrimaryRequestState primaryRequestState = this.mappings.get(res.primaryId());
                GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState = primaryRequestState;
                if (reqState == null) return;
                if (this.opRes == null && res.hasResult()) {
                    this.opRes = res.result();
                }
                if (!reqState.onDhtResponse(nodeId, res)) return;
                assert (this.mappings.size() > this.resCnt) : "[mappings=" + this.mappings.size() + ", cnt=" + this.resCnt + ']';
                ++this.resCnt;
                if (this.mappings.size() != this.resCnt) return;
                opRes0 = this.opRes;
                err0 = this.err;
                remapTopVer0 = this.onAllReceived();
            }
        }
        UpdateErrors errors = res.errors();
        if (errors != null) {
            assert (errors.error() != null);
            this.completeFuture(null, errors.error(), res.futureId());
            return;
        }
        this.finishUpdateFuture(opRes0, err0, remapTopVer0, res.futureId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPrimaryResponse(UUID nodeId, GridNearAtomicUpdateResponse res, boolean nodeErr) {
        boolean rcvAll;
        GridNearAtomicAbstractUpdateRequest req;
        AffinityTopologyVersion remapTopVer0 = null;
        GridCacheReturn opRes0 = null;
        CachePartialUpdateCheckedException err0 = null;
        GridNearAtomicUpdateFuture gridNearAtomicUpdateFuture = this;
        synchronized (gridNearAtomicUpdateFuture) {
            if (!this.checkFutureId(res.futureId())) {
                return;
            }
            if (this.singleReq != null) {
                req = this.singleReq.processPrimaryResponse(nodeId, res);
                if (req == null) {
                    return;
                }
                rcvAll = this.singleReq.onPrimaryResponse(res, this.cctx);
            } else {
                if (this.mappings == null) {
                    return;
                }
                GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState = this.mappings.get(nodeId);
                if (reqState == null) {
                    return;
                }
                req = reqState.processPrimaryResponse(nodeId, res);
                if (req != null) {
                    if (reqState.onPrimaryResponse(res, this.cctx)) {
                        assert (this.mappings.size() > this.resCnt) : "[mappings=" + this.mappings.size() + ", cnt=" + this.resCnt + ']';
                        ++this.resCnt;
                        rcvAll = this.mappings.size() == this.resCnt;
                    } else {
                        assert (this.mappings.size() > this.resCnt) : "[mappings=" + this.mappings.size() + ", cnt=" + this.resCnt + ']';
                        rcvAll = false;
                    }
                } else {
                    return;
                }
            }
            assert (req.topologyVersion().equals(this.topVer)) : req;
            if (res.remapTopologyVersion() != null) {
                assert (!req.topologyVersion().equals(res.remapTopologyVersion()));
                if (this.remapKeys == null) {
                    this.remapKeys = U.newHashSet(req.size());
                }
                this.remapKeys.addAll(req.keys());
                if (this.remapTopVer == null || this.remapTopVer.compareTo(res.remapTopologyVersion()) < 0) {
                    this.remapTopVer = req.topologyVersion();
                }
            } else if (res.error() != null) {
                this.onPrimaryError(req, res);
            } else {
                GridCacheReturn ret = res.returnValue();
                if (this.op == GridCacheOperation.TRANSFORM) {
                    if (ret != null) {
                        assert (ret.value() == null || ret.value() instanceof Map) : ret.value();
                        if (ret.value() != null) {
                            if (this.opRes != null) {
                                this.opRes.mergeEntryProcessResults(ret);
                            } else {
                                this.opRes = ret;
                            }
                        }
                    }
                } else {
                    this.opRes = ret;
                }
            }
            if (rcvAll && (remapTopVer0 = this.onAllReceived()) == null) {
                err0 = this.err;
                opRes0 = this.opRes;
            }
        }
        if (res.error() != null && res.failedKeys() == null) {
            this.completeFuture(null, res.error(), res.futureId());
            return;
        }
        if (rcvAll && this.nearEnabled) {
            if (this.mappings != null) {
                for (GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState : this.mappings.values()) {
                    GridNearAtomicUpdateResponse res0 = reqState.req.response();
                    assert (res0 != null) : reqState;
                    this.updateNear(reqState.req, res0);
                }
            } else if (!nodeErr) {
                this.updateNear(req, res);
            }
        }
        if (remapTopVer0 != null) {
            this.waitAndRemap(remapTopVer0);
            return;
        }
        if (rcvAll) {
            this.completeFuture(opRes0, err0, res.futureId());
        }
    }

    private void waitAndRemap(AffinityTopologyVersion remapTopVer) {
        assert (remapTopVer != null);
        if (this.topLocked) {
            assert (!F.isEmpty(this.remapKeys)) : this.remapKeys;
            CachePartialUpdateCheckedException e = new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
            ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Failed to update keys, topology changed while execute atomic update inside transaction.");
            cause.retryReadyFuture(this.cctx.shared().exchange().affinityReadyFuture(remapTopVer));
            e.add(this.remapKeys, cause);
            this.completeFuture(null, e, null);
            return;
        }
        IgniteInternalFuture<AffinityTopologyVersion> fut = this.cctx.shared().exchange().affinityReadyFuture(remapTopVer);
        if (fut == null) {
            fut = new GridFinishedFuture<AffinityTopologyVersion>(remapTopVer);
        }
        fut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

            @Override
            public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                GridNearAtomicUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                    @Override
                    public void run() {
                        GridNearAtomicUpdateFuture.this.mapOnTopology();
                    }
                });
            }
        });
    }

    @Nullable
    private AffinityTopologyVersion onAllReceived() {
        ClusterTopologyCheckedException topErr;
        assert (Thread.holdsLock(this));
        assert (this.futureMapped()) : this;
        AffinityTopologyVersion remapTopVer0 = null;
        if (this.remapKeys != null) {
            assert (this.remapTopVer != null);
            remapTopVer0 = this.remapTopVer;
        } else if (this.err != null && X.hasCause((Throwable)this.err, CachePartialUpdateCheckedException.class) && X.hasCause((Throwable)this.err, ClusterTopologyCheckedException.class) && this.storeFuture() && --this.remapCnt > 0 && !((topErr = X.cause(this.err, ClusterTopologyCheckedException.class)) instanceof ClusterTopologyServerNotFoundException)) {
            CachePartialUpdateCheckedException cause = X.cause(this.err, CachePartialUpdateCheckedException.class);
            assert (cause != null && cause.topologyVersion() != null) : this.err;
            assert (this.remapKeys == null);
            assert (this.remapTopVer == null);
            this.remapTopVer = remapTopVer0 = new AffinityTopologyVersion(cause.topologyVersion().topologyVersion() + 1L);
            this.err = null;
            Collection failedKeys = cause.failedKeys();
            this.remapKeys = new ArrayList<KeyCacheObject>(failedKeys.size());
            for (Object key : failedKeys) {
                this.remapKeys.add(this.cctx.toCacheKeyObject(key));
            }
        }
        if (remapTopVer0 != null) {
            this.cctx.mvcc().removeAtomicFuture(this.futId);
            this.topVer = AffinityTopologyVersion.ZERO;
            this.futId = 0L;
            this.remapTopVer = null;
        }
        return remapTopVer0;
    }

    private void finishUpdateFuture(GridCacheReturn opRes, CachePartialUpdateCheckedException err, @Nullable AffinityTopologyVersion remapTopVer, long futId) {
        if (this.nearEnabled) {
            if (this.mappings != null) {
                for (GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState : this.mappings.values()) {
                    GridNearAtomicUpdateResponse res0 = reqState.req.response();
                    assert (res0 != null) : reqState;
                    this.updateNear(reqState.req, res0);
                }
            } else {
                assert (this.singleReq != null && this.singleReq.req.response() != null);
                this.updateNear(this.singleReq.req, this.singleReq.req.response());
            }
        }
        if (remapTopVer != null) {
            assert (!F.isEmpty(this.remapKeys));
            this.waitAndRemap(remapTopVer);
            return;
        }
        this.completeFuture(opRes, err, futId);
    }

    private void updateNear(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
        assert (this.nearEnabled);
        if (res.remapTopologyVersion() != null) {
            return;
        }
        GridNearAtomicCache near = (GridNearAtomicCache)this.cctx.dht().near();
        near.processNearAtomicUpdateResponse(req, res);
    }

    @Override
    protected void mapOnTopology() {
        if (this.cache.topology().stopping()) {
            this.completeFuture(null, this.cctx.shared().cache().isCacheRestarting(this.cache.name()) ? new IgniteCacheRestartingException(this.cache.name()) : new CacheStoppedException(this.cache.name()), null);
            return;
        }
        GridDhtTopologyFuture fut = this.cache.topology().topologyVersionFuture();
        if (fut.isDone()) {
            CacheInvalidStateException err = fut.validateCache(this.cctx, this.recovery, false, null, this.keys);
            if (err != null) {
                this.completeFuture(null, err, null);
                return;
            }
        } else {
            assert (!this.topLocked) : this;
            fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> t) {
                    GridNearAtomicUpdateFuture.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                        @Override
                        public void run() {
                            GridNearAtomicUpdateFuture.this.mapOnTopology();
                        }
                    });
                }
            });
            return;
        }
        AffinityTopologyVersion topVer = fut.topologyVersion();
        this.map(topVer, this.remapKeys);
    }

    private void sendUpdateRequests(Map<UUID, GridNearAtomicAbstractUpdateFuture.PrimaryRequestState> mappings) {
        UUID locNodeId = this.cctx.localNodeId();
        GridNearAtomicAbstractUpdateRequest locUpdate = null;
        for (GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState : mappings.values()) {
            GridNearAtomicAbstractUpdateRequest req = reqState.req;
            if (locNodeId.equals(req.nodeId())) {
                assert (locUpdate == null) : "Cannot have more than one local mapping [locUpdate=" + locUpdate + ", req=" + req + ']';
                locUpdate = req;
                continue;
            }
            try {
                if (req.initMappingLocally() && reqState.mappedNodes.isEmpty()) {
                    reqState.resetLocalMapping();
                }
                this.cctx.io().send(req.nodeId(), (GridCacheMessage)req, this.cctx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("Near update fut, sent request [futId=" + req.futureId() + ", node=" + req.nodeId() + ']');
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near update fut, failed to send request [futId=" + req.futureId() + ", node=" + req.nodeId() + ", err=" + e + ']');
                }
                this.onSendError(req, e);
            }
        }
        if (locUpdate != null) {
            this.cache.updateAllAsyncInternal(this.cctx.localNode(), locUpdate, new GridDhtAtomicCache.UpdateReplyClosure(){

                @Override
                public void apply(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
                    if (GridNearAtomicUpdateFuture.this.syncMode != CacheWriteSynchronizationMode.FULL_ASYNC) {
                        GridNearAtomicUpdateFuture.this.onPrimaryResponse(res.nodeId(), res, false);
                    } else if (res.remapTopologyVersion() != null) {
                        ((GridDhtAtomicCache)GridNearAtomicUpdateFuture.this.cctx.cache()).remapToNewPrimary(req);
                    }
                }
            });
        }
        if (this.syncMode == CacheWriteSynchronizationMode.FULL_ASYNC) {
            this.completeFuture(new GridCacheReturn(this.cctx, true, true, null, null, true), null, null);
        }
    }

    @Override
    protected void map(AffinityTopologyVersion topVer) {
        this.map(topVer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void map(AffinityTopologyVersion topVer, @Nullable Collection<KeyCacheObject> remapKeys) {
        Collection<ClusterNode> topNodes = CU.affinityNodes(this.cctx, topVer);
        if (F.isEmpty(topNodes)) {
            this.completeFuture(null, new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid)."), null);
            return;
        }
        long futId = this.cctx.mvcc().nextAtomicId();
        Exception err = null;
        GridNearAtomicAbstractUpdateFuture.PrimaryRequestState singleReq0 = null;
        Map<UUID, GridNearAtomicAbstractUpdateFuture.PrimaryRequestState> mappings0 = null;
        int size = this.keys.size();
        boolean mappingKnown = this.cctx.topology().rebalanceFinished(topVer);
        try {
            Map<UUID, GridNearAtomicAbstractUpdateFuture.PrimaryRequestState> pendingMappings;
            if (size == 1) {
                assert (remapKeys == null || remapKeys.size() == 1);
                singleReq0 = this.mapSingleUpdate(topVer, futId, mappingKnown);
            } else {
                pendingMappings = this.mapUpdate(topNodes, topVer, futId, remapKeys, mappingKnown);
                if (pendingMappings.size() == 1) {
                    singleReq0 = (GridNearAtomicAbstractUpdateFuture.PrimaryRequestState)F.firstValue(pendingMappings);
                } else {
                    mappings0 = pendingMappings;
                    assert (!mappings0.isEmpty() || size == 0) : this;
                }
            }
            pendingMappings = this;
            synchronized (pendingMappings) {
                assert (topVer.topologyVersion() > 0L) : topVer;
                assert (this.topVer == AffinityTopologyVersion.ZERO) : this;
                this.topVer = topVer;
                this.futId = futId;
                this.resCnt = 0;
                this.singleReq = singleReq0;
                this.mappings = mappings0;
                this.remapKeys = null;
            }
            if (this.storeFuture() && !this.cctx.mvcc().addAtomicFuture(futId, this)) {
                assert (this.isDone());
                return;
            }
        }
        catch (Exception e) {
            err = e;
        }
        if (err != null) {
            this.completeFuture(null, err, futId);
            return;
        }
        if (singleReq0 != null) {
            this.sendSingleRequest(singleReq0.req.nodeId(), singleReq0.req);
        } else {
            assert (mappings0 != null);
            if (size == 0) {
                this.completeFuture(new GridCacheReturn(this.cctx, true, true, null, null, true), null, futId);
                return;
            }
            this.sendUpdateRequests(mappings0);
        }
        if (this.syncMode == CacheWriteSynchronizationMode.FULL_ASYNC) {
            this.completeFuture(new GridCacheReturn(this.cctx, true, true, null, null, true), null, futId);
            return;
        }
        if (mappingKnown && this.syncMode == CacheWriteSynchronizationMode.FULL_SYNC && this.cctx.discovery().topologyVersion() != topVer.topologyVersion()) {
            this.checkDhtNodes(futId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkDhtNodes(long futId) {
        GridCacheReturn opRes0 = null;
        CachePartialUpdateCheckedException err0 = null;
        AffinityTopologyVersion remapTopVer0 = null;
        List<GridNearAtomicCheckUpdateRequest> checkReqs = null;
        boolean rcvAll = false;
        GridNearAtomicUpdateFuture gridNearAtomicUpdateFuture = this;
        synchronized (gridNearAtomicUpdateFuture) {
            block15: {
                block16: {
                    if (!this.checkFutureId(futId)) {
                        return;
                    }
                    if (this.singleReq == null) break block16;
                    if (!this.singleReq.req.initMappingLocally()) {
                        return;
                    }
                    GridNearAtomicAbstractUpdateFuture.DhtLeftResult res = this.singleReq.checkDhtNodes(this.cctx);
                    if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.DONE) {
                        opRes0 = this.opRes;
                        err0 = this.err;
                        remapTopVer0 = this.onAllReceived();
                    } else {
                        if (res != GridNearAtomicAbstractUpdateFuture.DhtLeftResult.ALL_RCVD_CHECK_PRIMARY) return;
                        checkReqs = Collections.singletonList(new GridNearAtomicCheckUpdateRequest(this.singleReq.req));
                    }
                    break block15;
                }
                if (this.mappings == null) return;
                for (GridNearAtomicAbstractUpdateFuture.PrimaryRequestState reqState : this.mappings.values()) {
                    if (!reqState.req.initMappingLocally()) continue;
                    GridNearAtomicAbstractUpdateFuture.DhtLeftResult res = reqState.checkDhtNodes(this.cctx);
                    if (res == GridNearAtomicAbstractUpdateFuture.DhtLeftResult.DONE) {
                        assert (this.mappings.size() > this.resCnt) : "[mappings=" + this.mappings.size() + ", cnt=" + this.resCnt + ']';
                        ++this.resCnt;
                        if (this.mappings.size() != this.resCnt) continue;
                        rcvAll = true;
                        opRes0 = this.opRes;
                        err0 = this.err;
                        remapTopVer0 = this.onAllReceived();
                        break;
                    }
                    if (res != GridNearAtomicAbstractUpdateFuture.DhtLeftResult.ALL_RCVD_CHECK_PRIMARY) continue;
                    if (checkReqs == null) {
                        checkReqs = new ArrayList<GridNearAtomicCheckUpdateRequest>(this.mappings.size());
                    }
                    checkReqs.add(new GridNearAtomicCheckUpdateRequest(reqState.req));
                }
            }
        }
        if (checkReqs != null) {
            assert (!rcvAll);
            for (int i = 0; i < checkReqs.size(); ++i) {
                this.sendCheckUpdateRequest(checkReqs.get(i));
            }
            return;
        } else {
            if (!rcvAll) return;
            this.finishUpdateFuture(opRes0, err0, remapTopVer0, futId);
        }
    }

    private Map<UUID, GridNearAtomicAbstractUpdateFuture.PrimaryRequestState> mapUpdate(Collection<ClusterNode> topNodes, AffinityTopologyVersion topVer, Long futId, @Nullable Collection<KeyCacheObject> remapKeys, boolean mappingKnown) throws Exception {
        Iterator<?> it = null;
        if (this.vals != null) {
            it = this.vals.iterator();
        }
        Iterator<GridCacheDrInfo> conflictPutValsIt = null;
        if (this.conflictPutVals != null) {
            conflictPutValsIt = this.conflictPutVals.iterator();
        }
        Iterator<GridCacheVersion> conflictRmvValsIt = null;
        if (this.conflictRmvVals != null) {
            conflictRmvValsIt = this.conflictRmvVals.iterator();
        }
        HashMap<UUID, GridNearAtomicAbstractUpdateFuture.PrimaryRequestState> pendingMappings = U.newHashMap(topNodes.size());
        for (Object key : this.keys) {
            List<ClusterNode> nodes;
            long conflictExpireTime;
            long conflictTtl;
            GridCacheVersion conflictVer;
            Object val;
            if (key == null) {
                throw new NullPointerException("Null key.");
            }
            if (this.vals != null) {
                val = it.next();
                conflictVer = null;
                conflictTtl = -1L;
                conflictExpireTime = -1L;
                if (val == null) {
                    throw new NullPointerException("Null value.");
                }
            } else if (this.conflictPutVals != null) {
                GridCacheDrInfo conflictPutVal = conflictPutValsIt.next();
                val = conflictPutVal.valueEx();
                conflictVer = conflictPutVal.version();
                conflictTtl = conflictPutVal.ttl();
                conflictExpireTime = conflictPutVal.expireTime();
            } else if (this.conflictRmvVals != null) {
                val = null;
                conflictVer = conflictRmvValsIt.next();
                conflictTtl = -1L;
                conflictExpireTime = -1L;
            } else {
                val = null;
                conflictVer = null;
                conflictTtl = -1L;
                conflictExpireTime = -1L;
            }
            if (val == null && this.op != GridCacheOperation.DELETE) continue;
            KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(key);
            if (remapKeys != null && !remapKeys.contains(cacheKey)) continue;
            if (this.op != GridCacheOperation.TRANSFORM) {
                val = this.cctx.toCacheObject(val);
                if (this.op == GridCacheOperation.CREATE || this.op == GridCacheOperation.UPDATE) {
                    this.cctx.validateKeyAndValue(cacheKey, (CacheObject)val);
                }
            } else {
                val = EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), (EntryProcessor)val);
            }
            if (F.isEmpty(nodes = this.cctx.affinity().nodesByKey(cacheKey, topVer))) {
                throw new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid).");
            }
            ClusterNode primary = nodes.get(0);
            boolean needPrimaryRes = !mappingKnown || primary.isLocal() || this.nearEnabled;
            UUID nodeId = primary.id();
            GridNearAtomicAbstractUpdateFuture.PrimaryRequestState mapped = (GridNearAtomicAbstractUpdateFuture.PrimaryRequestState)pendingMappings.get(nodeId);
            if (mapped == null) {
                byte flags = GridNearAtomicAbstractUpdateRequest.flags(this.nearEnabled, this.topLocked, this.retval, mappingKnown, needPrimaryRes, this.skipStore, this.keepBinary, this.recovery);
                GridNearAtomicFullUpdateRequest req = new GridNearAtomicFullUpdateRequest(this.cctx.cacheId(), nodeId, futId, topVer, this.syncMode, this.op, this.expiryPlc, this.invokeArgs, this.filter, this.subjId, this.taskNameHash, flags, this.cctx.deploymentEnabled(), this.keys.size());
                mapped = new GridNearAtomicAbstractUpdateFuture.PrimaryRequestState(req, nodes, false);
                pendingMappings.put(nodeId, mapped);
            }
            if (mapped.req.initMappingLocally()) {
                mapped.addMapping(nodes);
            }
            mapped.req.addUpdateEntry(cacheKey, val, conflictTtl, conflictExpireTime, conflictVer);
        }
        return pendingMappings;
    }

    private GridNearAtomicAbstractUpdateFuture.PrimaryRequestState mapSingleUpdate(AffinityTopologyVersion topVer, Long futId, boolean mappingKnown) throws Exception {
        List<ClusterNode> nodes;
        long conflictExpireTime;
        long conflictTtl;
        GridCacheVersion conflictVer;
        Object val;
        Object key = F.first(this.keys);
        if (this.vals != null) {
            val = F.first(this.vals);
            conflictVer = null;
            conflictTtl = -1L;
            conflictExpireTime = -1L;
        } else if (this.conflictPutVals != null) {
            GridCacheDrInfo conflictPutVal = F.first(this.conflictPutVals);
            val = conflictPutVal.valueEx();
            conflictVer = conflictPutVal.version();
            conflictTtl = conflictPutVal.ttl();
            conflictExpireTime = conflictPutVal.expireTime();
        } else if (this.conflictRmvVals != null) {
            val = null;
            conflictVer = F.first(this.conflictRmvVals);
            conflictTtl = -1L;
            conflictExpireTime = -1L;
        } else {
            val = null;
            conflictVer = null;
            conflictTtl = -1L;
            conflictExpireTime = -1L;
        }
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (val == null && this.op != GridCacheOperation.DELETE) {
            throw new NullPointerException("Null value.");
        }
        KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(key);
        if (this.op != GridCacheOperation.TRANSFORM) {
            val = this.cctx.toCacheObject(val);
            if (this.op == GridCacheOperation.CREATE || this.op == GridCacheOperation.UPDATE) {
                this.cctx.validateKeyAndValue(cacheKey, (CacheObject)val);
            }
        } else {
            val = EntryProcessorResourceInjectorProxy.wrap(this.cctx.kernalContext(), (EntryProcessor)val);
        }
        if (F.isEmpty(nodes = this.cctx.affinity().nodesByKey(cacheKey, topVer))) {
            throw new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid).");
        }
        ClusterNode primary = nodes.get(0);
        boolean needPrimaryRes = !mappingKnown || primary.isLocal() || nodes.size() == 1 || this.nearEnabled;
        byte flags = GridNearAtomicAbstractUpdateRequest.flags(this.nearEnabled, this.topLocked, this.retval, mappingKnown, needPrimaryRes, this.skipStore, this.keepBinary, this.recovery);
        GridNearAtomicFullUpdateRequest req = new GridNearAtomicFullUpdateRequest(this.cctx.cacheId(), primary.id(), futId, topVer, this.syncMode, this.op, this.expiryPlc, this.invokeArgs, this.filter, this.subjId, this.taskNameHash, flags, this.cctx.deploymentEnabled(), 1);
        req.addUpdateEntry(cacheKey, val, conflictTtl, conflictExpireTime, conflictVer);
        return new GridNearAtomicAbstractUpdateFuture.PrimaryRequestState(req, nodes, true);
    }

    @Override
    public synchronized String toString() {
        return S.toString(GridNearAtomicUpdateFuture.class, this, super.toString());
    }
}

