/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.near.CacheVersionedValue;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearSingleGetResponse
extends GridCacheIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    public static final int INVALID_PART_FLAG_MASK = 1;
    public static final int CONTAINS_VAL_FLAG_MASK = 2;
    private long futId;
    private Message res;
    private AffinityTopologyVersion topVer;
    @GridDirectTransient
    private IgniteCheckedException err;
    private byte[] errBytes;
    private byte flags;

    public GridNearSingleGetResponse() {
    }

    public GridNearSingleGetResponse(int cacheId, long futId, AffinityTopologyVersion topVer, @Nullable Message res, boolean invalidPartitions, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.futId = futId;
        this.topVer = topVer;
        this.res = res;
        this.addDepInfo = addDepInfo;
        if (invalidPartitions) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    public void error(IgniteCheckedException err) {
        this.err = err;
    }

    @Override
    public IgniteCheckedException error() {
        return this.err;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer != null ? this.topVer : super.topologyVersion();
    }

    public boolean invalidPartitions() {
        return (this.flags & 1) != 0;
    }

    public boolean containsValue() {
        return (this.flags & 2) != 0;
    }

    public void setContainsValue() {
        this.flags = (byte)(this.flags | 2);
    }

    public Message result() {
        return this.res;
    }

    public long futureId() {
        return this.futId;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.res != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            if (this.res instanceof CacheObject) {
                this.prepareMarshalCacheObject((CacheObject)this.res, cctx);
            } else if (this.res instanceof CacheVersionedValue) {
                ((CacheVersionedValue)this.res).prepareMarshal(cctx.cacheObjectContext());
            } else if (this.res instanceof GridCacheEntryInfo) {
                ((GridCacheEntryInfo)this.res).marshal(cctx);
            }
        }
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx, (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.res != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId());
            if (this.res instanceof CacheObject) {
                ((CacheObject)this.res).finishUnmarshal(cctx.cacheObjectContext(), ldr);
            } else if (this.res instanceof CacheVersionedValue) {
                ((CacheVersionedValue)this.res).finishUnmarshal(cctx, ldr);
            } else if (this.res instanceof GridCacheEntryInfo) {
                ((GridCacheEntryInfo)this.res).unmarshal(cctx, ldr);
            }
        }
        if (this.errBytes != null && this.err == null) {
            this.err = (IgniteCheckedException)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("res", this.res)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.res = reader.readMessage("res");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearSingleGetResponse.class);
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public short directType() {
        return 117;
    }

    @Override
    public byte fieldsCount() {
        return 9;
    }

    @Override
    public String toString() {
        return S.toString(GridNearSingleGetResponse.class, this);
    }
}

