/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

class PreviousQueries {
    private Map<UUID, Node> active = new HashMap<UUID, Node>();
    private boolean init;
    private volatile boolean done;

    PreviousQueries() {
    }

    synchronized void init(Collection<ClusterNode> nodes, Predicate<UUID> alivePredicate) {
        assert (!this.init && !this.done);
        nodes.stream().map(ClusterNode::id).forEach(uuid -> this.active.putIfAbsent((UUID)uuid, new Node()));
        this.active.entrySet().removeIf(e -> !alivePredicate.test((UUID)e.getKey()) || ((Node)e.getValue()).isDone());
        if (this.active.isEmpty()) {
            this.done = true;
        }
        this.init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeFailed(@NotNull UUID nodeId) {
        if (this.done()) {
            return;
        }
        PreviousQueries previousQueries = this;
        synchronized (previousQueries) {
            if (this.init) {
                this.removeAndCheckDone(nodeId);
            }
        }
    }

    void onQueryDone(@NotNull UUID nodeId, long qryId) {
        if (!this.done()) {
            this.onQueryDone0(nodeId, qryId);
        }
    }

    void addActiveQueries(@NotNull UUID nodeId, @NotNull GridLongList queryIds) {
        if (!this.done()) {
            this.addActiveQueries0(nodeId, queryIds);
        }
    }

    boolean done() {
        return this.done;
    }

    private synchronized void onQueryDone0(@NotNull UUID nodeId, long qryId) {
        assert (qryId > 0L);
        Node node = this.active.get(nodeId);
        if (node == null && !this.init) {
            node = new Node();
            this.active.put(nodeId, node);
        }
        if (node != null) {
            boolean wasNull;
            Set<Long> cntrs = node.cntrs;
            boolean bl = wasNull = cntrs == null;
            if (cntrs == null) {
                cntrs = node.cntrs = new HashSet<Long>();
            }
            if (wasNull || !cntrs.remove(qryId)) {
                cntrs.add(-qryId);
            }
            if (this.init && node.isDone()) {
                this.removeAndCheckDone(nodeId);
            }
        }
    }

    private synchronized void addActiveQueries0(@NotNull UUID nodeId, @NotNull GridLongList queryIds) {
        Node node = this.active.get(nodeId);
        if (node == null && !this.init) {
            node = new Node();
            this.active.put(nodeId, node);
        }
        if (node != null) {
            Set<Long> cntrs = node.cntrs;
            boolean wasNull = cntrs == null;
            boolean hasQueries = false;
            for (int i = 0; i < queryIds.size(); ++i) {
                long qryId = queryIds.get(i);
                assert (qryId > 0L);
                if (cntrs == null) {
                    cntrs = node.cntrs = new HashSet<Long>();
                }
                if (!wasNull && cntrs.remove(-qryId)) continue;
                hasQueries |= cntrs.add(qryId);
            }
            if (this.init && !hasQueries) {
                this.removeAndCheckDone(nodeId);
            } else {
                node.init = true;
            }
        }
    }

    private void removeAndCheckDone(@NotNull UUID nodeId) {
        assert (this.init);
        this.active.remove(nodeId);
        if (this.active.isEmpty()) {
            this.done = true;
        }
    }

    private static class Node {
        @GridToStringInclude
        boolean init;
        @GridToStringInclude
        Set<Long> cntrs;

        private Node() {
        }

        boolean isDone() {
            return this.init && (this.cntrs == null || this.cntrs.stream().allMatch(l -> l < 0L));
        }

        public String toString() {
            return S.toString(Node.class, this);
        }
    }
}

