/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.security.AccessControlException;
import java.util.UUID;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListenerException;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.internal.processors.security.AbstractSecurityAwareExternalizable;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;

public class SecurityAwareFilter<K, V>
extends AbstractSecurityAwareExternalizable<CacheEntryEventFilter<K, V>>
implements CacheEntryEventSerializableFilter<K, V> {
    private static final long serialVersionUID = 0L;

    public SecurityAwareFilter() {
    }

    public SecurityAwareFilter(UUID subjectId, CacheEntryEventFilter<K, V> original) {
        super(subjectId, original);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean evaluate(CacheEntryEvent<? extends K, ? extends V> evt) throws CacheEntryListenerException {
        IgniteSecurity security = this.ignite.context().security();
        try (OperationSecurityContext c = security.withContext(this.subjectId);){
            IgniteSandbox sandbox = security.sandbox();
            boolean bl = sandbox.enabled() ? sandbox.execute(() -> ((CacheEntryEventFilter)this.original).evaluate(evt)).booleanValue() : ((CacheEntryEventFilter)this.original).evaluate(evt);
            return bl;
        }
        catch (AccessControlException e) {
            this.logAccessDeniedMessage(e);
            throw e;
        }
    }
}

