/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateImpl;
import org.apache.ignite.internal.processors.cache.verify.ContentionInfo;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

public class ContentionClosure
implements IgniteCallable<ContentionInfo> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    protected transient IgniteEx ignite;
    private int minQueueSize;
    private int maxPrint;

    public ContentionClosure(int minQueueSize, int maxPrint) {
        this.minQueueSize = minQueueSize;
        this.maxPrint = maxPrint;
    }

    @Override
    public ContentionInfo call() throws Exception {
        IgniteTxManager tm = this.ignite.context().cache().context().tm();
        Collection<IgniteInternalTx> activeTxs = tm.activeTransactions();
        ContentionInfo ci = new ContentionInfo();
        ci.setNode(this.ignite.localNode());
        ci.setEntries(new ArrayList<String>());
        for (IgniteInternalTx tx : activeTxs) {
            IgniteTxLocalAdapter tx0;
            IgniteTxLocalState state0;
            if (ci.getEntries().size() == this.maxPrint) break;
            if (!tx.local() || !((state0 = (tx0 = (IgniteTxLocalAdapter)tx).txState()) instanceof IgniteTxStateImpl)) continue;
            IgniteTxStateImpl state = (IgniteTxStateImpl)state0;
            Collection<IgniteTxEntry> entries = state.allEntriesCopy();
            IgniteTxEntry bad = null;
            int qSize = 0;
            for (IgniteTxEntry entry : entries) {
                Collection<GridCacheMvccCandidate> rmts;
                Collection<GridCacheMvccCandidate> locs;
                GridCacheEntryEx cached = entry.cached();
                while (true) {
                    try {
                        locs = cached.localCandidates(new GridCacheVersion[0]);
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        cached = entry.context().cache().entryEx(entry.key());
                        continue;
                    }
                    break;
                }
                if (locs != null) {
                    qSize += locs.size();
                }
                if ((rmts = cached.remoteMvccSnapshot(new GridCacheVersion[0])) != null) {
                    qSize += rmts.size();
                }
                if (qSize >= this.minQueueSize) {
                    bad = entry;
                    break;
                }
                qSize = 0;
            }
            if (bad == null) continue;
            StringBuilder b = new StringBuilder();
            b.append("TxEntry [cacheId=").append(bad.cacheId()).append(", key=").append(bad.key()).append(", queue=").append(qSize).append(", op=").append((Object)bad.op()).append(", val=").append(bad.value()).append(", tx=").append(CU.txString(tx)).append(", other=[");
            IgniteTxState st = tx.txState();
            if (st instanceof IgniteTxStateImpl) {
                IgniteTxStateImpl st0 = (IgniteTxStateImpl)st;
                Collection<IgniteTxEntry> cp = st0.allEntriesCopy();
                for (IgniteTxEntry entry : cp) {
                    if (entry == bad) continue;
                    b.append(entry.toString()).append('\n');
                }
            }
            b.append("]]");
            ci.getEntries().add(b.toString());
        }
        return ci;
    }
}

