/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.systemview.walker.SqlQueryHistoryViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlQueryViewWalker;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryHistory;
import org.apache.ignite.internal.processors.query.QueryHistoryKey;
import org.apache.ignite.internal.processors.query.QueryHistoryTracker;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.systemview.view.SqlQueryHistoryView;
import org.apache.ignite.spi.systemview.view.SqlQueryView;
import org.jetbrains.annotations.Nullable;

public class RunningQueryManager {
    public static final String SQL_USER_QUERIES_REG_NAME = "sql.queries.user";
    public static final String SQL_QRY_VIEW = MetricUtils.metricName("sql", "queries");
    public static final String SQL_QRY_VIEW_DESC = "Running SQL queries.";
    public static final String SQL_QRY_HIST_VIEW = MetricUtils.metricName("sql", "queries", "history");
    public static final String SQL_QRY_HIST_VIEW_DESC = "SQL queries history.";
    private final ConcurrentMap<Long, GridRunningQueryInfo> runs = new ConcurrentHashMap<Long, GridRunningQueryInfo>();
    private final AtomicLong qryIdGen = new AtomicLong();
    private final UUID localNodeId;
    private final int histSz;
    private volatile QueryHistoryTracker qryHistTracker;
    private final LongAdderMetric successQrsCnt;
    private final AtomicLongMetric failedQrsCnt;
    private final AtomicLongMetric canceledQrsCnt;
    private final GridKernalContext ctx;
    private final ThreadLocal<GridRunningQueryInfo> currQryInfo = new ThreadLocal();

    public RunningQueryManager(GridKernalContext ctx) {
        this.ctx = ctx;
        this.localNodeId = ctx.localNodeId();
        this.histSz = ctx.config().getSqlConfiguration().getSqlQueryHistorySize();
        this.qryHistTracker = new QueryHistoryTracker(this.histSz);
        ctx.systemView().registerView(SQL_QRY_VIEW, SQL_QRY_VIEW_DESC, new SqlQueryViewWalker(), this.runs.values(), SqlQueryView::new);
        ctx.systemView().registerView(SQL_QRY_HIST_VIEW, SQL_QRY_HIST_VIEW_DESC, new SqlQueryHistoryViewWalker(), this.qryHistTracker.queryHistory().values(), SqlQueryHistoryView::new);
        MetricRegistry userMetrics = ctx.metric().registry(SQL_USER_QUERIES_REG_NAME);
        this.successQrsCnt = userMetrics.longAdderMetric("success", "Number of successfully executed user queries that have been started on this node.");
        this.failedQrsCnt = userMetrics.longMetric("failed", "Total number of failed by any reason (cancel, etc) queries that have been started on this node.");
        this.canceledQrsCnt = userMetrics.longMetric("canceled", "Number of canceled queries that have been started on this node. This metric number included in the general 'failed' metric.");
    }

    public Long register(String qry, GridCacheQueryType qryType, String schemaName, boolean loc, @Nullable GridQueryCancel cancel) {
        long qryId = this.qryIdGen.incrementAndGet();
        GridRunningQueryInfo run = new GridRunningQueryInfo(qryId, this.localNodeId, qry, qryType, schemaName, System.currentTimeMillis(), this.ctx.performanceStatistics().enabled() ? System.nanoTime() : 0L, cancel, loc);
        GridRunningQueryInfo preRun = this.runs.putIfAbsent(qryId, run);
        if (this.ctx.performanceStatistics().enabled()) {
            this.currQryInfo.set(run);
        }
        assert (preRun == null) : "Running query already registered [prev_qry=" + preRun + ", newQry=" + run + ']';
        return qryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Long qryId, @Nullable Throwable failReason) {
        if (qryId == null) {
            return;
        }
        boolean failed = failReason != null;
        GridRunningQueryInfo qry = (GridRunningQueryInfo)this.runs.remove(qryId);
        if (qry == null) {
            return;
        }
        Span qrySpan = qry.span();
        try {
            if (failed) {
                qrySpan.addTag("error", failReason::getMessage);
            }
            if (this.isSqlQuery(qry)) {
                qry.runningFuture().onDone();
                this.qryHistTracker.collectHistory(qry, failed);
                if (!failed) {
                    this.successQrsCnt.increment();
                } else {
                    this.failedQrsCnt.increment();
                    if (QueryUtils.wasCancelled(failReason)) {
                        this.canceledQrsCnt.increment();
                    }
                }
            }
            if (this.ctx.performanceStatistics().enabled() && qry.startTimeNanos() > 0L) {
                this.ctx.performanceStatistics().query(qry.queryType(), qry.query(), qry.requestId(), qry.startTime(), System.nanoTime() - qry.startTimeNanos(), !failed);
            }
        }
        finally {
            qrySpan.end();
        }
    }

    public void trackRequestId(long reqId) {
        GridRunningQueryInfo info;
        if (this.ctx.performanceStatistics().enabled() && (info = this.currQryInfo.get()) != null) {
            info.requestId(reqId);
        }
    }

    public List<GridRunningQueryInfo> runningSqlQueries() {
        ArrayList<GridRunningQueryInfo> res = new ArrayList<GridRunningQueryInfo>();
        for (GridRunningQueryInfo run : this.runs.values()) {
            if (!this.isSqlQuery(run)) continue;
            res.add(run);
        }
        return res;
    }

    private boolean isSqlQuery(GridRunningQueryInfo runningQryInfo) {
        return runningQryInfo.queryType() == GridCacheQueryType.SQL_FIELDS || runningQryInfo.queryType() == GridCacheQueryType.SQL;
    }

    public Collection<GridRunningQueryInfo> longRunningQueries(long duration) {
        ArrayList<GridRunningQueryInfo> res = new ArrayList<GridRunningQueryInfo>();
        long curTime = System.currentTimeMillis();
        for (GridRunningQueryInfo runningQryInfo : this.runs.values()) {
            if (!runningQryInfo.longQuery(curTime, duration)) continue;
            res.add(runningQryInfo);
        }
        return res;
    }

    public void cancel(Long qryId) {
        GridRunningQueryInfo run = (GridRunningQueryInfo)this.runs.get(qryId);
        if (run != null) {
            run.cancel();
        }
    }

    public void stop() {
        Iterator iter = this.runs.values().iterator();
        while (iter.hasNext()) {
            try {
                GridRunningQueryInfo r = (GridRunningQueryInfo)iter.next();
                iter.remove();
                r.cancel();
            }
            catch (Exception exception) {}
        }
    }

    public Map<QueryHistoryKey, QueryHistory> queryHistoryMetrics() {
        return this.qryHistTracker.queryHistory();
    }

    @Nullable
    public GridRunningQueryInfo runningQueryInfo(Long qryId) {
        return (GridRunningQueryInfo)this.runs.get(qryId);
    }

    public void resetQueryHistoryMetrics() {
        this.qryHistTracker = new QueryHistoryTracker(this.histSz);
    }

    public String toString() {
        return S.toString(RunningQueryManager.class, this);
    }
}

