/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.client.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.rest.client.message.GridClientAbstractMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridClientCacheRequest
extends GridClientAbstractMessage {
    private static final long serialVersionUID = 0L;
    private GridCacheOperation op;
    private String cacheName;
    private Object key;
    private Object val;
    private Object val2;
    private Map<Object, Object> vals;
    private int cacheFlagsOn;

    public GridClientCacheRequest() {
    }

    public GridClientCacheRequest(GridCacheOperation op) {
        this.op = op;
    }

    public GridCacheOperation operation() {
        return this.op;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public void cacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Object key() {
        return this.key;
    }

    public void key(Object key) {
        this.key = key;
    }

    public Object value() {
        return this.val;
    }

    public void value(Object val) {
        this.val = val;
    }

    public Object value2() {
        return this.val2;
    }

    public void value2(Object val2) {
        this.val2 = val2;
    }

    public Map<Object, Object> values() {
        return this.vals;
    }

    public void values(Map<Object, Object> vals) {
        this.vals = vals;
    }

    public void keys(Iterable<Object> keys) {
        this.vals = new HashMap<Object, Object>();
        for (Object k : keys) {
            this.vals.put(k, null);
        }
    }

    public void cacheFlagsOn(int cacheFlagsOn) {
        this.cacheFlagsOn = cacheFlagsOn;
    }

    public int cacheFlagsOn() {
        return this.cacheFlagsOn;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        U.writeEnum(out, this.op);
        U.writeString(out, this.cacheName);
        out.writeObject(this.key);
        out.writeObject(this.val);
        out.writeObject(this.val2);
        U.writeMap(out, this.vals);
        out.writeInt(this.cacheFlagsOn);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.op = GridCacheOperation.fromOrdinal(in.readByte());
        this.cacheName = U.readString(in);
        this.key = in.readObject();
        this.val = in.readObject();
        this.val2 = in.readObject();
        this.vals = U.readMap(in);
        this.cacheFlagsOn = in.readInt();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [op=" + (Object)((Object)this.op) + ", key=" + this.key + ", val=" + this.val + ", val2=" + this.val2 + ", vals=" + this.vals + ", cacheFlagsOn=" + this.cacheFlagsOn + "]";
    }

    public static enum GridCacheOperation {
        PUT,
        PUT_ALL,
        GET,
        GET_ALL,
        RMV,
        RMV_ALL,
        REPLACE,
        CAS,
        METRICS,
        APPEND,
        PREPEND;

        private static final GridCacheOperation[] VALS;

        @Nullable
        public static GridCacheOperation fromOrdinal(int ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = GridCacheOperation.values();
        }
    }
}

