/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.UUID;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;

public class SqlKillContinuousQueryCommand
implements SqlCommand {
    public static final String KILL_CQ_FORMAT = "Format of the query is KILL CONTINUOUS '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321' '6fa749ee-7cf8-4635-be10-36a1c75267a7_12345'";
    private UUID originNodeId;
    private UUID routineId;

    @Override
    public SqlCommand parse(SqlLexer lex) {
        if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING) {
            this.originNodeId = UUID.fromString(lex.token());
            if (lex.shift() && lex.tokenType() == SqlLexerTokenType.STRING) {
                this.routineId = UUID.fromString(lex.token());
                return this;
            }
            throw SqlParserUtils.error(lex, "Expected routine id. Format of the query is KILL CONTINUOUS '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321' '6fa749ee-7cf8-4635-be10-36a1c75267a7_12345'");
        }
        throw SqlParserUtils.error(lex, "Expected origin node id. Format of the query is KILL CONTINUOUS '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321' '6fa749ee-7cf8-4635-be10-36a1c75267a7_12345'");
    }

    @Override
    public String schemaName() {
        return null;
    }

    @Override
    public void schemaName(String schemaName) {
    }

    public UUID getRoutineId() {
        return this.routineId;
    }

    public UUID getOriginNodeId() {
        return this.originNodeId;
    }
}

