/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteRunnable;

public class GridNioMessageTracker
implements IgniteRunnable {
    private static final long serialVersionUID = 0L;
    private final GridNioSession ses;
    private final int msgQueueLimit;
    private final Lock lock = new ReentrantLock();
    private final AtomicInteger msgCnt = new AtomicInteger();
    private volatile boolean paused;

    public GridNioMessageTracker(GridNioSession ses, int msgQueueLimit) {
        this.ses = ses;
        this.msgQueueLimit = msgQueueLimit;
    }

    @Override
    public void run() {
        int cur;
        int cnt = 0;
        while ((cur = this.msgCnt.get()) != 0 && !this.msgCnt.compareAndSet(cur, cnt = cur - 1)) {
        }
        assert (cnt >= 0) : "Invalid count [cnt=" + cnt + ", this=" + this + ']';
        if (cnt < this.msgQueueLimit && this.paused && this.lock.tryLock()) {
            try {
                if (this.paused && this.msgCnt.get() < this.msgQueueLimit) {
                    this.ses.resumeReads();
                    this.paused = false;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void onMessageProcessed() {
        this.run();
    }

    public void onMessageReceived() {
        int cnt = this.msgCnt.incrementAndGet();
        if (cnt >= this.msgQueueLimit && !this.paused) {
            this.lock.lock();
            try {
                if (!this.paused && this.msgCnt.get() >= this.msgQueueLimit) {
                    this.ses.pauseReads();
                    this.paused = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.paused && this.msgCnt.get() < this.msgQueueLimit && this.lock.tryLock()) {
                try {
                    if (this.paused) {
                        this.ses.resumeReads();
                        this.paused = false;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    public String toString() {
        return S.toString(GridNioMessageTracker.class, this, "hash", (Object)System.identityHashCode(this));
    }
}

