/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.nio.GridAbstractCommunicationClient;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

public class GridTcpNioCommunicationClient
extends GridAbstractCommunicationClient {
    private final GridNioSession ses;
    private final IgniteLogger log;

    public GridTcpNioCommunicationClient(int connIdx, GridNioSession ses, IgniteLogger log) {
        super(connIdx);
        assert (ses != null);
        assert (log != null);
        this.ses = ses;
        this.log = log;
    }

    public GridNioSession session() {
        return this.ses;
    }

    @Override
    public void doHandshake(IgniteInClosure2X<InputStream, OutputStream> handshakeC) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean close() {
        boolean res = super.close();
        if (res) {
            this.ses.close();
        }
        return res;
    }

    @Override
    public void forceClose() {
        super.forceClose();
        this.ses.close();
    }

    @Override
    public void sendMessage(byte[] data, int len) throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendMessage(ByteBuffer data) throws IgniteCheckedException {
        if (this.closed()) {
            throw new IgniteCheckedException("Client was closed: " + this);
        }
        GridNioFuture<?> fut = this.ses.send(data);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public boolean sendMessage(@Nullable UUID nodeId, Message msg, IgniteInClosure<IgniteException> c) throws IgniteCheckedException {
        try {
            assert (nodeId == null);
            this.ses.sendNoFuture(msg, c);
        }
        catch (IgniteCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send message [client=" + this + ", err=" + e + ']');
            }
            if (e.getCause() instanceof IOException) {
                this.ses.close();
                return true;
            }
            throw new IgniteCheckedException("Failed to send message [client=" + this + ']', e);
        }
        return false;
    }

    @Override
    public boolean async() {
        return true;
    }

    @Override
    public long getIdleTime() {
        long now = U.currentTimeMillis();
        return Math.min(Math.min(now - this.ses.lastReceiveTime(), now - this.ses.lastSendScheduleTime()), now - this.ses.lastSendTime());
    }

    @Override
    public String toString() {
        return S.toString(GridTcpNioCommunicationClient.class, this, super.toString());
    }
}

