/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.worker;

import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.apache.ignite.internal.util.worker.WorkProgressDispatcher;
import org.jetbrains.annotations.Nullable;

public abstract class GridWorker
implements Runnable,
WorkProgressDispatcher {
    protected final IgniteLogger log;
    private final String name;
    private final String igniteInstanceName;
    private final GridWorkerListener lsnr;
    private volatile boolean finished;
    protected volatile boolean isCancelled;
    private volatile Thread runner;
    private volatile long heartbeatTs;
    private final Object mux = new Object();

    protected GridWorker(String igniteInstanceName, String name, IgniteLogger log, @Nullable GridWorkerListener lsnr) {
        assert (name != null);
        assert (log != null);
        this.igniteInstanceName = igniteInstanceName;
        this.name = name;
        this.log = log;
        this.lsnr = lsnr;
    }

    protected GridWorker(@Nullable String igniteInstanceName, String name, IgniteLogger log) {
        this(igniteInstanceName, name, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.updateHeartbeat();
        this.runner = Thread.currentThread();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Grid runnable started: " + this.name);
        }
        try {
            if (this.isCancelled) {
                this.runner.interrupt();
            }
            if (this.lsnr != null) {
                this.lsnr.onStarted(this);
            }
            this.body();
        }
        catch (IgniteInterruptedCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caught interrupted exception: " + e);
            }
        }
        catch (InterruptedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caught interrupted exception: " + e);
            }
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            if (!(X.hasCause(e, InterruptedException.class) || X.hasCause(e, IgniteInterruptedCheckedException.class) || X.hasCause(e, IgniteInterruptedException.class))) {
                U.error(this.log, "Runtime error caught during grid runnable execution: " + this, e);
            } else {
                U.warn(this.log, "Runtime exception occurred during grid runnable execution caused by thread interruption: " + e.getMessage());
            }
            if (e instanceof Error) {
                throw e;
            }
        }
        finally {
            Object e = this.mux;
            synchronized (e) {
                this.finished = true;
                this.mux.notifyAll();
            }
            this.cleanup();
            if (this.lsnr != null) {
                this.lsnr.onStopped(this);
            }
            if (this.log.isDebugEnabled()) {
                if (this.isCancelled) {
                    this.log.debug("Grid runnable finished due to cancellation: " + this.name);
                } else if (this.runner.isInterrupted()) {
                    this.log.debug("Grid runnable finished due to interruption without cancellation: " + this.name);
                } else {
                    this.log.debug("Grid runnable finished normally: " + this.name);
                }
            }
            this.runner = null;
        }
    }

    protected abstract void body() throws InterruptedException, IgniteInterruptedCheckedException;

    protected void cleanup() {
    }

    public Thread runner() {
        return this.runner;
    }

    public String igniteInstanceName() {
        return this.igniteInstanceName;
    }

    public String name() {
        return this.name;
    }

    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + this);
        }
        this.isCancelled = true;
        Thread runner = this.runner;
        if (runner != null) {
            runner.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Joining grid runnable: " + this);
        }
        if (this.runner == null && this.isCancelled || this.finished) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            while (!this.finished) {
                this.mux.wait();
            }
        }
    }

    public boolean isCancelled() {
        Thread runner = this.runner;
        return this.isCancelled || runner != null && runner.isInterrupted();
    }

    public boolean isDone() {
        return this.finished;
    }

    @Override
    public long heartbeatTs() {
        return this.heartbeatTs;
    }

    @Override
    public void updateHeartbeat() {
        this.heartbeatTs = U.currentTimeMillis();
    }

    @Override
    public void blockingSectionBegin() {
        this.heartbeatTs = Long.MAX_VALUE;
    }

    @Override
    public void blockingSectionEnd() {
        this.updateHeartbeat();
    }

    protected void onIdle() {
        if (this.lsnr != null) {
            this.lsnr.onIdle(this);
        }
    }

    public String toString() {
        Thread runner = this.runner;
        return S.toString(GridWorker.class, this, "hashCode", (Object)this.hashCode(), "interrupted", runner != null ? Boolean.valueOf(runner.isInterrupted()) : "unknown", "runner", (Object)(runner == null ? "null" : runner.getName()));
    }
}

