/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.encryption;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.encryption.VisorCacheGroupEncryptionTaskResult;
import org.apache.ignite.internal.visor.encryption.VisorReencryptionRateTaskArg;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorReencryptionRateTask
extends VisorMultiNodeTask<VisorReencryptionRateTaskArg, VisorCacheGroupEncryptionTaskResult<Double>, ReencryptionRateJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorReencryptionRateTaskArg, ReencryptionRateJobResult> job(VisorReencryptionRateTaskArg arg) {
        return new VisorReencryptionRateJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorCacheGroupEncryptionTaskResult<Double> reduce0(List<ComputeJobResult> results) {
        HashMap<UUID, Double> jobResults = new HashMap<UUID, Double>();
        HashMap<UUID, IgniteException> exceptions = new HashMap<UUID, IgniteException>();
        for (ComputeJobResult res : results) {
            UUID nodeId = res.getNode().id();
            if (res.getException() != null) {
                exceptions.put(nodeId, res.getException());
                continue;
            }
            ReencryptionRateJobResult dtoRes = (ReencryptionRateJobResult)res.getData();
            jobResults.put(nodeId, dtoRes.limit());
        }
        return new VisorCacheGroupEncryptionTaskResult<Double>(jobResults, exceptions);
    }

    protected static class ReencryptionRateJobResult
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;
        private Double limit;

        public ReencryptionRateJobResult() {
        }

        public ReencryptionRateJobResult(Double limit) {
            this.limit = limit;
        }

        public Double limit() {
            return this.limit;
        }

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeDouble(this.limit);
        }

        @Override
        protected void readExternalData(byte ver, ObjectInput in) throws IOException, ClassNotFoundException {
            this.limit = in.readDouble();
        }
    }

    private static class VisorReencryptionRateJob
    extends VisorJob<VisorReencryptionRateTaskArg, ReencryptionRateJobResult> {
        private static final long serialVersionUID = 0L;

        protected VisorReencryptionRateJob(VisorReencryptionRateTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ReencryptionRateJobResult run(VisorReencryptionRateTaskArg arg) throws IgniteException {
            double prevRate = this.ignite.context().encryption().getReencryptionRate();
            if (arg.rate() != null) {
                this.ignite.context().encryption().setReencryptionRate(arg.rate());
            }
            return new ReencryptionRateJobResult(prevRate);
        }
    }
}

