/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.util.IgniteUtils;

public class ClusterNodeView {
    private final ClusterNode n;

    public ClusterNodeView(ClusterNode n) {
        this.n = n;
    }

    @Order
    public UUID nodeId() {
        return this.n.id();
    }

    @Order(value=1)
    public String consistentId() {
        return IgniteUtils.toStringSafe(this.n.consistentId());
    }

    @Order(value=6)
    public String addresses() {
        return IgniteUtils.toStringSafe(this.n.addresses());
    }

    @Order(value=7)
    public String hostnames() {
        return IgniteUtils.toStringSafe(this.n.hostNames());
    }

    @Order(value=5)
    public long nodeOrder() {
        return this.n.order();
    }

    @Order(value=2)
    public String version() {
        return this.n.version().toString();
    }

    public boolean isLocal() {
        return this.n.isLocal();
    }

    @Order(value=4)
    public boolean isDaemon() {
        return this.n.isDaemon();
    }

    @Order(value=3)
    public boolean isClient() {
        return this.n.isClient();
    }
}

