/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.startup;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;

public class BasicWarmupClosure
implements IgniteInClosure<IgniteConfiguration> {
    private static final long serialVersionUID = 9175346848249957458L;
    public static final int DFLT_GRID_CNT = 2;
    public static final int DFLT_ITERATION_CNT = 30000;
    public static final int DFLT_KEY_RANGE = 10000;
    private int gridCnt = 2;
    private static final SimpleDateFormat WARMUP_DATE_FMT = new SimpleDateFormat("HH:mm:ss");
    private int threadCnt = Runtime.getRuntime().availableProcessors() * 2;
    private int iterCnt = 30000;
    private int keyRange = 10000;
    private int discoveryPort = 27000;
    @GridToStringInclude
    private String[] warmupMethods = new String[]{"put", "putx", "get", "remove", "removex", "putIfAbsent", "replace"};

    public int getGridCount() {
        return this.gridCnt;
    }

    public void setGridCount(int gridCnt) {
        this.gridCnt = gridCnt;
    }

    public String[] getWarmupMethods() {
        return this.warmupMethods;
    }

    public void setWarmupMethods(String ... warmupMethods) {
        this.warmupMethods = warmupMethods;
    }

    public int getThreadCount() {
        return this.threadCnt;
    }

    public void setThreadCount(int threadCnt) {
        this.threadCnt = threadCnt;
    }

    public int getIterationCount() {
        return this.iterCnt;
    }

    public void setIterationCount(int iterCnt) {
        this.iterCnt = iterCnt;
    }

    public int getKeyRange() {
        return this.keyRange;
    }

    public void setKeyRange(int keyRange) {
        this.keyRange = keyRange;
    }

    public int getDiscoveryPort() {
        return this.discoveryPort;
    }

    public void setDiscoveryPort(int discoveryPort) {
        this.discoveryPort = discoveryPort;
    }

    @Override
    public void apply(IgniteConfiguration gridCfg) {
        IgniteConfiguration cfg = this.prepareConfiguration(gridCfg);
        if (cfg == null) {
            return;
        }
        BasicWarmupClosure.out("Starting grids to warmup caches [gridCnt=" + this.gridCnt + ", caches=" + cfg.getCacheConfiguration().length + ']');
        LinkedList<Ignite> ignites = new LinkedList<Ignite>();
        String old = System.getProperty("IGNITE_UPDATE_NOTIFIER");
        try {
            System.setProperty("IGNITE_UPDATE_NOTIFIER", "false");
            TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
            for (int i = 0; i < this.gridCnt; ++i) {
                IgniteConfiguration cfg0 = new IgniteConfiguration(cfg);
                TcpDiscoverySpi discoSpi = new TcpDiscoverySpi();
                discoSpi.setIpFinder(ipFinder);
                discoSpi.setLocalPort(this.discoveryPort);
                cfg0.setDiscoverySpi(discoSpi);
                cfg0.setGridLogger(new NullLogger());
                cfg0.setIgniteInstanceName("ignite-warmup-grid-" + i);
                ignites.add(Ignition.start(cfg0));
            }
            this.doWarmup(ignites);
        }
        catch (Exception e) {
            throw new IgniteException(e);
        }
        finally {
            for (Ignite ignite : ignites) {
                Ignition.stop(ignite.name(), false);
            }
            BasicWarmupClosure.out("Stopped warmup grids.");
            if (old == null) {
                old = "false";
            }
            System.setProperty("IGNITE_UPDATE_NOTIFIER", old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void doWarmup(Iterable<Ignite> grids) throws Exception {
        Ignite first = F.first(grids);
        ExecutorService svc = Executors.newFixedThreadPool(this.threadCnt);
        try {
            for (IgniteCacheProxy<?, ?> cache : ((IgniteKernal)first).caches()) {
                if (!cache.context().userCache()) continue;
                GridCacheAdapter<?, ?> cache0 = cache.context().cache();
                for (String warmupMethod : this.warmupMethods) {
                    ArrayList futs = new ArrayList(this.threadCnt);
                    for (int i = 0; i < this.threadCnt; ++i) {
                        void var13_22;
                        switch (warmupMethod) {
                            case "get": {
                                GetCallable getCallable = new GetCallable(cache0);
                                break;
                            }
                            case "put": {
                                PutCallable putCallable = new PutCallable(cache0);
                                break;
                            }
                            case "putx": {
                                PutxCallable putxCallable = new PutxCallable(cache0);
                                break;
                            }
                            case "remove": {
                                RemoveCallable removeCallable = new RemoveCallable(cache0);
                                break;
                            }
                            case "removex": {
                                RemovexCallable removexCallable = new RemovexCallable(cache0);
                                break;
                            }
                            case "putIfAbsent": {
                                PutIfAbsentCallable putIfAbsentCallable = new PutIfAbsentCallable(cache0);
                                break;
                            }
                            case "replace": {
                                ReplaceCallable replaceCallable = new ReplaceCallable(cache0);
                                break;
                            }
                            default: {
                                throw new IgniteCheckedException("Unsupported warmup method: " + warmupMethod);
                            }
                        }
                        futs.add(svc.submit(var13_22));
                    }
                    BasicWarmupClosure.out("Running warmup [cacheName=" + U.maskName(cache.getName()) + ", method=" + warmupMethod + ']');
                    for (Future future : futs) {
                        future.get();
                    }
                    for (int key = 0; key < this.keyRange; ++key) {
                        cache0.getAndRemove(key);
                    }
                }
            }
        }
        finally {
            svc.shutdownNow();
        }
    }

    private static void out(String msg) {
        System.out.println('[' + WARMUP_DATE_FMT.format(new Date(System.currentTimeMillis())) + "][WARMUP][" + Thread.currentThread().getName() + ']' + ' ' + msg);
    }

    private IgniteConfiguration prepareConfiguration(IgniteConfiguration gridCfg) {
        if (F.isEmpty(gridCfg.getCacheConfiguration())) {
            return null;
        }
        IgniteConfiguration cp = new IgniteConfiguration();
        cp.setConnectorConfiguration(null);
        ArrayList<CacheConfiguration> reduced = new ArrayList<CacheConfiguration>();
        for (CacheConfiguration ccfg : gridCfg.getCacheConfiguration()) {
            if (CU.isSystemCache(ccfg.getName()) || this.matches(reduced, ccfg)) continue;
            CacheConfiguration ccfgCp = new CacheConfiguration(ccfg);
            ccfgCp.setCacheStoreFactory(null);
            ccfgCp.setWriteBehindEnabled(false);
            reduced.add(ccfgCp);
        }
        if (F.isEmpty(reduced)) {
            return null;
        }
        CacheConfiguration[] res = new CacheConfiguration[reduced.size()];
        reduced.toArray(res);
        cp.setCacheConfiguration(res);
        return cp;
    }

    private boolean matches(Iterable<CacheConfiguration> reduced, CacheConfiguration ccfg) {
        for (CacheConfiguration ccfg0 : reduced) {
            if (!this.matches(ccfg0, ccfg)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(CacheConfiguration ccfg0, CacheConfiguration ccfg1) {
        return F.eq((Object)ccfg0.getCacheMode(), (Object)ccfg1.getCacheMode()) && F.eq(ccfg0.getBackups(), ccfg1.getBackups()) && F.eq((Object)ccfg0.getAtomicityMode(), (Object)ccfg1.getAtomicityMode());
    }

    public String toString() {
        return S.toString(BasicWarmupClosure.class, this);
    }

    private class ReplaceCallable
    extends BaseWarmupCallable {
        private ReplaceCallable(IgniteInternalCache<Object, Object> cache) {
            super(cache);
        }

        @Override
        protected void operation(int key) throws Exception {
            this.cache.replace(key, key, key);
        }
    }

    private class PutIfAbsentCallable
    extends BaseWarmupCallable {
        private PutIfAbsentCallable(IgniteInternalCache<Object, Object> cache) {
            super(cache);
        }

        @Override
        protected void operation(int key) throws Exception {
            this.cache.getAndPutIfAbsent(key, key);
        }
    }

    private class RemovexCallable
    extends BaseWarmupCallable {
        private RemovexCallable(IgniteInternalCache<Object, Object> cache) {
            super(cache);
        }

        @Override
        protected void operation(int key) throws Exception {
            this.cache.remove(key);
        }
    }

    private class RemoveCallable
    extends BaseWarmupCallable {
        private RemoveCallable(IgniteInternalCache<Object, Object> cache) {
            super(cache);
        }

        @Override
        protected void operation(int key) throws Exception {
            this.cache.getAndRemove(key);
        }
    }

    private class PutxCallable
    extends BaseWarmupCallable {
        private PutxCallable(IgniteInternalCache<Object, Object> cache) {
            super(cache);
        }

        @Override
        protected void operation(int key) throws Exception {
            this.cache.put(key, key);
        }
    }

    private class PutCallable
    extends BaseWarmupCallable {
        private PutCallable(IgniteInternalCache<Object, Object> cache) {
            super(cache);
        }

        @Override
        protected void operation(int key) throws Exception {
            this.cache.getAndPut(key, key);
        }
    }

    private class GetCallable
    extends BaseWarmupCallable {
        private GetCallable(IgniteInternalCache<Object, Object> cache) {
            super(cache);
        }

        @Override
        protected void operation(int key) throws Exception {
            this.cache.get(key);
        }
    }

    private abstract class BaseWarmupCallable
    implements Callable<Object> {
        protected final IgniteInternalCache<Object, Object> cache;

        protected BaseWarmupCallable(IgniteInternalCache<Object, Object> cache) {
            this.cache = cache;
        }

        @Override
        public Object call() throws Exception {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            for (int i = 0; i < BasicWarmupClosure.this.iterCnt; ++i) {
                this.operation(rnd.nextInt(BasicWarmupClosure.this.keyRange));
            }
            return null;
        }

        protected abstract void operation(int var1) throws Exception;
    }
}

