/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.deliverer;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.deliverer.DelivererKey;
import org.apache.bifromq.deliverer.DeliveryCall;
import org.apache.bifromq.deliverer.DeliveryCallResult;
import org.apache.bifromq.deliverer.TopicMessagePackHolder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.plugin.subbroker.DeliveryPack;
import org.apache.bifromq.plugin.subbroker.DeliveryPackage;
import org.apache.bifromq.plugin.subbroker.DeliveryReply;
import org.apache.bifromq.plugin.subbroker.DeliveryRequest;
import org.apache.bifromq.plugin.subbroker.DeliveryResult;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.apache.bifromq.plugin.subbroker.TypeUtil;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchDeliveryCall
implements IBatchCall<DeliveryCall, DeliveryCallResult, DelivererKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDeliveryCall.class);
    private final IDistClient distClient;
    private final IDeliverer deliverer;
    private final DelivererKey batcherKey;
    private Queue<ICallTask<DeliveryCall, DeliveryCallResult, DelivererKey>> tasks = new ArrayDeque<ICallTask<DeliveryCall, DeliveryCallResult, DelivererKey>>(128);
    private Map<String, Map<TopicMessagePackHolder, Set<MatchInfo>>> batch = new HashMap<String, Map<TopicMessagePackHolder, Set<MatchInfo>>>(128);

    BatchDeliveryCall(IDistClient distClient, IDeliverer deliverer, DelivererKey batcherKey) {
        this.distClient = distClient;
        this.deliverer = deliverer;
        this.batcherKey = batcherKey;
    }

    public void reset(boolean abort) {
        if (abort) {
            this.tasks = new ArrayDeque<ICallTask<DeliveryCall, DeliveryCallResult, DelivererKey>>(128);
            this.batch = new HashMap<String, Map<TopicMessagePackHolder, Set<MatchInfo>>>(128);
        }
    }

    public void add(ICallTask<DeliveryCall, DeliveryCallResult, DelivererKey> callTask) {
        this.batch.computeIfAbsent(((DeliveryCall)callTask.call()).tenantId, k -> new LinkedHashMap(128)).computeIfAbsent(((DeliveryCall)callTask.call()).messagePackHolder, k -> new HashSet()).add(((DeliveryCall)callTask.call()).matchInfo);
        this.tasks.add(callTask);
    }

    public CompletableFuture<Void> execute() {
        return this.execute(this.tasks, this.batch);
    }

    private CompletableFuture<Void> execute(Queue<ICallTask<DeliveryCall, DeliveryCallResult, DelivererKey>> tasks, Map<String, Map<TopicMessagePackHolder, Set<MatchInfo>>> batch) {
        DeliveryRequest.Builder requestBuilder = DeliveryRequest.newBuilder();
        Iterator<Map.Entry<String, Map<TopicMessagePackHolder, Set<MatchInfo>>>> itr = batch.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Map<TopicMessagePackHolder, Set<MatchInfo>>> entry = itr.next();
            String tenantId = entry.getKey();
            Map<TopicMessagePackHolder, Set<MatchInfo>> pack = entry.getValue();
            DeliveryPackage.Builder packageBuilder = DeliveryPackage.newBuilder();
            pack.forEach((msgPackWrapper, matchInfos) -> {
                DeliveryPack.Builder packBuilder = DeliveryPack.newBuilder().setMessagePack(msgPackWrapper.messagePack);
                matchInfos.forEach(arg_0 -> ((DeliveryPack.Builder)packBuilder).addMatchInfo(arg_0));
                packageBuilder.addPack(packBuilder.build());
            });
            requestBuilder.putPackage(tenantId, packageBuilder.build());
            itr.remove();
        }
        DeliveryRequest request = requestBuilder.build();
        return this.execute(request, tasks);
    }

    private CompletableFuture<Void> execute(DeliveryRequest request, Queue<ICallTask<DeliveryCall, DeliveryCallResult, DelivererKey>> tasks) {
        return ((CompletableFuture)this.deliverer.deliver(request).exceptionally(e -> {
            log.error("Unexpected exception", e);
            return DeliveryReply.newBuilder().setCode(DeliveryReply.Code.ERROR).build();
        })).thenAccept(reply -> {
            switch (reply.getCode()) {
                case OK: {
                    ICallTask task;
                    Map resultMap = TypeUtil.toMap((Map)reply.getResultMap());
                    HashMap<String, Set> staleMatchInfos = new HashMap<String, Set>();
                    block9: while ((task = (ICallTask)tasks.poll()) != null) {
                        DeliveryResult.Code result = (DeliveryResult.Code)resultMap.getOrDefault(((DeliveryCall)task.call()).tenantId, Collections.emptyMap()).get(((DeliveryCall)task.call()).matchInfo);
                        if (result != null) {
                            if (result == DeliveryResult.Code.NO_SUB || result == DeliveryResult.Code.NO_RECEIVER) {
                                staleMatchInfos.computeIfAbsent(((DeliveryCall)task.call()).tenantId, k -> new HashSet()).add(((DeliveryCall)task.call()).matchInfo);
                            }
                            switch (result) {
                                case OK: {
                                    task.resultPromise().complete(DeliveryCallResult.OK);
                                    continue block9;
                                }
                                case NO_SUB: {
                                    task.resultPromise().complete(DeliveryCallResult.NO_SUB);
                                    continue block9;
                                }
                                case NO_RECEIVER: {
                                    task.resultPromise().complete(DeliveryCallResult.NO_RECEIVER);
                                    continue block9;
                                }
                            }
                            task.resultPromise().complete(DeliveryCallResult.ERROR);
                            continue;
                        }
                        log.warn("No deliver result: tenantId={}, route={}, batcherKey={}", new Object[]{((DeliveryCall)task.call()).tenantId, ((DeliveryCall)task.call()).matchInfo, ((DeliveryCall)task.call()).delivererKey});
                        task.resultPromise().complete(DeliveryCallResult.OK);
                    }
                    for (Map.Entry entry : staleMatchInfos.entrySet()) {
                        String tenantId = (String)entry.getKey();
                        Set matchInfos = (Set)entry.getValue();
                        for (MatchInfo matchInfo : matchInfos) {
                            log.debug("Stale match info: tenantId={}, topicFilter={}, receiverId={}, delivererKey={}, subBrokerId={}", new Object[]{tenantId, matchInfo.getMatcher().getMqttTopicFilter(), matchInfo.getReceiverId(), this.batcherKey.delivererKey(), this.batcherKey.subBrokerId()});
                            this.distClient.removeRoute(System.nanoTime(), tenantId, matchInfo.getMatcher(), matchInfo.getReceiverId(), this.batcherKey.delivererKey(), this.batcherKey.subBrokerId(), matchInfo.getIncarnation());
                        }
                    }
                    break;
                }
                case BACK_PRESSURE_REJECTED: {
                    ICallTask task;
                    while ((task = (ICallTask)tasks.poll()) != null) {
                        task.resultPromise().complete(DeliveryCallResult.BACK_PRESSURE_REJECTED);
                    }
                    throw new BackPressureException("Batch delivery call back-pressured");
                }
                default: {
                    ICallTask task;
                    assert (reply.getCode() == DeliveryReply.Code.ERROR);
                    while ((task = (ICallTask)tasks.poll()) != null) {
                        task.resultPromise().complete(DeliveryCallResult.ERROR);
                    }
                    break block0;
                }
            }
        });
    }
}

