/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.inbox.storage.proto.InboxMetadata;
import org.apache.bifromq.inbox.store.IInboxMetaCache;
import org.apache.bifromq.inbox.store.canon.TenantIdCanon;
import org.apache.bifromq.inbox.store.schema.KVSchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxMetaCache
implements IInboxMetaCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxMetaCache.class);
    private final Cache<CacheKey, InboxMetadata> cache;

    InboxMetaCache(Duration expireAfterAccess) {
        this.cache = Caffeine.newBuilder().expireAfterAccess(expireAfterAccess).build();
    }

    @Override
    public Optional<InboxMetadata> get(String tenantId, String inboxId, long incarnation, IInboxMetaCache.InboxMetadataProvider provider) {
        return Optional.ofNullable((InboxMetadata)this.cache.get((Object)new CacheKey((String)TenantIdCanon.TENANT_ID_INTERNER.intern((Object)tenantId), inboxId, incarnation), key -> provider.get(key.tenantId, key.inboxId, key.incarnation)));
    }

    @Override
    public void upsert(String tenantId, InboxMetadata metadata) {
        this.cache.put((Object)new CacheKey((String)TenantIdCanon.TENANT_ID_INTERNER.intern((Object)tenantId), metadata.getInboxId(), metadata.getIncarnation()), (Object)metadata);
    }

    @Override
    public void remove(String tenantId, String inboxId, long incarnation) {
        this.cache.invalidate((Object)new CacheKey((String)TenantIdCanon.TENANT_ID_INTERNER.intern((Object)tenantId), inboxId, incarnation));
    }

    @Override
    public void reset(Boundary boundary) {
        for (CacheKey key : this.cache.asMap().keySet()) {
            if (BoundaryUtil.inRange((ByteString)KVSchemaUtil.inboxStartKeyPrefix((String)key.tenantId, (String)key.inboxId), (Boundary)boundary)) continue;
            this.cache.invalidate((Object)key);
        }
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }

    private record CacheKey(String tenantId, String inboxId, long incarnation) {
    }
}

