/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */


package org.jboss.errai.ui.test.nestedcyclic.client.res;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
@Dependent
public class ChildComponent extends Composite {

  // this component introduces a cycle between parent and child, to ensure Errai UI works with cyclical/proxied beans
  @Inject
  private ParentComponent parent;

  @Inject
  @DataField
  private Label c1;

  @Inject
  @DataField("c2")
  private Button content2;

  @PostConstruct
  public void init() {
    c1.getElement().setAttribute("id", "c1a");
    c1.setText("Added by component");
    content2.getElement().setAttribute("id", "c1b");
  }

  public Label getC1() {
    return c1;
  }

  public Button getC2() {
    return content2;
  }

}
