/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { SceSim__FactMappingValuesTypes } from "@kie-tools/scesim-marshaller/dist/schemas/scesim-1_8/ts-gen/types";

export function dupliacteRow({
  rowIndex,
  factMappingValues,
}: {
  rowIndex: number;
  factMappingValues: SceSim__FactMappingValuesTypes[];
}) {
  /* It simply clones a Scenario (Row) and adds it in a current-cloned Scenario list */
  const factMappingValuesItems = JSON.parse(
    JSON.stringify(factMappingValues[rowIndex].factMappingValues.FactMappingValue)
  );

  const newScenario = {
    factMappingValues: {
      FactMappingValue: factMappingValuesItems,
    },
  };

  factMappingValues.splice(rowIndex, 0, newScenario);
}
