/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.BearerAuthenticationParameters;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogPrivilege;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.ExternalCatalog;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.NamespacePrivilege;
import org.apache.polaris.core.admin.model.OAuthClientCredentialsParameters;
import org.apache.polaris.core.admin.model.PolicyGrant;
import org.apache.polaris.core.admin.model.PolicyPrivilege;
import org.apache.polaris.core.admin.model.PrincipalWithCredentials;
import org.apache.polaris.core.admin.model.PrincipalWithCredentialsCredentials;
import org.apache.polaris.core.admin.model.TableGrant;
import org.apache.polaris.core.admin.model.TablePrivilege;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRoleRequest;
import org.apache.polaris.core.admin.model.ViewGrant;
import org.apache.polaris.core.admin.model.ViewPrivilege;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.CatalogRoleEntity;
import org.apache.polaris.core.entity.NamespaceEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.entity.PrincipalRoleEntity;
import org.apache.polaris.core.entity.table.IcebergTableLikeEntity;
import org.apache.polaris.core.entity.table.federated.FederatedEntities;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.dao.entity.CreateCatalogResult;
import org.apache.polaris.core.persistence.dao.entity.CreatePrincipalResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.exceptions.NoSuchPolicyException;
import org.apache.polaris.core.secrets.UserSecretReference;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.StorageLocation;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.azure.AzureStorageConfigurationInfo;
import org.apache.polaris.service.catalog.common.CatalogHandler;
import org.apache.polaris.service.config.ReservedProperties;
import org.apache.polaris.service.types.PolicyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisAdminService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisAdminService.class);
    private final CallContext callContext;
    private final PolarisEntityManager entityManager;
    private final SecurityContext securityContext;
    private final AuthenticatedPolarisPrincipal authenticatedPrincipal;
    private final PolarisAuthorizer authorizer;
    private final PolarisMetaStoreManager metaStoreManager;
    private final UserSecretsManager userSecretsManager;
    private final ReservedProperties reservedProperties;
    private PolarisResolutionManifest resolutionManifest = null;

    public PolarisAdminService(@NotNull CallContext callContext, @NotNull PolarisEntityManager entityManager, @NotNull PolarisMetaStoreManager metaStoreManager, @NotNull UserSecretsManager userSecretsManager, @NotNull SecurityContext securityContext, @NotNull PolarisAuthorizer authorizer, @NotNull ReservedProperties reservedProperties) {
        this.callContext = callContext;
        this.entityManager = entityManager;
        this.metaStoreManager = metaStoreManager;
        this.securityContext = securityContext;
        PolarisDiagnostics diagServices = callContext.getPolarisCallContext().getDiagServices();
        diagServices.checkNotNull((Object)securityContext, "null_security_context");
        diagServices.checkNotNull((Object)securityContext.getUserPrincipal(), "null_security_context");
        diagServices.check(securityContext.getUserPrincipal() instanceof AuthenticatedPolarisPrincipal, "unexpected_principal_type", "class={}", new Object[]{securityContext.getUserPrincipal().getClass().getName()});
        this.authenticatedPrincipal = (AuthenticatedPolarisPrincipal)securityContext.getUserPrincipal();
        this.authorizer = authorizer;
        this.userSecretsManager = userSecretsManager;
        this.reservedProperties = reservedProperties;
    }

    private PolarisCallContext getCurrentPolarisContext() {
        return this.callContext.getPolarisCallContext();
    }

    private UserSecretsManager getUserSecretsManager() {
        return this.userSecretsManager;
    }

    private Optional<CatalogEntity> findCatalogByName(String name) {
        return Optional.ofNullable(this.resolutionManifest.getResolvedReferenceCatalogEntity()).map(path -> CatalogEntity.of((PolarisBaseEntity)path.getRawLeafEntity()));
    }

    private Optional<PrincipalEntity> findPrincipalByName(String name) {
        return Optional.ofNullable(this.resolutionManifest.getResolvedTopLevelEntity(name, PolarisEntityType.PRINCIPAL)).map(path -> PrincipalEntity.of((PolarisBaseEntity)path.getRawLeafEntity()));
    }

    private Optional<PrincipalRoleEntity> findPrincipalRoleByName(String name) {
        return Optional.ofNullable(this.resolutionManifest.getResolvedTopLevelEntity(name, PolarisEntityType.PRINCIPAL_ROLE)).map(path -> PrincipalRoleEntity.of((PolarisBaseEntity)path.getRawLeafEntity()));
    }

    private Optional<CatalogRoleEntity> findCatalogRoleByName(String catalogName, String name) {
        return Optional.ofNullable(this.resolutionManifest.getResolvedPath((Object)name)).map(path -> CatalogRoleEntity.of((PolarisBaseEntity)path.getRawLeafEntity()));
    }

    private void authorizeBasicRootOperationOrThrow(PolarisAuthorizableOperation op) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, null);
        this.resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper rootContainerWrapper = this.resolutionManifest.getResolvedRootContainerEntityAsPath();
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedPrincipalRoleEntities(), op, rootContainerWrapper, null);
    }

    private void authorizeBasicTopLevelEntityOperationOrThrow(PolarisAuthorizableOperation op, String topLevelEntityName, PolarisEntityType entityType) {
        String referenceCatalogName = entityType == PolarisEntityType.CATALOG ? topLevelEntityName : null;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, topLevelEntityName, entityType, referenceCatalogName);
    }

    private void authorizeBasicTopLevelEntityOperationOrThrow(PolarisAuthorizableOperation op, String topLevelEntityName, PolarisEntityType entityType, @Nullable String referenceCatalogName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, referenceCatalogName);
        this.resolutionManifest.addTopLevelName(topLevelEntityName, entityType, false);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("TopLevelEntity of type %s does not exist: %s", new Object[]{entityType, topLevelEntityName});
        }
        PolarisResolvedPathWrapper topLevelEntityWrapper = this.resolutionManifest.getResolvedTopLevelEntity(topLevelEntityName, entityType);
        if (topLevelEntityWrapper.getResolvedLeafEntity().getEntity().getId() == this.authenticatedPrincipal.getPrincipalEntity().getId() && (op.equals((Object)PolarisAuthorizableOperation.ROTATE_CREDENTIALS) || op.equals((Object)PolarisAuthorizableOperation.RESET_CREDENTIALS))) {
            LOGGER.atDebug().addKeyValue("principalName", (Object)topLevelEntityName).log("Allowing rotate own credentials");
            return;
        }
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, topLevelEntityWrapper, null);
    }

    private void authorizeBasicCatalogRoleOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, String catalogRoleName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, catalogName);
        this.resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        this.resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        if (target == null) {
            throw new NotFoundException("CatalogRole does not exist: %s", new Object[]{catalogRoleName});
        }
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, null);
    }

    private void authorizeGrantOnRootContainerToPrincipalRoleOperationOrThrow(PolarisAuthorizableOperation op, String principalRoleName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, null);
        this.resolutionManifest.addTopLevelName(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, false);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to grant on root to %s", new Object[]{status.getFailedToResolvedEntityName(), principalRoleName});
        }
        PolarisResolvedPathWrapper rootContainerWrapper = this.resolutionManifest.getResolvedRootContainerEntityAsPath();
        PolarisResolvedPathWrapper principalRoleWrapper = this.resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, rootContainerWrapper, principalRoleWrapper);
    }

    private void authorizeGrantOnTopLevelEntityToPrincipalRoleOperationOrThrow(PolarisAuthorizableOperation op, String topLevelEntityName, PolarisEntityType topLevelEntityType, String principalRoleName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, null);
        this.resolutionManifest.addTopLevelName(topLevelEntityName, topLevelEntityType, false);
        this.resolutionManifest.addTopLevelName(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, false);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to assign %s of type %s to %s", new Object[]{status.getFailedToResolvedEntityName(), topLevelEntityName, topLevelEntityType, principalRoleName});
        }
        PolarisResolvedPathWrapper topLevelEntityWrapper = this.resolutionManifest.getResolvedTopLevelEntity(topLevelEntityName, topLevelEntityType);
        PolarisResolvedPathWrapper principalRoleWrapper = this.resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, topLevelEntityWrapper, principalRoleWrapper);
    }

    private void authorizeGrantOnPrincipalRoleToPrincipalOperationOrThrow(PolarisAuthorizableOperation op, String principalRoleName, String principalName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, null);
        this.resolutionManifest.addTopLevelName(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, false);
        this.resolutionManifest.addTopLevelName(principalName, PolarisEntityType.PRINCIPAL, false);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to assign %s to %s", new Object[]{status.getFailedToResolvedEntityName(), principalRoleName, principalName});
        }
        PolarisResolvedPathWrapper principalRoleWrapper = this.resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        PolarisResolvedPathWrapper principalWrapper = this.resolutionManifest.getResolvedTopLevelEntity(principalName, PolarisEntityType.PRINCIPAL);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, principalRoleWrapper, principalWrapper);
    }

    private void authorizeGrantOnCatalogRoleToPrincipalRoleOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, String catalogRoleName, String principalRoleName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, catalogName);
        this.resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        this.resolutionManifest.addTopLevelName(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, false);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to assign %s.%s to %s", new Object[]{status.getFailedToResolvedEntityName(), catalogName, catalogRoleName, principalRoleName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            throw new NotFoundException("Entity %s not found when trying to assign %s.%s to %s", new Object[]{status.getFailedToResolvePath(), catalogName, catalogRoleName, principalRoleName});
        }
        PolarisResolvedPathWrapper principalRoleWrapper = this.resolutionManifest.getResolvedTopLevelEntity(principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        PolarisResolvedPathWrapper catalogRoleWrapper = this.resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, catalogRoleWrapper, principalRoleWrapper);
    }

    private void authorizeGrantOnCatalogOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, String catalogRoleName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, catalogName);
        this.resolutionManifest.addTopLevelName(catalogName, PolarisEntityType.CATALOG, false);
        this.resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
        }
        PolarisResolvedPathWrapper catalogWrapper = this.resolutionManifest.getResolvedTopLevelEntity(catalogName, PolarisEntityType.CATALOG);
        PolarisResolvedPathWrapper catalogRoleWrapper = this.resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, catalogWrapper, catalogRoleWrapper);
    }

    private void authorizeGrantOnNamespaceOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, Namespace namespace, String catalogRoleName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, catalogName);
        this.resolutionManifest.addPath(new ResolverPath(Arrays.asList(namespace.levels()), PolarisEntityType.NAMESPACE), (Object)namespace);
        this.resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            if (status.getFailedToResolvePath().getLastEntityType() == PolarisEntityType.NAMESPACE) {
                throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{status.getFailedToResolvePath().getEntityNames()});
            }
            throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
        }
        PolarisResolvedPathWrapper namespaceWrapper = this.resolutionManifest.getResolvedPath((Object)namespace, true);
        PolarisResolvedPathWrapper catalogRoleWrapper = this.resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, namespaceWrapper, catalogRoleWrapper);
    }

    private void authorizeGrantOnTableLikeOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, List<PolarisEntitySubType> subTypes, TableIdentifier identifier, String catalogRoleName) {
        PolarisResolvedPathWrapper tableLikeWrapper;
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, catalogName);
        this.resolutionManifest.addPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)identifier), PolarisEntityType.TABLE_LIKE), (Object)identifier);
        this.resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            if (status.getFailedToResolvePath().getLastEntityType() == PolarisEntityType.TABLE_LIKE) {
                CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
            } else {
                throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
            }
        }
        if (!subTypes.contains((tableLikeWrapper = this.resolutionManifest.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE, true)).getRawLeafEntity().getSubType())) {
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
        }
        PolarisResolvedPathWrapper catalogRoleWrapper = this.resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, tableLikeWrapper, catalogRoleWrapper);
    }

    private void authorizeGrantOnPolicyOperationOrThrow(PolarisAuthorizableOperation op, String catalogName, PolicyIdentifier identifier, String catalogRoleName) {
        this.resolutionManifest = this.entityManager.prepareResolutionManifest(this.callContext, this.securityContext, catalogName);
        this.resolutionManifest.addPath(new ResolverPath(PolarisCatalogHelpers.identifierToList((Namespace)identifier.getNamespace(), (String)identifier.getName()), PolarisEntityType.POLICY), (Object)identifier);
        this.resolutionManifest.addPath(new ResolverPath(List.of(catalogRoleName), PolarisEntityType.CATALOG_ROLE), (Object)catalogRoleName);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED) {
            throw new NotFoundException("Catalog not found: %s", new Object[]{catalogName});
        }
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            if (status.getFailedToResolvePath().getLastEntityType() == PolarisEntityType.POLICY) {
                throw new NoSuchPolicyException(String.format("Policy does not exist: %s", identifier));
            }
            throw new NotFoundException("CatalogRole not found: %s.%s", new Object[]{catalogName, catalogRoleName});
        }
        PolarisResolvedPathWrapper policyWrapper = this.resolutionManifest.getResolvedPath((Object)identifier, true);
        PolarisResolvedPathWrapper catalogRoleWrapper = this.resolutionManifest.getResolvedPath((Object)catalogRoleName, true);
        this.authorizer.authorizeOrThrow(this.callContext, this.authenticatedPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, policyWrapper, catalogRoleWrapper);
    }

    private Set<String> getCatalogLocations(CatalogEntity catalogEntity) {
        HashSet<String> catalogLocations = new HashSet<String>();
        catalogLocations.add(this.terminateWithSlash(catalogEntity.getDefaultBaseLocation()));
        if (catalogEntity.getStorageConfigurationInfo() != null) {
            catalogLocations.addAll(catalogEntity.getStorageConfigurationInfo().getAllowedLocations().stream().map(this::terminateWithSlash).toList());
        }
        return catalogLocations;
    }

    private String terminateWithSlash(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith("/")) {
            return path;
        }
        return path + "/";
    }

    private boolean catalogOverlapsWithExistingCatalog(CatalogEntity catalogEntity) {
        boolean allowOverlappingCatalogUrls = (Boolean)this.getCurrentPolarisContext().getConfigurationStore().getConfiguration(this.callContext.getRealmContext(), (PolarisConfiguration)FeatureConfiguration.ALLOW_OVERLAPPING_CATALOG_URLS);
        if (allowOverlappingCatalogUrls) {
            return false;
        }
        Set<String> newCatalogLocations = this.getCatalogLocations(catalogEntity);
        return this.listCatalogsUnsafe().stream().filter(Objects::nonNull).map(CatalogEntity::new).anyMatch(existingCatalog -> {
            if (existingCatalog.getName().equals(catalogEntity.getName())) {
                return false;
            }
            return this.getCatalogLocations((CatalogEntity)existingCatalog).stream().map(StorageLocation::of).anyMatch(existingLocation -> newCatalogLocations.stream().anyMatch(newLocationString -> {
                StorageLocation newLocation = StorageLocation.of((String)newLocationString);
                return newLocation.isChildOf(existingLocation) || existingLocation.isChildOf(newLocation);
            }));
        });
    }

    private Map<String, UserSecretReference> extractSecretReferences(CreateCatalogRequest catalogRequest, PolarisEntity forEntity) {
        ExternalCatalog externalCatalog;
        HashMap<String, UserSecretReference> secretReferences = new HashMap<String, UserSecretReference>();
        Catalog catalog = catalogRequest.getCatalog();
        UserSecretsManager secretsManager = this.getUserSecretsManager();
        if (catalog instanceof ExternalCatalog && (externalCatalog = (ExternalCatalog)catalog).getConnectionConfigInfo() != null) {
            ConnectionConfigInfo connectionConfig = externalCatalog.getConnectionConfigInfo();
            AuthenticationParameters authenticationParameters = connectionConfig.getAuthenticationParameters();
            switch (authenticationParameters.getAuthenticationType()) {
                case OAUTH: {
                    OAuthClientCredentialsParameters oauthClientCredentialsModel = (OAuthClientCredentialsParameters)authenticationParameters;
                    String inlineClientSecret = oauthClientCredentialsModel.getClientSecret();
                    UserSecretReference secretReference = secretsManager.writeSecret(inlineClientSecret, (PolarisEntityCore)forEntity);
                    secretReferences.put("inlineClientSecretReference", secretReference);
                    break;
                }
                case BEARER: {
                    BearerAuthenticationParameters bearerAuthenticationParametersModel = (BearerAuthenticationParameters)authenticationParameters;
                    String inlineBearerToken = bearerAuthenticationParametersModel.getBearerToken();
                    UserSecretReference secretReference = secretsManager.writeSecret(inlineBearerToken, (PolarisEntityCore)forEntity);
                    secretReferences.put("inlineBearerTokenReference", secretReference);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported authentication type: " + String.valueOf(authenticationParameters.getAuthenticationType()));
                }
            }
        }
        return secretReferences;
    }

    private boolean requiresSecretReferenceExtraction(CreateCatalogRequest catalogRequest) {
        ExternalCatalog externalCatalog;
        Catalog catalog = catalogRequest.getCatalog();
        return catalog instanceof ExternalCatalog && (externalCatalog = (ExternalCatalog)catalog).getConnectionConfigInfo() != null;
    }

    public PolarisEntity createCatalog(CreateCatalogRequest catalogRequest) {
        CreateCatalogResult catalogResult;
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_CATALOG;
        this.authorizeBasicRootOperationOrThrow(op);
        CatalogEntity entity = CatalogEntity.fromCatalog((Catalog)catalogRequest.getCatalog());
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        if (this.catalogOverlapsWithExistingCatalog(entity)) {
            throw new ValidationException("Cannot create Catalog %s. One or more of its locations overlaps with an existing catalog", new Object[]{entity.getName()});
        }
        entity = ((CatalogEntity.Builder)((CatalogEntity.Builder)((CatalogEntity.Builder)new CatalogEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCreateTimestamp(System.currentTimeMillis())).setProperties(this.reservedProperties.removeReservedProperties(entity.getPropertiesAsMap()))).build();
        if (this.requiresSecretReferenceExtraction(catalogRequest)) {
            LOGGER.atDebug().addKeyValue("catalogName", (Object)entity.getName()).log("Extracting secret references to create federated catalog");
            FeatureConfiguration.enforceFeatureEnabledOrThrow((CallContext)this.callContext, (FeatureConfiguration)FeatureConfiguration.ENABLE_CATALOG_FEDERATION);
            Map<String, UserSecretReference> processedSecretReferences = this.extractSecretReferences(catalogRequest, (PolarisEntity)entity);
            entity = new CatalogEntity.Builder(entity).setConnectionConfigInfoDpoWithSecrets(((ExternalCatalog)catalogRequest.getCatalog()).getConnectionConfigInfo(), processedSecretReferences).build();
        }
        if ((catalogResult = this.metaStoreManager.createCatalog(this.getCurrentPolarisContext(), (PolarisBaseEntity)entity, List.of())).alreadyExists()) {
            throw new AlreadyExistsException("Cannot create Catalog %s. Catalog already exists or resolution failed", new Object[]{entity.getName()});
        }
        return PolarisEntity.of((PolarisBaseEntity)catalogResult.getCatalog());
    }

    public void deleteCatalog(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_CATALOG;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.CATALOG);
        PolarisEntity entity = (PolarisEntity)this.findCatalogByName(name).orElseThrow(() -> new NotFoundException("Catalog %s not found", new Object[]{name}));
        PolarisCallContext polarisCallContext = this.callContext.getPolarisCallContext();
        boolean cleanup = (Boolean)polarisCallContext.getConfigurationStore().getConfiguration(this.callContext.getRealmContext(), (PolarisConfiguration)FeatureConfiguration.CLEANUP_ON_CATALOG_DROP);
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)entity, Map.of(), cleanup);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.failedBecauseNotEmpty()) {
                throw new BadRequestException("Catalog '%s' cannot be dropped, it is not empty", new Object[]{entity.getName()});
            }
            throw new BadRequestException("Catalog '%s' cannot be dropped, concurrent modification detected. Please try again", new Object[]{entity.getName()});
        }
    }

    @Nonnull
    public CatalogEntity getCatalog(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_CATALOG;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.CATALOG);
        return this.findCatalogByName(name).orElseThrow(() -> new NotFoundException("Catalog %s not found", new Object[]{name}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateUpdateCatalogDiffOrThrow(CatalogEntity currentEntity, CatalogEntity newEntity) {
        PolarisStorageConfigurationInfo currentStorageConfig = currentEntity.getStorageConfigurationInfo();
        PolarisStorageConfigurationInfo newStorageConfig = newEntity.getStorageConfigurationInfo();
        if (currentStorageConfig == null || newStorageConfig == null) {
            return;
        }
        if (!currentStorageConfig.getClass().equals(newStorageConfig.getClass())) {
            throw new BadRequestException("Cannot modify storage type of storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
        }
        if (currentStorageConfig instanceof AwsStorageConfigurationInfo) {
            AwsStorageConfigurationInfo currentAwsConfig = (AwsStorageConfigurationInfo)currentStorageConfig;
            if (newStorageConfig instanceof AwsStorageConfigurationInfo) {
                AwsStorageConfigurationInfo newAwsConfig = (AwsStorageConfigurationInfo)newStorageConfig;
                if (!currentAwsConfig.getAwsAccountId().equals(newAwsConfig.getAwsAccountId())) {
                    throw new BadRequestException("Cannot modify Role ARN in storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
                }
                if ((currentAwsConfig.getExternalId() == null || currentAwsConfig.getExternalId().equals(newAwsConfig.getExternalId())) && (newAwsConfig.getExternalId() == null || newAwsConfig.getExternalId().equals(currentAwsConfig.getExternalId()))) return;
                throw new BadRequestException("Cannot modify ExternalId in storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
            }
        }
        if (!(currentStorageConfig instanceof AzureStorageConfigurationInfo)) return;
        AzureStorageConfigurationInfo currentAzureConfig = (AzureStorageConfigurationInfo)currentStorageConfig;
        if (!(newStorageConfig instanceof AzureStorageConfigurationInfo)) return;
        AzureStorageConfigurationInfo newAzureConfig = (AzureStorageConfigurationInfo)newStorageConfig;
        if (currentAzureConfig.getTenantId().equals(newAzureConfig.getTenantId()) && newAzureConfig.getTenantId().equals(currentAzureConfig.getTenantId())) return;
        throw new BadRequestException("Cannot modify TenantId in storage config from %s to %s", new Object[]{currentStorageConfig, newStorageConfig});
    }

    @Nonnull
    public CatalogEntity updateCatalog(String name, UpdateCatalogRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_CATALOG;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.CATALOG);
        CatalogEntity currentCatalogEntity = this.findCatalogByName(name).orElseThrow(() -> new NotFoundException("Catalog %s not found", new Object[]{name}));
        if (currentCatalogEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitFailedException("Failed to update Catalog; currentEntityVersion '%s', expected '%s'", new Object[]{currentCatalogEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        CatalogEntity.Builder updateBuilder = new CatalogEntity.Builder(currentCatalogEntity);
        String defaultBaseLocation = currentCatalogEntity.getDefaultBaseLocation();
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentCatalogEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
            String newDefaultBaseLocation = (String)updateRequest.getProperties().get("default-base-location");
            if (StringUtils.isNotEmpty((CharSequence)newDefaultBaseLocation)) {
                defaultBaseLocation = newDefaultBaseLocation;
            } else {
                updateBuilder.setDefaultBaseLocation(defaultBaseLocation);
            }
        }
        if (updateRequest.getStorageConfigInfo() != null) {
            updateBuilder.setStorageConfigurationInfo(updateRequest.getStorageConfigInfo(), defaultBaseLocation);
        }
        CatalogEntity updatedEntity = updateBuilder.build();
        this.validateUpdateCatalogDiffOrThrow(currentCatalogEntity, updatedEntity);
        if (this.catalogOverlapsWithExistingCatalog(updatedEntity)) {
            throw new ValidationException("Cannot update Catalog %s. One or more of its new locations overlaps with an existing catalog", new Object[]{updatedEntity.getName()});
        }
        CatalogEntity returnedEntity = Optional.ofNullable(CatalogEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitFailedException("Concurrent modification on Catalog '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    public List<PolarisEntity> listCatalogs() {
        this.authorizeBasicRootOperationOrThrow(PolarisAuthorizableOperation.LIST_CATALOGS);
        return this.listCatalogsUnsafe();
    }

    private List<PolarisEntity> listCatalogsUnsafe() {
        return this.metaStoreManager.listEntities(this.getCurrentPolarisContext(), null, PolarisEntityType.CATALOG, PolarisEntitySubType.ANY_SUBTYPE, PageToken.readEverything()).getEntities().stream().map(nameAndId -> PolarisEntity.of((EntityResult)this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), 0L, nameAndId.getId(), nameAndId.getType()))).toList();
    }

    public PrincipalWithCredentials createPrincipal(PolarisEntity entity) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_PRINCIPAL;
        this.authorizeBasicRootOperationOrThrow(op);
        if (FederatedEntities.isFederated((PolarisBaseEntity)entity)) {
            throw new ValidationException("Cannot create a federated principal", new Object[0]);
        }
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        CreatePrincipalResult principalResult = this.metaStoreManager.createPrincipal(this.getCurrentPolarisContext(), (PolarisBaseEntity)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCreateTimestamp(System.currentTimeMillis())).build());
        if (principalResult.alreadyExists()) {
            throw new AlreadyExistsException("Cannot create Principal %s. Principal already exists or resolution failed", new Object[]{entity.getName()});
        }
        return new PrincipalWithCredentials(new PrincipalEntity(principalResult.getPrincipal()).asPrincipal(), new PrincipalWithCredentialsCredentials(principalResult.getPrincipalSecrets().getPrincipalClientId(), principalResult.getPrincipalSecrets().getMainSecret()));
    }

    public void deletePrincipal(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_PRINCIPAL;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL);
        PolarisEntity entity = (PolarisEntity)this.findPrincipalByName(name).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{name}));
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)entity, Map.of(), false);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.isEntityUnDroppable()) {
                throw new BadRequestException("Root principal cannot be dropped", new Object[0]);
            }
            throw new BadRequestException("Root principal cannot be dropped, concurrent modification detected. Please try again", new Object[0]);
        }
    }

    @Nonnull
    public PrincipalEntity getPrincipal(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_PRINCIPAL;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL);
        return this.findPrincipalByName(name).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{name}));
    }

    @Nonnull
    public PrincipalEntity updatePrincipal(String name, UpdatePrincipalRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_PRINCIPAL;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL);
        PrincipalEntity currentPrincipalEntity = this.findPrincipalByName(name).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{name}));
        if (FederatedEntities.isFederated((PolarisBaseEntity)currentPrincipalEntity)) {
            throw new ValidationException("Cannot update a federated principal: %s", new Object[]{currentPrincipalEntity.getName()});
        }
        if (currentPrincipalEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitFailedException("Failed to update Principal; currentEntityVersion '%s', expected '%s'", new Object[]{currentPrincipalEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        PrincipalEntity.Builder updateBuilder = new PrincipalEntity.Builder(currentPrincipalEntity);
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentPrincipalEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
        }
        PrincipalEntity updatedEntity = updateBuilder.build();
        PrincipalEntity returnedEntity = Optional.ofNullable(PrincipalEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitFailedException("Concurrent modification on Principal '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    @Nonnull
    private PrincipalWithCredentials rotateOrResetCredentialsHelper(String principalName, boolean shouldReset) {
        PrincipalEntity currentPrincipalEntity = this.findPrincipalByName(principalName).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{principalName}));
        if (FederatedEntities.isFederated((PolarisBaseEntity)currentPrincipalEntity)) {
            throw new ValidationException("Cannot rotate/reset credentials for a federated principal: %s", new Object[]{principalName});
        }
        PolarisPrincipalSecrets currentSecrets = this.metaStoreManager.loadPrincipalSecrets(this.getCurrentPolarisContext(), currentPrincipalEntity.getClientId()).getPrincipalSecrets();
        if (currentSecrets == null) {
            throw new IllegalArgumentException(String.format("Failed to load current secrets for principal '%s'", principalName));
        }
        PolarisPrincipalSecrets newSecrets = this.metaStoreManager.rotatePrincipalSecrets(this.getCurrentPolarisContext(), currentPrincipalEntity.getClientId(), currentPrincipalEntity.getId(), shouldReset, currentSecrets.getMainSecretHash()).getPrincipalSecrets();
        if (newSecrets == null) {
            throw new IllegalStateException(String.format("Failed to %s secrets for principal '%s'", shouldReset ? "reset" : "rotate", principalName));
        }
        PolarisEntity newPrincipal = PolarisEntity.of((EntityResult)this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), 0L, currentPrincipalEntity.getId(), currentPrincipalEntity.getType()));
        return new PrincipalWithCredentials(PrincipalEntity.of((PolarisBaseEntity)newPrincipal).asPrincipal(), new PrincipalWithCredentialsCredentials(newSecrets.getPrincipalClientId(), newSecrets.getMainSecret()));
    }

    @Nonnull
    public PrincipalWithCredentials rotateCredentials(String principalName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ROTATE_CREDENTIALS;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalName, PolarisEntityType.PRINCIPAL);
        return this.rotateOrResetCredentialsHelper(principalName, false);
    }

    @Nonnull
    public PrincipalWithCredentials resetCredentials(String principalName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.RESET_CREDENTIALS;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalName, PolarisEntityType.PRINCIPAL);
        return this.rotateOrResetCredentialsHelper(principalName, true);
    }

    public List<PolarisEntity> listPrincipals() {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_PRINCIPALS;
        this.authorizeBasicRootOperationOrThrow(op);
        return this.metaStoreManager.listEntities(this.getCurrentPolarisContext(), null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, PageToken.readEverything()).getEntities().stream().map(nameAndId -> PolarisEntity.of((EntityResult)this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), 0L, nameAndId.getId(), nameAndId.getType()))).toList();
    }

    public PolarisEntity createPrincipalRole(PolarisEntity entity) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_PRINCIPAL_ROLE;
        this.authorizeBasicRootOperationOrThrow(op);
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        PolarisEntity returnedEntity = PolarisEntity.of((EntityResult)this.metaStoreManager.createEntityIfNotExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCreateTimestamp(System.currentTimeMillis())).build()));
        if (returnedEntity == null) {
            throw new AlreadyExistsException("Cannot create PrincipalRole %s. PrincipalRole already exists or resolution failed", new Object[]{entity.getName()});
        }
        return returnedEntity;
    }

    public void deletePrincipalRole(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_PRINCIPAL_ROLE;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL_ROLE);
        PolarisEntity entity = (PolarisEntity)this.findPrincipalRoleByName(name).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{name}));
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)entity, Map.of(), true);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.isEntityUnDroppable()) {
                throw new BadRequestException("Polaris service admin principal role cannot be dropped", new Object[0]);
            }
            throw new BadRequestException("Polaris service admin principal role cannot be dropped, concurrent modification detected. Please try again", new Object[0]);
        }
    }

    @Nonnull
    public PrincipalRoleEntity getPrincipalRole(String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_PRINCIPAL_ROLE;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL_ROLE);
        return this.findPrincipalRoleByName(name).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{name}));
    }

    @Nonnull
    public PrincipalRoleEntity updatePrincipalRole(String name, UpdatePrincipalRoleRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_PRINCIPAL_ROLE;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, name, PolarisEntityType.PRINCIPAL_ROLE);
        PrincipalRoleEntity currentPrincipalRoleEntity = this.findPrincipalRoleByName(name).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{name}));
        if (currentPrincipalRoleEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitFailedException("Failed to update PrincipalRole; currentEntityVersion '%s', expected '%s'", new Object[]{currentPrincipalRoleEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        PrincipalRoleEntity.Builder updateBuilder = new PrincipalRoleEntity.Builder(currentPrincipalRoleEntity);
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentPrincipalRoleEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
        }
        PrincipalRoleEntity updatedEntity = updateBuilder.build();
        PrincipalRoleEntity returnedEntity = Optional.ofNullable(PrincipalRoleEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), null, (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitFailedException("Concurrent modification on PrincipalRole '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    public List<PolarisEntity> listPrincipalRoles() {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_PRINCIPAL_ROLES;
        this.authorizeBasicRootOperationOrThrow(op);
        return this.metaStoreManager.listEntities(this.getCurrentPolarisContext(), null, PolarisEntityType.PRINCIPAL_ROLE, PolarisEntitySubType.NULL_SUBTYPE, PageToken.readEverything()).getEntities().stream().map(nameAndId -> PolarisEntity.of((EntityResult)this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), 0L, nameAndId.getId(), nameAndId.getType()))).toList();
    }

    public PolarisEntity createCatalogRole(String catalogName, PolarisEntity entity) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.CREATE_CATALOG_ROLE;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, catalogName, PolarisEntityType.CATALOG);
        Preconditions.checkArgument((entity.getId() == -1L ? 1 : 0) != 0, (Object)"Entity to be created must have no ID assigned");
        PolarisEntity catalogEntity = (PolarisEntity)this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Parent catalog %s not found", new Object[]{catalogName}));
        PolarisEntity returnedEntity = PolarisEntity.of((EntityResult)this.metaStoreManager.createEntityIfNotExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisBaseEntity)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder(entity).setId(this.metaStoreManager.generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setCatalogId(catalogEntity.getId())).setParentId(catalogEntity.getId())).setCreateTimestamp(System.currentTimeMillis())).build()));
        if (returnedEntity == null) {
            throw new AlreadyExistsException("Cannot create CatalogRole %s in %s. CatalogRole already exists or resolution failed", new Object[]{entity.getName(), catalogName});
        }
        return returnedEntity;
    }

    public void deleteCatalogRole(String catalogName, String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.DELETE_CATALOG_ROLE;
        this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, name);
        PolarisResolvedPathWrapper resolvedCatalogRoleEntity = this.resolutionManifest.getResolvedPath((Object)name);
        if (resolvedCatalogRoleEntity == null) {
            throw new NotFoundException("CatalogRole %s not found in catalog %s", new Object[]{name, catalogName});
        }
        DropEntityResult dropEntityResult = this.metaStoreManager.dropEntityIfExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)resolvedCatalogRoleEntity.getRawParentPath()), (PolarisBaseEntity)resolvedCatalogRoleEntity.getRawLeafEntity(), Map.of(), true);
        if (!dropEntityResult.isSuccess()) {
            if (dropEntityResult.isEntityUnDroppable()) {
                throw new BadRequestException("Catalog admin role cannot be dropped", new Object[0]);
            }
            throw new BadRequestException("Catalog admin role cannot be dropped, concurrent modification detected. Please try again", new Object[0]);
        }
    }

    @Nonnull
    public CatalogRoleEntity getCatalogRole(String catalogName, String name) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.GET_CATALOG_ROLE;
        this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, name);
        return this.findCatalogRoleByName(catalogName, name).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{name}));
    }

    @Nonnull
    public CatalogRoleEntity updateCatalogRole(String catalogName, String name, UpdateCatalogRoleRequest updateRequest) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.UPDATE_CATALOG_ROLE;
        this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, name);
        CatalogEntity catalogEntity = this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Catalog %s not found", new Object[]{catalogName}));
        CatalogRoleEntity currentCatalogRoleEntity = this.findCatalogRoleByName(catalogName, name).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{name}));
        if (currentCatalogRoleEntity.getEntityVersion() != updateRequest.getCurrentEntityVersion().intValue()) {
            throw new CommitFailedException("Failed to update CatalogRole; currentEntityVersion '%s', expected '%s'", new Object[]{currentCatalogRoleEntity.getEntityVersion(), updateRequest.getCurrentEntityVersion()});
        }
        CatalogRoleEntity.Builder updateBuilder = new CatalogRoleEntity.Builder(currentCatalogRoleEntity);
        if (updateRequest.getProperties() != null) {
            Map<String, String> updateProperties = this.reservedProperties.removeReservedPropertiesFromUpdate(currentCatalogRoleEntity.getPropertiesAsMap(), updateRequest.getProperties());
            updateBuilder.setProperties(updateProperties);
        }
        CatalogRoleEntity updatedEntity = updateBuilder.build();
        CatalogRoleEntity returnedEntity = Optional.ofNullable(CatalogRoleEntity.of((PolarisBaseEntity)PolarisEntity.of((EntityResult)this.metaStoreManager.updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisBaseEntity)updatedEntity)))).orElseThrow(() -> new CommitFailedException("Concurrent modification on CatalogRole '%s'; retry later", new Object[]{name}));
        return returnedEntity;
    }

    public List<PolarisEntity> listCatalogRoles(String catalogName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_CATALOG_ROLES;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, catalogName, PolarisEntityType.CATALOG);
        PolarisEntity catalogEntity = (PolarisEntity)this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Parent catalog %s not found", new Object[]{catalogName}));
        return this.metaStoreManager.listEntities(this.getCurrentPolarisContext(), PolarisEntity.toCoreList(List.of(catalogEntity)), PolarisEntityType.CATALOG_ROLE, PolarisEntitySubType.NULL_SUBTYPE, PageToken.readEverything()).getEntities().stream().map(nameAndId -> PolarisEntity.of((EntityResult)this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), catalogEntity.getId(), nameAndId.getId(), nameAndId.getType()))).toList();
    }

    public boolean assignPrincipalRole(String principalName, String principalRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ASSIGN_PRINCIPAL_ROLE;
        this.authorizeGrantOnPrincipalRoleToPrincipalOperationOrThrow(op, principalRoleName, principalName);
        PolarisEntity principalEntity = (PolarisEntity)this.findPrincipalByName(principalName).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{principalName}));
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalEntity)) {
            throw new ValidationException("Cannot assign a role to a federated principal", new Object[0]);
        }
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalRoleEntity)) {
            throw new ValidationException("Cannot assign a federated role to a principal", new Object[0]);
        }
        return this.metaStoreManager.grantUsageOnRoleToGrantee(this.getCurrentPolarisContext(), null, (PolarisEntityCore)principalRoleEntity, (PolarisEntityCore)principalEntity).isSuccess();
    }

    public boolean revokePrincipalRole(String principalName, String principalRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_PRINCIPAL_ROLE;
        this.authorizeGrantOnPrincipalRoleToPrincipalOperationOrThrow(op, principalRoleName, principalName);
        PolarisEntity principalEntity = (PolarisEntity)this.findPrincipalByName(principalName).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{principalName}));
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalEntity)) {
            throw new ValidationException("Cannot revoke a role from a federated principal", new Object[0]);
        }
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        if (FederatedEntities.isFederated((PolarisBaseEntity)principalRoleEntity)) {
            throw new ValidationException("Cannot revoke a federated role from a principal", new Object[0]);
        }
        return this.metaStoreManager.revokeUsageOnRoleFromGrantee(this.getCurrentPolarisContext(), null, (PolarisEntityCore)principalRoleEntity, (PolarisEntityCore)principalEntity).isSuccess();
    }

    public List<PolarisEntity> listPrincipalRolesAssigned(String principalName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_PRINCIPAL_ROLES_ASSIGNED;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalName, PolarisEntityType.PRINCIPAL);
        PolarisEntity principalEntity = (PolarisEntity)this.findPrincipalByName(principalName).orElseThrow(() -> new NotFoundException("Principal %s not found", new Object[]{principalName}));
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)principalEntity);
        return this.buildEntitiesFromGrantResults(grantList, false, PolarisEntityType.PRINCIPAL_ROLE, null);
    }

    public boolean assignCatalogRoleToPrincipalRole(String principalRoleName, String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ASSIGN_CATALOG_ROLE_TO_PRINCIPAL_ROLE;
        this.authorizeGrantOnCatalogRoleToPrincipalRoleOperationOrThrow(op, catalogName, catalogRoleName, principalRoleName);
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        PolarisEntity catalogEntity = (PolarisEntity)this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Parent catalog %s not found", new Object[]{catalogName}));
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        return this.metaStoreManager.grantUsageOnRoleToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogEntity, (PolarisEntityCore)catalogRoleEntity, (PolarisEntityCore)principalRoleEntity).isSuccess();
    }

    public boolean revokeCatalogRoleFromPrincipalRole(String principalRoleName, String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_CATALOG_ROLE_FROM_PRINCIPAL_ROLE;
        this.authorizeGrantOnCatalogRoleToPrincipalRoleOperationOrThrow(op, catalogName, catalogRoleName, principalRoleName);
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        PolarisEntity catalogEntity = (PolarisEntity)this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Parent catalog %s not found", new Object[]{catalogName}));
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        return this.metaStoreManager.revokeUsageOnRoleFromGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogEntity, (PolarisEntityCore)catalogRoleEntity, (PolarisEntityCore)principalRoleEntity).isSuccess();
    }

    public List<PolarisEntity> listAssigneePrincipalsForPrincipalRole(String principalRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_ASSIGNEE_PRINCIPALS_FOR_PRINCIPAL_ROLE;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalRoleName, PolarisEntityType.PRINCIPAL_ROLE);
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsOnSecurable(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity);
        return this.buildEntitiesFromGrantResults(grantList, true, PolarisEntityType.PRINCIPAL, null);
    }

    private List<PolarisEntity> buildEntitiesFromGrantResults(@Nonnull LoadGrantsResult grantList, boolean grantees, PolarisEntityType entityType, @Nullable Function<PolarisGrantRecord, Boolean> grantFilter) {
        Map granteeMap = grantList.getEntitiesAsMap();
        ArrayList<PolarisEntity> toReturn = new ArrayList<PolarisEntity>(grantList.getGrantRecords().size());
        for (PolarisGrantRecord grantRecord : grantList.getGrantRecords()) {
            long entityId;
            long catalogId;
            PolarisBaseEntity entity;
            if (grantFilter != null && !grantFilter.apply(grantRecord).booleanValue() || (entity = this.getOrLoadEntity(granteeMap, catalogId = grantees ? grantRecord.getGranteeCatalogId() : grantRecord.getSecurableCatalogId(), entityId = grantees ? grantRecord.getGranteeId() : grantRecord.getSecurableId(), entityType)) == null) continue;
            toReturn.add(PolarisEntity.of((PolarisBaseEntity)entity));
        }
        return toReturn;
    }

    public List<PolarisEntity> listCatalogRolesForPrincipalRole(String principalRoleName, String catalogName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_CATALOG_ROLES_FOR_PRINCIPAL_ROLE;
        this.authorizeBasicTopLevelEntityOperationOrThrow(op, principalRoleName, PolarisEntityType.PRINCIPAL_ROLE, catalogName);
        PolarisEntity catalogEntity = (PolarisEntity)this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Parent catalog %s not found", new Object[]{catalogName}));
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity);
        return this.buildEntitiesFromGrantResults(grantList, false, PolarisEntityType.CATALOG_ROLE, grantRec -> grantRec.getSecurableCatalogId() == catalogEntity.getId());
    }

    public boolean grantPrivilegeOnRootContainerToPrincipalRole(String principalRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_ROOT_GRANT_TO_PRINCIPAL_ROLE;
        this.authorizeGrantOnRootContainerToPrincipalRoleOperationOrThrow(op, principalRoleName);
        PolarisEntity rootContainerEntity = this.resolutionManifest.getResolvedRootContainerEntityAsPath().getRawLeafEntity();
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity, null, (PolarisEntityCore)rootContainerEntity, privilege).isSuccess();
    }

    public boolean revokePrivilegeOnRootContainerFromPrincipalRole(String principalRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_ROOT_GRANT_FROM_PRINCIPAL_ROLE;
        this.authorizeGrantOnRootContainerToPrincipalRoleOperationOrThrow(op, principalRoleName);
        PolarisEntity rootContainerEntity = this.resolutionManifest.getResolvedRootContainerEntityAsPath().getRawLeafEntity();
        PolarisEntity principalRoleEntity = (PolarisEntity)this.findPrincipalRoleByName(principalRoleName).orElseThrow(() -> new NotFoundException("PrincipalRole %s not found", new Object[]{principalRoleName}));
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)principalRoleEntity, null, (PolarisEntityCore)rootContainerEntity, privilege).isSuccess();
    }

    public boolean grantPrivilegeOnCatalogToRole(String catalogName, String catalogRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_CATALOG_GRANT_TO_CATALOG_ROLE;
        this.authorizeGrantOnCatalogOperationOrThrow(op, catalogName, catalogRoleName);
        PolarisEntity catalogEntity = (PolarisEntity)this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Parent catalog %s not found", new Object[]{catalogName}));
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisEntityCore)catalogEntity, privilege).isSuccess();
    }

    public boolean revokePrivilegeOnCatalogFromRole(String catalogName, String catalogRoleName, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_CATALOG_GRANT_FROM_CATALOG_ROLE;
        this.authorizeGrantOnCatalogOperationOrThrow(op, catalogName, catalogRoleName);
        PolarisEntity catalogEntity = (PolarisEntity)this.findCatalogByName(catalogName).orElseThrow(() -> new NotFoundException("Parent catalog %s not found", new Object[]{catalogName}));
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList(List.of(catalogEntity)), (PolarisEntityCore)catalogEntity, privilege).isSuccess();
    }

    public boolean grantPrivilegeOnNamespaceToRole(String catalogName, String catalogRoleName, Namespace namespace, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_NAMESPACE_GRANT_TO_CATALOG_ROLE;
        this.authorizeGrantOnNamespaceOperationOrThrow(op, catalogName, namespace, catalogRoleName);
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        PolarisResolvedPathWrapper resolvedPathWrapper = this.resolutionManifest.getResolvedPath((Object)namespace);
        if (resolvedPathWrapper == null) {
            throw new NotFoundException("Namespace %s not found", new Object[]{namespace});
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity namespaceEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)namespaceEntity, privilege).isSuccess();
    }

    public boolean revokePrivilegeOnNamespaceFromRole(String catalogName, String catalogRoleName, Namespace namespace, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_NAMESPACE_GRANT_FROM_CATALOG_ROLE;
        this.authorizeGrantOnNamespaceOperationOrThrow(op, catalogName, namespace, catalogRoleName);
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        PolarisResolvedPathWrapper resolvedPathWrapper = this.resolutionManifest.getResolvedPath((Object)namespace);
        if (resolvedPathWrapper == null) {
            throw new NotFoundException("Namespace %s not found", new Object[]{namespace});
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity namespaceEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)namespaceEntity, privilege).isSuccess();
    }

    public boolean grantPrivilegeOnTableToRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_TABLE_GRANT_TO_CATALOG_ROLE;
        this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), identifier, catalogRoleName);
        return this.grantPrivilegeOnTableLikeToRole(catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), privilege);
    }

    public boolean revokePrivilegeOnTableFromRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_TABLE_GRANT_FROM_CATALOG_ROLE;
        this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), identifier, catalogRoleName);
        return this.revokePrivilegeOnTableLikeFromRole(catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.GENERIC_TABLE, PolarisEntitySubType.ICEBERG_TABLE), privilege);
    }

    public boolean grantPrivilegeOnViewToRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_VIEW_GRANT_TO_CATALOG_ROLE;
        this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.ICEBERG_VIEW), identifier, catalogRoleName);
        return this.grantPrivilegeOnTableLikeToRole(catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.ICEBERG_VIEW), privilege);
    }

    public boolean revokePrivilegeOnViewFromRole(String catalogName, String catalogRoleName, TableIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_VIEW_GRANT_FROM_CATALOG_ROLE;
        this.authorizeGrantOnTableLikeOperationOrThrow(op, catalogName, List.of(PolarisEntitySubType.ICEBERG_VIEW), identifier, catalogRoleName);
        return this.revokePrivilegeOnTableLikeFromRole(catalogName, catalogRoleName, identifier, List.of(PolarisEntitySubType.ICEBERG_VIEW), privilege);
    }

    public boolean grantPrivilegeOnPolicyToRole(String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.ADD_POLICY_GRANT_TO_CATALOG_ROLE;
        this.authorizeGrantOnPolicyOperationOrThrow(op, catalogName, identifier, catalogRoleName);
        return this.grantPrivilegeOnPolicyEntityToRole(catalogName, catalogRoleName, identifier, privilege);
    }

    public boolean revokePrivilegeOnPolicyFromRole(String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.REVOKE_POLICY_GRANT_FROM_CATALOG_ROLE;
        this.authorizeGrantOnPolicyOperationOrThrow(op, catalogName, identifier, catalogRoleName);
        return this.revokePrivilegeOnPolicyEntityFromRole(catalogName, catalogRoleName, identifier, privilege);
    }

    public List<PolarisEntity> listAssigneePrincipalRolesForCatalogRole(String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_ASSIGNEE_PRINCIPAL_ROLES_FOR_CATALOG_ROLE;
        this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, catalogRoleName);
        if (this.findCatalogByName(catalogName).isEmpty()) {
            throw new NotFoundException("Parent catalog %s not found", new Object[]{catalogName});
        }
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsOnSecurable(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity);
        return this.buildEntitiesFromGrantResults(grantList, true, PolarisEntityType.PRINCIPAL_ROLE, null);
    }

    public List<GrantResource> listGrantsForCatalogRole(String catalogName, String catalogRoleName) {
        PolarisAuthorizableOperation op = PolarisAuthorizableOperation.LIST_GRANTS_FOR_CATALOG_ROLE;
        this.authorizeBasicCatalogRoleOperationOrThrow(op, catalogName, catalogRoleName);
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        LoadGrantsResult grantList = this.metaStoreManager.loadGrantsToGrantee(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity);
        ArrayList<CatalogGrant> catalogGrants = new ArrayList<CatalogGrant>();
        ArrayList<CatalogGrant> namespaceGrants = new ArrayList<CatalogGrant>();
        ArrayList<PolicyGrant> tableGrants = new ArrayList<PolicyGrant>();
        ArrayList<PolicyGrant> viewGrants = new ArrayList<PolicyGrant>();
        ArrayList<PolicyGrant> policyGrants = new ArrayList<PolicyGrant>();
        Map entityMap = grantList.getEntitiesAsMap();
        block6: for (PolarisGrantRecord record : grantList.getGrantRecords()) {
            PolarisPrivilege privilege = PolarisPrivilege.fromCode((int)record.getPrivilegeCode());
            PolarisBaseEntity baseEntity = this.getOrLoadEntityForGrant(entityMap, record);
            if (baseEntity == null) continue;
            switch (baseEntity.getType()) {
                case CATALOG: {
                    CatalogGrant grant = new CatalogGrant(CatalogPrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.CATALOG);
                    catalogGrants.add(grant);
                    continue block6;
                }
                case NAMESPACE: {
                    CatalogGrant grant = new NamespaceGrant(List.of(NamespaceEntity.of((PolarisBaseEntity)baseEntity).asNamespace().levels()), NamespacePrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.NAMESPACE);
                    namespaceGrants.add(grant);
                    continue block6;
                }
                case TABLE_LIKE: {
                    PolicyGrant grant;
                    TableIdentifier identifier;
                    if (baseEntity.getSubType() == PolarisEntitySubType.ICEBERG_TABLE || baseEntity.getSubType() == PolarisEntitySubType.GENERIC_TABLE) {
                        identifier = IcebergTableLikeEntity.of((PolarisBaseEntity)baseEntity).getTableIdentifier();
                        grant = new TableGrant(List.of(identifier.namespace().levels()), identifier.name(), TablePrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.TABLE);
                        tableGrants.add(grant);
                        continue block6;
                    }
                    if (baseEntity.getSubType() == PolarisEntitySubType.ICEBERG_VIEW) {
                        identifier = IcebergTableLikeEntity.of((PolarisBaseEntity)baseEntity).getTableIdentifier();
                        grant = new ViewGrant(List.of(identifier.namespace().levels()), identifier.name(), ViewPrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.VIEW);
                        viewGrants.add(grant);
                        continue block6;
                    }
                    throw new IllegalStateException("Unrecognized entity subtype " + String.valueOf(baseEntity.getSubType()));
                }
                case POLICY: {
                    PolicyEntity policyEntity = PolicyEntity.of((PolarisBaseEntity)baseEntity);
                    PolicyGrant grant = new PolicyGrant(Arrays.asList(policyEntity.getParentNamespace().levels()), policyEntity.getName(), PolicyPrivilege.valueOf((String)privilege.toString()), GrantResource.TypeEnum.POLICY);
                    policyGrants.add(grant);
                    continue block6;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected entity type '%s' listing grants for catalogRole '%s' in catalog '%s'", baseEntity.getType(), catalogRoleName, catalogName));
        }
        ArrayList<GrantResource> allGrants = new ArrayList<GrantResource>();
        allGrants.addAll(catalogGrants);
        allGrants.addAll(namespaceGrants);
        allGrants.addAll(tableGrants);
        allGrants.addAll(viewGrants);
        allGrants.addAll(policyGrants);
        return allGrants;
    }

    @Nullable
    private PolarisBaseEntity getOrLoadEntity(@Nullable Map<Long, PolarisBaseEntity> entitiesMap, long catalogId, long id, PolarisEntityType entityType) {
        return entitiesMap == null ? this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), catalogId, id, entityType).getEntity() : entitiesMap.get(id);
    }

    @Nullable
    private PolarisBaseEntity getOrLoadEntityForGrant(@Nullable Map<Long, PolarisBaseEntity> entitiesMap, PolarisGrantRecord record) {
        if (entitiesMap != null) {
            return entitiesMap.get(record.getSecurableId());
        }
        for (PolarisEntityType type : PolarisEntityType.values()) {
            EntityResult entityResult = this.metaStoreManager.loadEntity(this.getCurrentPolarisContext(), record.getSecurableCatalogId(), record.getSecurableId(), type);
            if (!entityResult.isSuccess()) continue;
            return entityResult.getEntity();
        }
        return null;
    }

    private boolean grantPrivilegeOnTableLikeToRole(String catalogName, String catalogRoleName, TableIdentifier identifier, List<PolarisEntitySubType> subTypes, PolarisPrivilege privilege) {
        if (this.findCatalogByName(catalogName).isEmpty()) {
            throw new NotFoundException("Parent catalog %s not found", new Object[]{catalogName});
        }
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        PolarisResolvedPathWrapper resolvedPathWrapper = this.resolutionManifest.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE);
        if (resolvedPathWrapper == null || !subTypes.contains(resolvedPathWrapper.getRawLeafEntity().getSubType())) {
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity tableLikeEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)tableLikeEntity, privilege).isSuccess();
    }

    private boolean revokePrivilegeOnTableLikeFromRole(String catalogName, String catalogRoleName, TableIdentifier identifier, List<PolarisEntitySubType> subTypes, PolarisPrivilege privilege) {
        if (this.findCatalogByName(catalogName).isEmpty()) {
            throw new NotFoundException("Parent catalog %s not found", new Object[]{catalogName});
        }
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        PolarisResolvedPathWrapper resolvedPathWrapper = this.resolutionManifest.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE);
        if (resolvedPathWrapper == null || !subTypes.contains(resolvedPathWrapper.getRawLeafEntity().getSubType())) {
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, subTypes);
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity tableLikeEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)tableLikeEntity, privilege).isSuccess();
    }

    private boolean grantPrivilegeOnPolicyEntityToRole(String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        if (this.findCatalogByName(catalogName).isEmpty()) {
            throw new NotFoundException("Parent catalog %s not found", new Object[]{catalogName});
        }
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        PolarisResolvedPathWrapper resolvedPathWrapper = this.resolutionManifest.getResolvedPath((Object)identifier);
        if (resolvedPathWrapper == null) {
            throw new NoSuchPolicyException(String.format("Policy not exists: %s", identifier));
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity policyEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.grantPrivilegeOnSecurableToRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)policyEntity, privilege).isSuccess();
    }

    private boolean revokePrivilegeOnPolicyEntityFromRole(String catalogName, String catalogRoleName, PolicyIdentifier identifier, PolarisPrivilege privilege) {
        if (this.findCatalogByName(catalogName).isEmpty()) {
            throw new NotFoundException("Parent catalog %s not found", new Object[]{catalogName});
        }
        PolarisEntity catalogRoleEntity = (PolarisEntity)this.findCatalogRoleByName(catalogName, catalogRoleName).orElseThrow(() -> new NotFoundException("CatalogRole %s not found", new Object[]{catalogRoleName}));
        PolarisResolvedPathWrapper resolvedPathWrapper = this.resolutionManifest.getResolvedPath((Object)identifier);
        if (resolvedPathWrapper == null) {
            throw new NoSuchPolicyException(String.format("Policy not exists: %s", identifier));
        }
        List catalogPath = resolvedPathWrapper.getRawParentPath();
        PolarisEntity policyEntity = resolvedPathWrapper.getRawLeafEntity();
        return this.metaStoreManager.revokePrivilegeOnSecurableFromRole(this.getCurrentPolarisContext(), (PolarisEntityCore)catalogRoleEntity, PolarisEntity.toCoreList((List)catalogPath), (PolarisEntityCore)policyEntity, privilege).isSuccess();
    }
}

