/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.aws;

import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.storage.InMemoryStorageIntegration;
import org.apache.polaris.core.storage.StorageAccessProperty;
import org.apache.polaris.core.storage.StorageUtil;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.policybuilder.iam.IamEffect;
import software.amazon.awssdk.policybuilder.iam.IamPolicy;
import software.amazon.awssdk.policybuilder.iam.IamResource;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;

public class AwsCredentialsStorageIntegration
extends InMemoryStorageIntegration<AwsStorageConfigurationInfo> {
    private final StsClient stsClient;
    private final Optional<AwsCredentialsProvider> credentialsProvider;

    public AwsCredentialsStorageIntegration(StsClient stsClient) {
        this(stsClient, Optional.empty());
    }

    public AwsCredentialsStorageIntegration(StsClient stsClient, Optional<AwsCredentialsProvider> credentialsProvider) {
        super(AwsCredentialsStorageIntegration.class.getName());
        this.stsClient = stsClient;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public EnumMap<StorageAccessProperty, String> getSubscopedCreds(@Nonnull PolarisDiagnostics diagnostics, @Nonnull AwsStorageConfigurationInfo storageConfig, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations) {
        AssumeRoleRequest.Builder request = AssumeRoleRequest.builder().externalId(storageConfig.getExternalId()).roleArn(storageConfig.getRoleARN()).roleSessionName("PolarisAwsCredentialsStorageIntegration").policy(this.policyString(storageConfig.getRoleARN(), allowListOperation, allowedReadLocations, allowedWriteLocations).toJson()).durationSeconds(PolarisConfiguration.loadConfig(FeatureConfiguration.STORAGE_CREDENTIAL_DURATION_SECONDS));
        this.credentialsProvider.ifPresent(cp -> request.overrideConfiguration(b -> b.credentialsProvider(cp)));
        AssumeRoleResponse response = this.stsClient.assumeRole((AssumeRoleRequest)request.build());
        EnumMap<StorageAccessProperty, String> credentialMap = new EnumMap<StorageAccessProperty, String>(StorageAccessProperty.class);
        credentialMap.put(StorageAccessProperty.AWS_KEY_ID, response.credentials().accessKeyId());
        credentialMap.put(StorageAccessProperty.AWS_SECRET_KEY, response.credentials().secretAccessKey());
        credentialMap.put(StorageAccessProperty.AWS_TOKEN, response.credentials().sessionToken());
        Optional.ofNullable(response.credentials().expiration()).ifPresent(i -> {
            credentialMap.put(StorageAccessProperty.EXPIRATION_TIME, String.valueOf(i.toEpochMilli()));
            credentialMap.put(StorageAccessProperty.AWS_SESSION_TOKEN_EXPIRES_AT_MS, String.valueOf(i.toEpochMilli()));
        });
        if (storageConfig.getRegion() != null) {
            credentialMap.put(StorageAccessProperty.CLIENT_REGION, storageConfig.getRegion());
        }
        if (storageConfig.getAwsPartition().equals("aws-us-gov") && credentialMap.get((Object)StorageAccessProperty.CLIENT_REGION) == null) {
            throw new IllegalArgumentException(String.format("AWS region must be set when using partition %s", storageConfig.getAwsPartition()));
        }
        return credentialMap;
    }

    private IamPolicy policyString(String roleArn, boolean allowList, Set<String> readLocations, Set<String> writeLocations) {
        IamPolicy.Builder policyBuilder = IamPolicy.builder();
        IamStatement.Builder allowGetObjectStatementBuilder = IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:GetObject").addAction("s3:GetObjectVersion");
        HashMap bucketListStatementBuilder = new HashMap();
        HashMap bucketGetLocationStatementBuilder = new HashMap();
        String arnPrefix = this.getArnPrefixFor(roleArn);
        Stream.concat(readLocations.stream(), writeLocations.stream()).distinct().forEach(location -> {
            URI uri = URI.create(location);
            allowGetObjectStatementBuilder.addResource(IamResource.create((String)(arnPrefix + StorageUtil.concatFilePrefixes(AwsCredentialsStorageIntegration.parseS3Path(uri), "*", "/"))));
            String bucket = arnPrefix + StorageUtil.getBucket(uri);
            if (allowList) {
                bucketListStatementBuilder.computeIfAbsent(bucket, key -> IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:ListBucket").addResource(key)).addCondition(IamConditionOperator.STRING_LIKE, "s3:prefix", StorageUtil.concatFilePrefixes(AwsCredentialsStorageIntegration.trimLeadingSlash(uri.getPath()), "*", "/"));
            }
            bucketGetLocationStatementBuilder.computeIfAbsent(bucket, key -> IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:GetBucketLocation").addResource(key));
        });
        if (!writeLocations.isEmpty()) {
            IamStatement.Builder allowPutObjectStatementBuilder = IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:PutObject").addAction("s3:DeleteObject");
            writeLocations.forEach(location -> {
                URI uri = URI.create(location);
                allowPutObjectStatementBuilder.addResource(IamResource.create((String)(arnPrefix + StorageUtil.concatFilePrefixes(AwsCredentialsStorageIntegration.parseS3Path(uri), "*", "/"))));
            });
            policyBuilder.addStatement((IamStatement)allowPutObjectStatementBuilder.build());
        }
        if (!bucketListStatementBuilder.isEmpty()) {
            bucketListStatementBuilder.values().forEach(statementBuilder -> policyBuilder.addStatement((IamStatement)statementBuilder.build()));
        } else if (allowList) {
            policyBuilder.addStatement((IamStatement)IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:ListBucket").build());
        }
        bucketGetLocationStatementBuilder.values().forEach(statementBuilder -> policyBuilder.addStatement((IamStatement)statementBuilder.build()));
        return (IamPolicy)policyBuilder.addStatement((IamStatement)allowGetObjectStatementBuilder.build()).build();
    }

    private String getArnPrefixFor(String roleArn) {
        if (roleArn.contains("aws-cn")) {
            return "arn:aws-cn:s3:::";
        }
        if (roleArn.contains("aws-us-gov")) {
            return "arn:aws-us-gov:s3:::";
        }
        return "arn:aws:s3:::";
    }

    @Nonnull
    private static String parseS3Path(URI uri) {
        String bucket = StorageUtil.getBucket(uri);
        String path = AwsCredentialsStorageIntegration.trimLeadingSlash(uri.getPath());
        return String.join((CharSequence)"/", bucket, path);
    }

    @Nonnull
    private static String trimLeadingSlash(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

