/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.admin.model.AddGrantRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.RevokeGrantRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.admin.api.PolarisCatalogsApiService;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/management/v1/catalogs")
public class PolarisCatalogsApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCatalogsApi.class);
    private final PolarisCatalogsApiService service;

    @Inject
    public PolarisCatalogsApi(PolarisCatalogsApiService service) {
        this.service = service;
    }

    @PUT
    @Path(value="/{catalogName}/catalog-roles/{catalogRoleName}/grants")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.addGrantToCatalogRole")
    @Timeout
    public Response addGrantToCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @Valid AddGrantRequest addGrantRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"addGrantToCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).addKeyValue("addGrantRequest", (Object)String.valueOf(addGrantRequest)).log();
        Response ret = this.service.addGrantToCatalogRole(catalogName, catalogRoleName, addGrantRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of addGrantToCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.createCatalog")
    @Timeout
    public Response createCatalog(@Nonnull @Valid CreateCatalogRequest createCatalogRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"createCatalog").addKeyValue("createCatalogRequest", (Object)String.valueOf(createCatalogRequest)).log();
        Response ret = this.service.createCatalog(createCatalogRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createCatalog API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/{catalogName}/catalog-roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.createCatalogRole")
    @Timeout
    public Response createCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Valid CreateCatalogRoleRequest createCatalogRoleRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"createCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("createCatalogRoleRequest", (Object)String.valueOf(createCatalogRoleRequest)).log();
        Response ret = this.service.createCatalogRole(catalogName, createCatalogRoleRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/{catalogName}")
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.deleteCatalog")
    @Timeout
    public Response deleteCatalog(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"deleteCatalog").addKeyValue("catalogName", (Object)catalogName).log();
        Response ret = this.service.deleteCatalog(catalogName, realmContext, securityContext);
        LOGGER.debug("Completed execution of deleteCatalog API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/{catalogName}/catalog-roles/{catalogRoleName}")
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.deleteCatalogRole")
    @Timeout
    public Response deleteCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"deleteCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).log();
        Response ret = this.service.deleteCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of deleteCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{catalogName}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.getCatalog")
    @Timeout
    public Response getCatalog(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"getCatalog").addKeyValue("catalogName", (Object)catalogName).log();
        Response ret = this.service.getCatalog(catalogName, realmContext, securityContext);
        LOGGER.debug("Completed execution of getCatalog API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{catalogName}/catalog-roles/{catalogRoleName}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.getCatalogRole")
    @Timeout
    public Response getCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"getCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).log();
        Response ret = this.service.getCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of getCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{catalogName}/catalog-roles/{catalogRoleName}/principal-roles")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.listAssigneePrincipalRolesForCatalogRole")
    @Timeout
    public Response listAssigneePrincipalRolesForCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"listAssigneePrincipalRolesForCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).log();
        Response ret = this.service.listAssigneePrincipalRolesForCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of listAssigneePrincipalRolesForCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{catalogName}/catalog-roles")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.listCatalogRoles")
    @Timeout
    public Response listCatalogRoles(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"listCatalogRoles").addKeyValue("catalogName", (Object)catalogName).log();
        Response ret = this.service.listCatalogRoles(catalogName, realmContext, securityContext);
        LOGGER.debug("Completed execution of listCatalogRoles API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.listCatalogs")
    @Timeout
    public Response listCatalogs(@Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"listCatalogs").log();
        Response ret = this.service.listCatalogs(realmContext, securityContext);
        LOGGER.debug("Completed execution of listCatalogs API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{catalogName}/catalog-roles/{catalogRoleName}/grants")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.listGrantsForCatalogRole")
    @Timeout
    public Response listGrantsForCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"listGrantsForCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).log();
        Response ret = this.service.listGrantsForCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of listGrantsForCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/{catalogName}/catalog-roles/{catalogRoleName}/grants")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.revokeGrantFromCatalogRole")
    @Timeout
    public Response revokeGrantFromCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @DefaultValue(value="false") @QueryParam(value="cascade") Boolean cascade, @Valid RevokeGrantRequest revokeGrantRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"revokeGrantFromCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).addKeyValue("cascade", (Object)cascade).addKeyValue("revokeGrantRequest", (Object)String.valueOf(revokeGrantRequest)).log();
        Response ret = this.service.revokeGrantFromCatalogRole(catalogName, catalogRoleName, cascade, revokeGrantRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of revokeGrantFromCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @PUT
    @Path(value="/{catalogName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.updateCatalog")
    @Timeout
    public Response updateCatalog(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Nonnull @Valid UpdateCatalogRequest updateCatalogRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"updateCatalog").addKeyValue("catalogName", (Object)catalogName).addKeyValue("updateCatalogRequest", (Object)String.valueOf(updateCatalogRequest)).log();
        Response ret = this.service.updateCatalog(catalogName, updateCatalogRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of updateCatalog API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @PUT
    @Path(value="/{catalogName}/catalog-roles/{catalogRoleName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.catalogs.updateCatalogRole")
    @Timeout
    public Response updateCatalogRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="catalogRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String catalogRoleName, @Valid UpdateCatalogRoleRequest updateCatalogRoleRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking catalogs with params").addKeyValue("operation", (Object)"updateCatalogRole").addKeyValue("catalogName", (Object)catalogName).addKeyValue("catalogRoleName", (Object)catalogRoleName).addKeyValue("updateCatalogRoleRequest", (Object)String.valueOf(updateCatalogRoleRequest)).log();
        Response ret = this.service.updateCatalogRole(catalogName, catalogRoleName, updateCatalogRoleRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of updateCatalogRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

