/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PrincipalSecretsGenerator;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.cache.InMemoryEntityCache;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.persistence.transactional.TransactionalMetaStoreManagerImpl;
import org.apache.polaris.core.persistence.transactional.TransactionalPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalPolarisMetaStoreManagerFactory<StoreType>
implements MetaStoreManagerFactory {
    final Map<String, PolarisMetaStoreManager> metaStoreManagerMap = new HashMap<String, PolarisMetaStoreManager>();
    final Map<String, EntityCache> entityCacheMap = new HashMap<String, EntityCache>();
    final Map<String, StoreType> backingStoreMap = new HashMap<String, StoreType>();
    final Map<String, Supplier<TransactionalPersistence>> sessionSupplierMap = new HashMap<String, Supplier<TransactionalPersistence>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalPolarisMetaStoreManagerFactory.class);
    private final Clock clock;
    private final PolarisDiagnostics diagnostics;

    protected LocalPolarisMetaStoreManagerFactory(@Nonnull Clock clock, @Nonnull PolarisDiagnostics diagnostics) {
        this.clock = clock;
        this.diagnostics = diagnostics;
    }

    protected abstract StoreType createBackingStore(@Nonnull PolarisDiagnostics var1);

    protected abstract TransactionalPersistence createMetaStoreSession(@Nonnull StoreType var1, @Nonnull RealmContext var2, @Nullable RootCredentialsSet var3, @Nonnull PolarisDiagnostics var4);

    protected PrincipalSecretsGenerator secretsGenerator(RealmContext realmContext, @Nullable RootCredentialsSet rootCredentialsSet) {
        if (rootCredentialsSet != null) {
            return PrincipalSecretsGenerator.bootstrap(realmContext.getRealmIdentifier(), rootCredentialsSet);
        }
        return PrincipalSecretsGenerator.RANDOM_SECRETS;
    }

    protected PolarisMetaStoreManager createNewMetaStoreManager(Clock clock, PolarisDiagnostics diagnostics) {
        return new TransactionalMetaStoreManagerImpl(clock, diagnostics);
    }

    private void initializeForRealm(RealmContext realmContext, RootCredentialsSet rootCredentialsSet) {
        StoreType backingStore = this.createBackingStore(this.diagnostics);
        this.sessionSupplierMap.put(realmContext.getRealmIdentifier(), () -> this.createMetaStoreSession(backingStore, realmContext, rootCredentialsSet, this.diagnostics));
        PolarisMetaStoreManager metaStoreManager = this.createNewMetaStoreManager(this.clock, this.diagnostics);
        this.metaStoreManagerMap.put(realmContext.getRealmIdentifier(), metaStoreManager);
    }

    @Override
    public synchronized Map<String, PrincipalSecretsResult> bootstrapRealms(Iterable<String> realms, RootCredentialsSet rootCredentialsSet) {
        HashMap<String, PrincipalSecretsResult> results = new HashMap<String, PrincipalSecretsResult>();
        for (String realm : realms) {
            RealmContext realmContext = () -> realm;
            if (this.metaStoreManagerMap.containsKey(realm)) continue;
            this.initializeForRealm(realmContext, rootCredentialsSet);
            PrincipalSecretsResult secretsResult = this.bootstrapServiceAndCreatePolarisPrincipalForRealm(realmContext);
            results.put(realm, secretsResult);
        }
        return Map.copyOf(results);
    }

    @Override
    public Map<String, BaseResult> purgeRealms(Iterable<String> realms) {
        HashMap<String, BaseResult> results = new HashMap<String, BaseResult>();
        for (String realm : realms) {
            RealmContext realmContext = () -> realm;
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            TransactionalPersistence session = this.getOrCreateSession(realmContext);
            PolarisCallContext callContext = new PolarisCallContext(realmContext, session);
            BaseResult result = metaStoreManager.purge(callContext);
            results.put(realm, result);
            this.backingStoreMap.remove(realm);
            this.sessionSupplierMap.remove(realm);
            this.metaStoreManagerMap.remove(realm);
        }
        return Map.copyOf(results);
    }

    @Override
    public synchronized PolarisMetaStoreManager getOrCreateMetaStoreManager(RealmContext realmContext) {
        if (!this.metaStoreManagerMap.containsKey(realmContext.getRealmIdentifier())) {
            this.initializeForRealm(realmContext, null);
            this.checkPolarisServiceBootstrappedForRealm(realmContext);
        }
        return this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
    }

    @Override
    public synchronized TransactionalPersistence getOrCreateSession(RealmContext realmContext) {
        if (!this.sessionSupplierMap.containsKey(realmContext.getRealmIdentifier())) {
            this.initializeForRealm(realmContext, null);
        }
        this.checkPolarisServiceBootstrappedForRealm(realmContext);
        return this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get();
    }

    @Override
    public synchronized EntityCache getOrCreateEntityCache(RealmContext realmContext, RealmConfig realmConfig) {
        if (!this.entityCacheMap.containsKey(realmContext.getRealmIdentifier())) {
            PolarisMetaStoreManager metaStoreManager = this.getOrCreateMetaStoreManager(realmContext);
            this.entityCacheMap.put(realmContext.getRealmIdentifier(), new InMemoryEntityCache(this.diagnostics, realmConfig, metaStoreManager));
        }
        return this.entityCacheMap.get(realmContext.getRealmIdentifier());
    }

    private PrincipalSecretsResult bootstrapServiceAndCreatePolarisPrincipalForRealm(RealmContext realmContext) {
        BasePersistence metaStore;
        PolarisCallContext polarisContext;
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
        Optional<PrincipalEntity> preliminaryRootPrincipal = metaStoreManager.findRootPrincipal(polarisContext = new PolarisCallContext(realmContext, metaStore = (BasePersistence)this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get()));
        if (preliminaryRootPrincipal.isPresent()) {
            String overrideMessage = "It appears this metastore manager has already been bootstrapped. To continue bootstrapping, please first purge the metastore with the `purge` command.";
            LOGGER.error("\n\n {} \n\n", (Object)overrideMessage);
            throw new IllegalArgumentException(overrideMessage);
        }
        metaStoreManager.bootstrapPolarisService(polarisContext);
        PrincipalEntity rootPrincipal = metaStoreManager.findRootPrincipal(polarisContext).orElseThrow();
        return metaStoreManager.loadPrincipalSecrets(polarisContext, rootPrincipal.getClientId());
    }

    private void checkPolarisServiceBootstrappedForRealm(RealmContext realmContext) {
        BasePersistence metaStore;
        PolarisCallContext polarisContext;
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerMap.get(realmContext.getRealmIdentifier());
        Optional<PrincipalEntity> rootPrincipal = metaStoreManager.findRootPrincipal(polarisContext = new PolarisCallContext(realmContext, metaStore = (BasePersistence)this.sessionSupplierMap.get(realmContext.getRealmIdentifier()).get()));
        if (rootPrincipal.isEmpty()) {
            LOGGER.error("\n\n Realm {} is not bootstrapped, could not load root principal. Please run Bootstrap command. \n\n", (Object)realmContext.getRealmIdentifier());
            throw new IllegalStateException("Realm is not bootstrapped, please run server in bootstrap mode.");
        }
    }
}

