/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.net.URI;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Strings;

public class FileURI {
    private String scheme;
    private String authority;
    private String path;
    private String uriAsString;

    public FileURI(String scheme, String authority, String path, String uriAsString) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.uriAsString = uriAsString;
    }

    public FileURI(URI uri, Map<String, String> equalSchemes, Map<String, String> equalAuthorities) {
        this.scheme = equalSchemes.getOrDefault(uri.getScheme(), uri.getScheme());
        this.authority = equalAuthorities.getOrDefault(uri.getAuthority(), uri.getAuthority());
        this.path = uri.getPath();
        this.uriAsString = uri.toString();
    }

    public FileURI() {
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUriAsString() {
        return this.uriAsString;
    }

    public void setUriAsString(String uriAsString) {
        this.uriAsString = uriAsString;
    }

    public boolean schemeMatch(FileURI another) {
        return this.uriComponentMatch(this.scheme, another.getScheme());
    }

    public boolean authorityMatch(FileURI another) {
        return this.uriComponentMatch(this.authority, another.getAuthority());
    }

    private boolean uriComponentMatch(String valid, String actual) {
        return Strings.isNullOrEmpty((String)valid) || valid.equalsIgnoreCase(actual);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scheme", (Object)this.scheme).add("authority", (Object)this.authority).add("path", (Object)this.path).add("uriAsString", (Object)this.uriAsString).toString();
    }
}

