/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.arc.impl.LazyValue;
import jakarta.enterprise.inject.Instance;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;
import org.jboss.resteasy.reactive.common.util.EmptyInputStream;

public abstract class AbstractServerJacksonMessageBodyReader
extends AbstractJsonMessageBodyReader {
    protected final LazyValue<ObjectReader> defaultReader;

    protected AbstractServerJacksonMessageBodyReader() {
        this.defaultReader = null;
    }

    public AbstractServerJacksonMessageBodyReader(final Instance<ObjectMapper> mapper) {
        this.defaultReader = new LazyValue((Supplier)new Supplier<ObjectReader>(){

            @Override
            public ObjectReader get() {
                return ((ObjectMapper)mapper.get()).reader();
            }
        });
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.doReadFrom(type, genericType, entityStream);
    }

    protected ObjectReader getEffectiveReader() {
        return (ObjectReader)this.defaultReader.get();
    }

    private Object doReadFrom(Class<Object> type, Type genericType, InputStream entityStream) throws IOException {
        if (entityStream instanceof EmptyInputStream) {
            return null;
        }
        ObjectReader reader = this.getEffectiveReader();
        return reader.forType(reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
    }
}

