/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.NonAlignEngineDataSet;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithValueFilter;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawDataQueryExecutor {
    protected RawDataQueryPlan queryPlan;
    private static final Logger logger = LoggerFactory.getLogger(RawDataQueryExecutor.class);

    public RawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context) throws StorageEngineException, QueryProcessException {
        QueryDataSet dataSet = this.needRedirect(context, false);
        if (dataSet != null) {
            return dataSet;
        }
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context);
        try {
            return new RawQueryDataSetWithoutValueFilter(context.getQueryId(), this.queryPlan, readersOfSelectedSeries);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageEngineException(e.getMessage());
        }
        catch (IOException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    public final QueryDataSet executeNonAlign(QueryContext context) throws StorageEngineException, QueryProcessException {
        QueryDataSet dataSet = this.needRedirect(context, false);
        if (dataSet != null) {
            return dataSet;
        }
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context);
        return new NonAlignEngineDataSet(context.getQueryId(), this.queryPlan.getDeduplicatedPaths(), this.queryPlan.getDeduplicatedDataTypes(), readersOfSelectedSeries);
    }

    protected List<ManagedSeriesReader> initManagedSeriesReader(QueryContext context) throws StorageEngineException, QueryProcessException {
        Filter timeFilter = null;
        if (this.queryPlan.getExpression() != null) {
            timeFilter = ((GlobalTimeExpression)this.queryPlan.getExpression()).getFilter();
        }
        ArrayList<ManagedSeriesReader> readersOfSelectedSeries = new ArrayList<ManagedSeriesReader>();
        Pair<List<VirtualStorageGroupProcessor>, Map<VirtualStorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(this.queryPlan.getDeduplicatedPaths());
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        try {
            List<PartialPath> paths = this.queryPlan.getDeduplicatedPaths();
            for (PartialPath path : paths) {
                TSDataType dataType = path.getSeriesType();
                QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, timeFilter, this.queryPlan.isAscending());
                timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
                SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, queryDataSource, timeFilter, null, null, this.queryPlan.isAscending());
                readersOfSelectedSeries.add(reader);
            }
        }
        catch (Exception e) {
            logger.error("Meet error when init series reader  ", (Throwable)e);
            throw new QueryProcessException("Meet error when init series reader .", e);
        }
        return readersOfSelectedSeries;
    }

    public final QueryDataSet executeWithValueFilter(QueryContext context) throws StorageEngineException, QueryProcessException {
        QueryDataSet dataSet = this.needRedirect(context, true);
        if (dataSet != null) {
            return dataSet;
        }
        this.queryPlan.setDeduplicatedPaths(this.queryPlan.getDeduplicatedPaths().stream().map(p -> ((MeasurementPath)p).transformToExactPath()).collect(Collectors.toList()));
        TimeGenerator timestampGenerator = this.getTimeGenerator(context, this.queryPlan);
        List cached = ExecutorWithTimeGenerator.markFilterdPaths((IExpression)this.queryPlan.getExpression(), new ArrayList<PartialPath>(this.queryPlan.getDeduplicatedPaths()), (boolean)timestampGenerator.hasOrNode());
        Pair<List<IReaderByTimestamp>, List<List<Integer>>> pair = this.initSeriesReaderByTimestamp(context, this.queryPlan, cached, timestampGenerator.getTimeFilter());
        return new RawQueryDataSetWithValueFilter(this.queryPlan.getDeduplicatedPaths(), this.queryPlan.getDeduplicatedDataTypes(), timestampGenerator, (List)pair.left, (List)pair.right, cached, this.queryPlan.isAscending());
    }

    protected Pair<List<IReaderByTimestamp>, List<List<Integer>>> initSeriesReaderByTimestamp(QueryContext context, RawDataQueryPlan queryPlan, List<Boolean> cached, Filter timeFilter) throws QueryProcessException, StorageEngineException {
        ArrayList<IReaderByTimestamp> readersOfSelectedSeries = new ArrayList<IReaderByTimestamp>();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        ArrayList<PartialPath> notCachedPathList = new ArrayList<PartialPath>();
        ArrayList<List<Integer>> readerToIndexList = new ArrayList<List<Integer>>();
        HashMap<String, Integer> fullPathToReaderIndexMap = new HashMap<String, Integer>();
        List<PartialPath> deduplicatedPaths = queryPlan.getDeduplicatedPaths();
        int index = 0;
        for (int i = 0; i < cached.size(); ++i) {
            if (cached.get(i).booleanValue()) {
                pathList.add(deduplicatedPaths.get(i));
                readerToIndexList.add(Collections.singletonList(i));
                cached.set(index++, Boolean.TRUE);
                continue;
            }
            notCachedPathList.add(deduplicatedPaths.get(i));
            String fullPath = deduplicatedPaths.get(i).getFullPath();
            Integer readerIndex = (Integer)fullPathToReaderIndexMap.get(fullPath);
            if (readerIndex != null) {
                AlignedPath anotherSubSensor = (AlignedPath)deduplicatedPaths.get(i);
                ((AlignedPath)pathList.get(readerIndex)).mergeAlignedPath(anotherSubSensor);
                ((List)readerToIndexList.get(readerIndex)).add(i);
                continue;
            }
            pathList.add(deduplicatedPaths.get(i));
            fullPathToReaderIndexMap.put(fullPath, index);
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            indexList.add(i);
            readerToIndexList.add(indexList);
            cached.set(index++, Boolean.FALSE);
        }
        queryPlan.setDeduplicatedPaths(pathList);
        int previousSize = cached.size();
        if (previousSize > pathList.size()) {
            cached.subList(pathList.size(), previousSize).clear();
        }
        Pair<List<VirtualStorageGroupProcessor>, Map<VirtualStorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(notCachedPathList);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (int i = 0; i < queryPlan.getDeduplicatedPaths().size(); ++i) {
            if (cached.get(i).booleanValue()) {
                readersOfSelectedSeries.add(null);
                continue;
            }
            PartialPath path = queryPlan.getDeduplicatedPaths().get(i);
            IReaderByTimestamp seriesReaderByTimestamp = this.getReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), queryPlan.getDeduplicatedDataTypes().get(i), context);
            readersOfSelectedSeries.add(seriesReaderByTimestamp);
        }
        return new Pair(readersOfSelectedSeries, readerToIndexList);
    }

    protected IReaderByTimestamp getReaderByTimestamp(PartialPath path, Set<String> allSensors, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, allSensors, dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null, this.queryPlan.isAscending()), null, this.queryPlan.isAscending());
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(context, queryPlan);
    }

    protected QueryDataSet needRedirect(QueryContext context, boolean hasValueFilter) throws StorageEngineException, QueryProcessException {
        return null;
    }
}

