/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricNameTool;
import org.apache.iotdb.metrics.utils.IoTDBMetricsUtils;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBReporter
extends ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBReporter.class);
    private static final MetricConfig.IoTDBReporterConfig ioTDBReporterConfig = MetricConfigDescriptor.getInstance().getMetricConfig().getIoTDBReporterConfig();
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private final String prefix;
    private final SessionPool sessionPool;

    protected IoTDBReporter(MetricRegistry registry, String prefix, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop) {
        super(registry, "iotdb-reporter", filter, RATE_UNIT, DURATION_UNIT, executor, shutdownExecutorOnStop);
        this.prefix = prefix;
        this.sessionPool = new SessionPool(ioTDBReporterConfig.getHost(), ioTDBReporterConfig.getPort().intValue(), ioTDBReporterConfig.getUsername(), ioTDBReporterConfig.getPassword(), ioTDBReporterConfig.getMaxConnectionNumber().intValue());
    }

    public void stop() {
        super.stop();
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.sendGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.sendCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.sendHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.sendMeter(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.sendTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void sendGauge(String name, Gauge gauge) {
        if (null == gauge) {
            return;
        }
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.GAUGE, name);
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            double value = ((Number)obj).doubleValue();
            this.updateValue(this.prefixed(metricInfo.getName()), metricInfo.getTags(), value);
        } else if (obj instanceof Boolean) {
            this.updateValue(this.prefixed(metricInfo.getName()), metricInfo.getTags(), obj);
        }
    }

    private void sendCounter(String name, Counter counter) {
        if (null == counter) {
            return;
        }
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.COUNTER, name);
        double value = counter.getCount();
        this.updateValue(this.prefixed(metricInfo.getName()), metricInfo.getTags(), value);
    }

    private void sendHistogram(String name, Histogram histogram) {
        if (null == histogram) {
            return;
        }
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.HISTOGRAM, name);
        this.writeSnapshotAndCount(this.prefixed(metricInfo.getName()), metricInfo.getTags(), histogram.getSnapshot(), histogram.getCount(), 1.0);
    }

    private void sendMeter(String name, Meter meter) {
        if (null == meter) {
            return;
        }
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.GAUGE, name);
        double value = meter.getCount();
        this.updateValue(this.prefixed(metricInfo.getName()), metricInfo.getTags(), value);
    }

    private void sendTimer(String name, Timer timer) {
        if (null == timer) {
            return;
        }
        MetricInfo metricInfo = DropwizardMetricNameTool.transformFromString(MetricType.GAUGE, name);
        this.writeSnapshotAndCount(this.prefixed(metricInfo.getName()), metricInfo.getTags(), timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L));
    }

    private void writeSnapshotAndCount(String name, Map<String, String> tags, Snapshot snapshot, long count, double factor) {
        this.updateValue(name, this.addTags(tags, "quantile", "0.5"), snapshot.getMedian() * factor);
        this.updateValue(name, this.addTags(tags, "quantile", "0.75"), snapshot.get75thPercentile() * factor);
        this.updateValue(name, this.addTags(tags, "quantile", "0.95"), snapshot.get95thPercentile() * factor);
        this.updateValue(name, this.addTags(tags, "quantile", "0.98"), snapshot.get98thPercentile() * factor);
        this.updateValue(name, this.addTags(tags, "quantile", "0.99"), snapshot.get99thPercentile() * factor);
        this.updateValue(name, this.addTags(tags, "quantile", "0.999"), snapshot.get999thPercentile() * factor);
        this.updateValue(name + "_min", tags, snapshot.getMin());
        this.updateValue(name + "_max", tags, snapshot.getMax());
        this.updateValue(name + "_median", tags, snapshot.getMedian());
        this.updateValue(name + "_mean", tags, snapshot.getMean());
        this.updateValue(name + "_stddev", tags, snapshot.getStdDev());
        this.updateValue(name + "_count", tags, count);
    }

    private void updateValue(String name, Map<String, String> labels, Object value) {
        if (value != null) {
            String deviceId = IoTDBMetricsUtils.generatePath((String)name, labels);
            List<String> sensors = Collections.singletonList("value");
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            if (value instanceof Boolean) {
                dataTypes.add(TSDataType.BOOLEAN);
            } else if (value instanceof Integer) {
                dataTypes.add(TSDataType.INT32);
            } else if (value instanceof Long) {
                dataTypes.add(TSDataType.INT64);
            } else if (value instanceof Double) {
                dataTypes.add(TSDataType.DOUBLE);
            } else {
                dataTypes.add(TSDataType.TEXT);
                value = value.toString();
            }
            List<Object> values = Collections.singletonList(value);
            try {
                this.sessionPool.insertRecord(deviceId, System.currentTimeMillis(), sensors, dataTypes, values);
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                logger.warn("Failed to insert record");
            }
        }
    }

    private String prefixed(String name) {
        return this.prefix == null ? name : this.prefix + name;
    }

    private Map<String, String> addTags(Map<String, String> tags, String key, String value) {
        HashMap<String, String> result = new HashMap<String, String>(tags);
        result.put(key, value);
        return result;
    }

    public static Builder forRegistry(MetricRegistry metricRegistry) {
        return new Builder(metricRegistry);
    }

    public static class Builder {
        private final MetricRegistry metricRegistry;
        private String prefix;
        private MetricFilter metricFilter;
        private ScheduledExecutorService executorService;
        private boolean shutdownExecutorOnStop;

        private Builder(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            this.prefix = null;
            this.metricFilter = MetricFilter.ALL;
            this.executorService = null;
            this.shutdownExecutorOnStop = true;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder filter(MetricFilter metricFilter) {
            this.metricFilter = metricFilter;
            return this;
        }

        public IoTDBReporter build() {
            return new IoTDBReporter(this.metricRegistry, this.prefix, this.metricFilter, this.executorService, this.shutdownExecutorOnStop);
        }
    }
}

