/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationData;

public class EventNotificationList
extends NotificationData
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=914");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=916");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=915");
    private final EventFieldList[] events;

    public EventNotificationList(EventFieldList[] events) {
        this.events = events;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public EventFieldList[] getEvents() {
        return this.events;
    }

    protected EventNotificationList(EventNotificationListBuilder<?, ?> b) {
        super((NotificationData.NotificationDataBuilder<?, ?>)b);
        this.events = ((EventNotificationListBuilder)b).events;
    }

    public static EventNotificationListBuilder<?, ?> builder() {
        return new EventNotificationListBuilderImpl();
    }

    public EventNotificationListBuilder<?, ?> toBuilder() {
        return new EventNotificationListBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventNotificationList)) {
            return false;
        }
        EventNotificationList other = (EventNotificationList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getEvents(), other.getEvents());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EventNotificationList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getEvents());
        return result;
    }

    @Override
    public String toString() {
        return "EventNotificationList(events=" + Arrays.deepToString(this.getEvents()) + ")";
    }

    private static final class EventNotificationListBuilderImpl
    extends EventNotificationListBuilder<EventNotificationList, EventNotificationListBuilderImpl> {
        private EventNotificationListBuilderImpl() {
        }

        @Override
        protected EventNotificationListBuilderImpl self() {
            return this;
        }

        @Override
        public EventNotificationList build() {
            return new EventNotificationList(this);
        }
    }

    public static abstract class EventNotificationListBuilder<C extends EventNotificationList, B extends EventNotificationListBuilder<C, B>>
    extends NotificationData.NotificationDataBuilder<C, B> {
        private EventFieldList[] events;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EventNotificationListBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EventNotificationList instance, EventNotificationListBuilder<?, ?> b) {
            b.events(instance.events);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B events(EventFieldList[] events) {
            this.events = events;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EventNotificationList.EventNotificationListBuilder(super=" + super.toString() + ", events=" + Arrays.deepToString(this.events) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EventNotificationList> {
        @Override
        public Class<EventNotificationList> getType() {
            return EventNotificationList.class;
        }

        @Override
        public EventNotificationList decode(SerializationContext context, UaDecoder decoder) {
            EventFieldList[] events = (EventFieldList[])decoder.readStructArray("Events", EventFieldList.TYPE_ID);
            return new EventNotificationList(events);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EventNotificationList value) {
            encoder.writeStructArray("Events", (Object[])value.getEvents(), EventFieldList.TYPE_ID);
        }
    }
}

