/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractSerializableListeningQueue;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.source.schemaregion.SchemaRegionListeningQueue;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeSchemaRegionListenerMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSchemaRegionListenerMetrics.class);
    private volatile AbstractMetricService metricService;
    private final ConcurrentMap<Integer, SchemaRegionListeningQueue> listeningQueueMap = new ConcurrentHashMap<Integer, SchemaRegionListeningQueue>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.listeningQueueMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(Integer schemaRegionId) {
        this.createAutoGauge(schemaRegionId);
    }

    private void createAutoGauge(Integer schemaRegionId) {
        this.metricService.createAutoGauge(Metric.PIPE_SCHEMA_LINKED_QUEUE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)((SchemaRegionListeningQueue)((Object)this.listeningQueueMap.get(schemaRegionId))), AbstractSerializableListeningQueue::getSize, new String[]{Tag.REGION.toString(), String.valueOf(schemaRegionId)});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.listeningQueueMap.keySet()).forEach(this::deregister);
        if (!this.listeningQueueMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe schema region listener metrics, listening queue map not empty");
        }
    }

    private void removeMetrics(Integer schemaRegionId) {
        this.removeAutoGauge(schemaRegionId);
    }

    private void removeAutoGauge(Integer schemaRegionId) {
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_SCHEMA_LINKED_QUEUE_SIZE.toString(), new String[]{Tag.REGION.toString(), String.valueOf(schemaRegionId)});
    }

    public void register(@NonNull SchemaRegionListeningQueue schemaRegionListeningQueue, Integer schemaRegionId) {
        this.listeningQueueMap.putIfAbsent(schemaRegionId, schemaRegionListeningQueue);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(schemaRegionId);
        }
    }

    public void deregister(Integer schemaRegionId) {
        if (!this.listeningQueueMap.containsKey(schemaRegionId)) {
            LOGGER.warn("Failed to deregister schema region listener metrics, SchemaRegionListeningQueue({}) does not exist", (Object)schemaRegionId);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(schemaRegionId);
        }
        this.listeningQueueMap.remove(schemaRegionId);
    }

    public static PipeSchemaRegionListenerMetrics getInstance() {
        return PipeSchemaRegionListenerMetricsHolder.INSTANCE;
    }

    private PipeSchemaRegionListenerMetrics() {
    }

    private static class PipeSchemaRegionListenerMetricsHolder {
        private static final PipeSchemaRegionListenerMetrics INSTANCE = new PipeSchemaRegionListenerMetrics();

        private PipeSchemaRegionListenerMetricsHolder() {
        }
    }
}

