/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.Iterator;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class InformationSchemaTableScanOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final Iterator<TsBlock> contentSupplier;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InformationSchemaTableScanOperator.class);

    public InformationSchemaTableScanOperator(OperatorContext operatorContext, PlanNodeId sourceId, Iterator<TsBlock> contentSupplier) {
        this.operatorContext = operatorContext;
        this.sourceId = sourceId;
        this.contentSupplier = contentSupplier;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        return this.contentSupplier.next();
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.contentSupplier.hasNext();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNext();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public long calculateMaxPeekMemory() {
        return DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId);
    }
}

