/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.control;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.storageengine.dataregion.read.control.QueryFileManager;

public class QueryResourceManager {
    private final AtomicLong queryIdAtom = new AtomicLong();
    private final QueryFileManager filePathsManager = new QueryFileManager();

    private QueryResourceManager() {
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignQueryId() {
        return this.queryIdAtom.incrementAndGet();
    }

    public long assignCompactionQueryId() {
        long threadNum = Long.parseLong(Thread.currentThread().getName().split("-")[5]);
        long queryId = Long.MIN_VALUE + threadNum;
        this.filePathsManager.addQueryId(queryId);
        return queryId;
    }

    public void endQuery(long queryId) {
        this.filePathsManager.removeUsedFilesForQuery(queryId);
    }

    public QueryFileManager getQueryFileManager() {
        return this.filePathsManager;
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

