/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyLDAPRequest;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.util.Extensible;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public abstract class LDAPRequest
implements ReadOnlyLDAPRequest {
    @NotNull
    static final Control[] NO_CONTROLS = new Control[0];
    private static final long serialVersionUID = -2040756188243320117L;
    @Nullable
    private Boolean followReferrals;
    @NotNull
    private Control[] controls;
    @Nullable
    private IntermediateResponseListener intermediateResponseListener;
    private long responseTimeout;
    @Nullable
    private ReferralConnector referralConnector;

    protected LDAPRequest(@Nullable Control[] controls) {
        this.controls = controls == null ? NO_CONTROLS : controls;
        this.followReferrals = null;
        this.responseTimeout = -1L;
        this.intermediateResponseListener = null;
        this.referralConnector = null;
    }

    @Override
    @NotNull
    public final Control[] getControls() {
        return this.controls;
    }

    @Override
    @NotNull
    public final List<Control> getControlList() {
        return Collections.unmodifiableList(Arrays.asList(this.controls));
    }

    @Override
    public final boolean hasControl() {
        return this.controls.length > 0;
    }

    @Override
    public final boolean hasControl(@NotNull String oid) {
        Validator.ensureNotNull(oid);
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public final Control getControl(@NotNull String oid) {
        Validator.ensureNotNull(oid);
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    final void setControlsInternal(@NotNull Control[] controls) {
        this.controls = controls;
    }

    @Override
    public final long getResponseTimeoutMillis(@Nullable LDAPConnection connection) {
        if (this.responseTimeout < 0L && connection != null) {
            if (this instanceof ExtendedRequest) {
                ExtendedRequest extendedRequest = (ExtendedRequest)this;
                return connection.getConnectionOptions().getExtendedOperationResponseTimeoutMillis(extendedRequest.getOID());
            }
            return connection.getConnectionOptions().getResponseTimeoutMillis(this.getOperationType());
        }
        return this.responseTimeout;
    }

    public final void setResponseTimeoutMillis(long responseTimeout) {
        this.responseTimeout = responseTimeout < 0L ? -1L : responseTimeout;
    }

    @Override
    public final boolean followReferrals(@NotNull LDAPConnection connection) {
        if (this.followReferrals == null) {
            return connection.getConnectionOptions().followReferrals();
        }
        return this.followReferrals;
    }

    @Nullable
    final Boolean followReferralsInternal() {
        return this.followReferrals;
    }

    public final void setFollowReferrals(@Nullable Boolean followReferrals) {
        this.followReferrals = followReferrals;
    }

    @Override
    @NotNull
    public final ReferralConnector getReferralConnector(@NotNull LDAPConnection connection) {
        if (this.referralConnector == null) {
            return connection.getReferralConnector();
        }
        return this.referralConnector;
    }

    @Nullable
    final ReferralConnector getReferralConnectorInternal() {
        return this.referralConnector;
    }

    public final void setReferralConnector(@Nullable ReferralConnector referralConnector) {
        this.referralConnector = referralConnector;
    }

    @Nullable
    public final IntermediateResponseListener getIntermediateResponseListener() {
        return this.intermediateResponseListener;
    }

    public final void setIntermediateResponseListener(@Nullable IntermediateResponseListener listener) {
        this.intermediateResponseListener = listener;
    }

    @InternalUseOnly
    @NotNull
    protected abstract LDAPResult process(@NotNull LDAPConnection var1, int var2) throws LDAPException;

    public abstract int getLastMessageID();

    @NotNull
    public abstract OperationType getOperationType();

    @Override
    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public abstract void toString(@NotNull StringBuilder var1);
}

