/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.data;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.data.LdapUsersRepositoryModule;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersRepositoryModuleChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersRepositoryModuleChooser.class);
    private final Module defaultUsersRepositoryModule;

    public UsersRepositoryModuleChooser(Module defaultUsersRepositoryModule) {
        this.defaultUsersRepositoryModule = defaultUsersRepositoryModule;
    }

    public List<Module> chooseModules(Implementation implementation) {
        switch (implementation) {
            case LDAP: {
                return ImmutableList.of((Object)((Object)new LdapUsersRepositoryModule()));
            }
            case DEFAULT: {
                return ImmutableList.of((Object)this.defaultUsersRepositoryModule);
            }
        }
        throw new NotImplementedException(implementation + " is not a supported option");
    }

    public static enum Implementation {
        LDAP,
        DEFAULT;


        public static Implementation parse(FileConfigurationProvider configurationProvider) {
            try {
                return Optional.ofNullable(configurationProvider.getConfiguration("usersrepository").getString("[@ldapHost]", null)).map(anyHost -> LDAP).orElse(DEFAULT);
            }
            catch (ConfigurationException e) {
                LOGGER.warn("Error reading usersrepository.xml, defaulting to default implementation", (Throwable)e);
                return DEFAULT;
            }
        }
    }
}

