/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.events.DispatchingFailureGroup;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusId;
import org.apache.james.events.EventBusName;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventDispatcher;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.GroupRegistrationHandler;
import org.apache.james.events.KeyRegistrationHandler;
import org.apache.james.events.ListenerExecutor;
import org.apache.james.events.LocalListenerRegistry;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.RoutingKeyConverter;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.Sender;

public class RabbitMQEventBus
implements EventBus,
Startable {
    private static final Set<RegistrationKey> NO_KEY = ImmutableSet.of();
    private static final String NOT_RUNNING_ERROR_MESSAGE = "Event Bus is not running";
    static final String EVENT_BUS_ID = "eventBusId";
    private final NamingStrategy namingStrategy;
    private final EventSerializer eventSerializer;
    private final RoutingKeyConverter routingKeyConverter;
    private final RetryBackoffConfiguration retryBackoff;
    private final EventBusId eventBusId;
    private final EventDeadLetters eventDeadLetters;
    private final ListenerExecutor listenerExecutor;
    private final Sender sender;
    private final ReceiverProvider receiverProvider;
    private final ReactorRabbitMQChannelPool channelPool;
    private final RabbitMQConfiguration configuration;
    private final MetricFactory metricFactory;
    private volatile boolean isRunning;
    private volatile boolean isStopping;
    private GroupRegistrationHandler groupRegistrationHandler;
    private KeyRegistrationHandler keyRegistrationHandler;
    private EventDispatcher eventDispatcher;

    @Inject
    public RabbitMQEventBus(NamingStrategy namingStrategy, Sender sender, ReceiverProvider receiverProvider, EventSerializer eventSerializer, RetryBackoffConfiguration retryBackoff, RoutingKeyConverter routingKeyConverter, EventDeadLetters eventDeadLetters, MetricFactory metricFactory, ReactorRabbitMQChannelPool channelPool, EventBusId eventBusId, RabbitMQConfiguration configuration) {
        this.namingStrategy = namingStrategy;
        this.sender = sender;
        this.receiverProvider = receiverProvider;
        this.listenerExecutor = new ListenerExecutor(metricFactory);
        this.channelPool = channelPool;
        this.eventBusId = eventBusId;
        this.eventSerializer = eventSerializer;
        this.routingKeyConverter = routingKeyConverter;
        this.retryBackoff = retryBackoff;
        this.eventDeadLetters = eventDeadLetters;
        this.configuration = configuration;
        this.metricFactory = metricFactory;
        this.isRunning = false;
        this.isStopping = false;
    }

    public void start() {
        if (!this.isRunning && !this.isStopping) {
            LocalListenerRegistry localListenerRegistry = new LocalListenerRegistry();
            this.keyRegistrationHandler = new KeyRegistrationHandler(this.namingStrategy, this.eventBusId, this.eventSerializer, this.sender, this.receiverProvider, this.routingKeyConverter, localListenerRegistry, this.listenerExecutor, this.retryBackoff, this.configuration, this.metricFactory);
            this.groupRegistrationHandler = new GroupRegistrationHandler(this.namingStrategy, this.eventSerializer, this.channelPool, this.sender, this.receiverProvider, this.retryBackoff, this.eventDeadLetters, this.listenerExecutor, this.eventBusId, this.configuration);
            this.eventDispatcher = new EventDispatcher(this.namingStrategy, this.eventBusId, this.eventSerializer, this.sender, localListenerRegistry, this.listenerExecutor, this.eventDeadLetters, this.configuration);
            this.eventDispatcher.start();
            this.keyRegistrationHandler.start();
            this.isRunning = true;
        }
    }

    public void restart() {
        this.keyRegistrationHandler.restart();
        this.groupRegistrationHandler.restart();
    }

    @VisibleForTesting
    void startWithoutStartingKeyRegistrationHandler() {
        if (!this.isRunning && !this.isStopping) {
            LocalListenerRegistry localListenerRegistry = new LocalListenerRegistry();
            this.keyRegistrationHandler = new KeyRegistrationHandler(this.namingStrategy, this.eventBusId, this.eventSerializer, this.sender, this.receiverProvider, this.routingKeyConverter, localListenerRegistry, this.listenerExecutor, this.retryBackoff, this.configuration, this.metricFactory);
            this.groupRegistrationHandler = new GroupRegistrationHandler(this.namingStrategy, this.eventSerializer, this.channelPool, this.sender, this.receiverProvider, this.retryBackoff, this.eventDeadLetters, this.listenerExecutor, this.eventBusId, this.configuration);
            this.eventDispatcher = new EventDispatcher(this.namingStrategy, this.eventBusId, this.eventSerializer, this.sender, localListenerRegistry, this.listenerExecutor, this.eventDeadLetters, this.configuration);
            this.keyRegistrationHandler.declareQueue();
            this.eventDispatcher.start();
            this.isRunning = true;
        }
    }

    @VisibleForTesting
    void startKeyRegistrationHandler() {
        this.keyRegistrationHandler.start();
    }

    @PreDestroy
    public void stop() {
        if (this.isRunning && !this.isStopping) {
            this.isStopping = true;
            this.isRunning = false;
            this.groupRegistrationHandler.stop();
            this.keyRegistrationHandler.stop();
        }
    }

    public Mono<Registration> register(EventListener.ReactiveEventListener listener, RegistrationKey key) {
        Preconditions.checkState((boolean)this.isRunning, (Object)NOT_RUNNING_ERROR_MESSAGE);
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("rabbit-register", this.keyRegistrationHandler.register(listener, key)));
    }

    public Registration register(EventListener.ReactiveEventListener listener, Group group) {
        Preconditions.checkState((boolean)this.isRunning, (Object)NOT_RUNNING_ERROR_MESSAGE);
        return this.groupRegistrationHandler.register(listener, group);
    }

    public Mono<Void> dispatch(Event event, Set<RegistrationKey> key) {
        Preconditions.checkState((boolean)this.isRunning, (Object)NOT_RUNNING_ERROR_MESSAGE);
        if (!event.isNoop()) {
            return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("rabbit-dispatch", this.eventDispatcher.dispatch(event, key)));
        }
        return Mono.empty();
    }

    public Mono<Void> reDeliver(Group group, Event event) {
        Preconditions.checkState((boolean)this.isRunning, (Object)NOT_RUNNING_ERROR_MESSAGE);
        if (!event.isNoop()) {
            if (group instanceof DispatchingFailureGroup) {
                return this.eventDispatcher.dispatch(event, NO_KEY);
            }
            return this.groupRegistrationHandler.retrieveGroupRegistration(group).reDeliver(event);
        }
        return Mono.empty();
    }

    public EventBusName eventBusName() {
        return this.namingStrategy.getEventBusName();
    }

    public Collection<Group> listRegisteredGroups() {
        return this.groupRegistrationHandler.registeredGroups();
    }
}

