/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.GSSAPIChannelBindingType;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBuffer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GSSAPIBindRequestProperties
implements Serializable {
    private static final long serialVersionUID = 6872295509330315713L;
    @Nullable
    private ASN1OctetString password;
    private boolean enableGSSAPIDebugging;
    @Nullable
    private Boolean isInitiator;
    private boolean refreshKrb5Config;
    private boolean renewTGT;
    private boolean requireCachedCredentials;
    private boolean useKeyTab;
    private boolean useSubjectCredentialsOnly;
    private boolean useTicketCache;
    @Nullable
    private byte[] configFileDigest;
    @NotNull
    private GSSAPIChannelBindingType channelBindingType;
    @NotNull
    private List<SASLQualityOfProtection> allowedQoP;
    @NotNull
    private Set<String> suppressedSystemProperties;
    @Nullable
    private String authenticationID;
    @Nullable
    private String authorizationID;
    @Nullable
    private String configFilePath;
    @NotNull
    private String jaasClientName;
    @Nullable
    private String kdcAddress;
    @Nullable
    private String keyTabPath;
    @Nullable
    private String realm;
    @Nullable
    private String saslClientServerName;
    @NotNull
    private String servicePrincipalProtocol;
    @Nullable
    private String ticketCachePath;

    public GSSAPIBindRequestProperties(@Nullable String authenticationID, @Nullable String password) {
        this(authenticationID, null, password == null ? null : new ASN1OctetString(password), null, null, null);
    }

    public GSSAPIBindRequestProperties(@Nullable String authenticationID, @Nullable byte[] password) {
        this(authenticationID, null, password == null ? null : new ASN1OctetString(password), null, null, null);
    }

    GSSAPIBindRequestProperties(@Nullable String authenticationID, @Nullable String authorizationID, @Nullable ASN1OctetString password, @Nullable String realm, @Nullable String kdcAddress, @Nullable String configFilePath) {
        this.authenticationID = authenticationID;
        this.authorizationID = authorizationID;
        this.password = password;
        this.realm = realm;
        this.kdcAddress = kdcAddress;
        this.configFilePath = configFilePath;
        this.servicePrincipalProtocol = "ldap";
        this.enableGSSAPIDebugging = false;
        this.jaasClientName = "GSSAPIBindRequest";
        this.isInitiator = null;
        this.refreshKrb5Config = false;
        this.renewTGT = false;
        this.useKeyTab = false;
        this.useSubjectCredentialsOnly = true;
        this.useTicketCache = true;
        this.requireCachedCredentials = false;
        this.saslClientServerName = null;
        this.keyTabPath = null;
        this.ticketCachePath = null;
        this.suppressedSystemProperties = Collections.emptySet();
        this.allowedQoP = Collections.singletonList(SASLQualityOfProtection.AUTH);
        this.channelBindingType = GSSAPIChannelBindingType.NONE;
    }

    @Nullable
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public void setAuthenticationID(@Nullable String authenticationID) {
        this.authenticationID = authenticationID;
    }

    @Nullable
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(@Nullable String authorizationID) {
        this.authorizationID = authorizationID;
    }

    @Nullable
    public ASN1OctetString getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password == null ? null : new ASN1OctetString(password);
    }

    public void setPassword(@Nullable byte[] password) {
        this.password = password == null ? null : new ASN1OctetString(password);
    }

    public void setPassword(@Nullable ASN1OctetString password) {
        this.password = password;
    }

    @Nullable
    public String getRealm() {
        return this.realm;
    }

    public void setRealm(@Nullable String realm) {
        this.realm = realm;
    }

    @NotNull
    public List<SASLQualityOfProtection> getAllowedQoP() {
        return this.allowedQoP;
    }

    public void setAllowedQoP(@Nullable List<SASLQualityOfProtection> allowedQoP) {
        this.allowedQoP = allowedQoP == null || allowedQoP.isEmpty() ? Collections.singletonList(SASLQualityOfProtection.AUTH) : Collections.unmodifiableList(new ArrayList<SASLQualityOfProtection>(allowedQoP));
    }

    public void setAllowedQoP(SASLQualityOfProtection ... allowedQoP) {
        this.setAllowedQoP(StaticUtils.toList(allowedQoP));
    }

    @Nullable
    public String getKDCAddress() {
        return this.kdcAddress;
    }

    public void setKDCAddress(@Nullable String kdcAddress) {
        this.kdcAddress = kdcAddress;
    }

    @NotNull
    public String getJAASClientName() {
        return this.jaasClientName;
    }

    public void setJAASClientName(@NotNull String jaasClientName) {
        Validator.ensureNotNull(jaasClientName);
        this.jaasClientName = jaasClientName;
        this.configFileDigest = null;
    }

    @Nullable
    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(@Nullable String configFilePath) {
        this.configFilePath = configFilePath;
    }

    @Nullable
    public String getSASLClientServerName() {
        return this.saslClientServerName;
    }

    public void setSASLClientServerName(@Nullable String saslClientServerName) {
        this.saslClientServerName = saslClientServerName;
    }

    @NotNull
    public String getServicePrincipalProtocol() {
        return this.servicePrincipalProtocol;
    }

    public void setServicePrincipalProtocol(@NotNull String servicePrincipalProtocol) {
        Validator.ensureNotNull(servicePrincipalProtocol);
        this.servicePrincipalProtocol = servicePrincipalProtocol;
    }

    public boolean refreshKrb5Config() {
        return this.refreshKrb5Config;
    }

    public void setRefreshKrb5Config(boolean refreshKrb5Config) {
        this.refreshKrb5Config = refreshKrb5Config;
        this.configFileDigest = null;
    }

    public boolean useSubjectCredentialsOnly() {
        return this.useSubjectCredentialsOnly;
    }

    public void setUseSubjectCredentialsOnly(boolean useSubjectCredentialsOnly) {
        this.useSubjectCredentialsOnly = useSubjectCredentialsOnly;
    }

    public boolean useKeyTab() {
        return this.useKeyTab;
    }

    public void setUseKeyTab(boolean useKeyTab) {
        this.useKeyTab = useKeyTab;
        this.configFileDigest = null;
    }

    @Nullable
    public String getKeyTabPath() {
        return this.keyTabPath;
    }

    public void setKeyTabPath(@Nullable String keyTabPath) {
        this.keyTabPath = keyTabPath;
        this.configFileDigest = null;
    }

    public boolean useTicketCache() {
        return this.useTicketCache;
    }

    public void setUseTicketCache(boolean useTicketCache) {
        this.useTicketCache = useTicketCache;
        this.configFileDigest = null;
    }

    public boolean requireCachedCredentials() {
        return this.requireCachedCredentials;
    }

    public void setRequireCachedCredentials(boolean requireCachedCredentials) {
        this.requireCachedCredentials = requireCachedCredentials;
        this.configFileDigest = null;
    }

    @Nullable
    public String getTicketCachePath() {
        return this.ticketCachePath;
    }

    public void setTicketCachePath(@Nullable String ticketCachePath) {
        this.ticketCachePath = ticketCachePath;
        this.configFileDigest = null;
    }

    public boolean renewTGT() {
        return this.renewTGT;
    }

    public void setRenewTGT(boolean renewTGT) {
        this.renewTGT = renewTGT;
        this.configFileDigest = null;
    }

    @Nullable
    public Boolean getIsInitiator() {
        return this.isInitiator;
    }

    public void setIsInitiator(@Nullable Boolean isInitiator) {
        this.isInitiator = isInitiator;
        this.configFileDigest = null;
    }

    @NotNull
    public GSSAPIChannelBindingType getChannelBindingType() {
        return this.channelBindingType;
    }

    public void setChannelBindingType(@Nullable GSSAPIChannelBindingType channelBindingType) {
        this.channelBindingType = channelBindingType == null ? GSSAPIChannelBindingType.NONE : channelBindingType;
    }

    @NotNull
    public Set<String> getSuppressedSystemProperties() {
        return this.suppressedSystemProperties;
    }

    public void setSuppressedSystemProperties(@Nullable Collection<String> suppressedSystemProperties) {
        this.suppressedSystemProperties = suppressedSystemProperties == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(suppressedSystemProperties));
    }

    public boolean enableGSSAPIDebugging() {
        return this.enableGSSAPIDebugging;
    }

    public void setEnableGSSAPIDebugging(boolean enableGSSAPIDebugging) {
        this.enableGSSAPIDebugging = enableGSSAPIDebugging;
        this.configFileDigest = null;
    }

    @NotNull
    byte[] getConfigFileDigest() throws LDAPException {
        if (this.configFileDigest != null) {
            return this.configFileDigest;
        }
        JSONBuffer buffer = new JSONBuffer();
        buffer.beginObject();
        buffer.appendString("jaasClientName", this.jaasClientName);
        if (this.isInitiator != null) {
            buffer.appendBoolean("isInitiator", this.isInitiator);
        }
        buffer.appendBoolean("refreshKrb5Config", this.refreshKrb5Config);
        buffer.appendBoolean("useKeyTab", this.useKeyTab);
        if (this.keyTabPath != null) {
            buffer.appendString("keyTabPath", this.keyTabPath);
        }
        buffer.appendBoolean("useTicketCache", this.useTicketCache);
        buffer.appendBoolean("renewTGT", this.renewTGT);
        buffer.appendBoolean("requireCachedCredentials", this.requireCachedCredentials);
        if (this.ticketCachePath != null) {
            buffer.appendString("ticketCachePath", this.ticketCachePath);
        }
        buffer.appendBoolean("enableGSSAPIDebugging", this.enableGSSAPIDebugging);
        buffer.endObject();
        try {
            byte[] bufferBytes = buffer.getBuffer().toByteArray();
            this.configFileDigest = CryptoHelper.sha256(bufferBytes);
            return this.configFileDigest;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_PROPERTIES_CANNOT_COMPUTE_DIGEST.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GSSAPIBindRequestProperties(");
        if (this.authenticationID != null) {
            buffer.append("authenticationID='");
            buffer.append(this.authenticationID);
            buffer.append("', ");
        }
        if (this.authorizationID != null) {
            buffer.append("authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append("', ");
        }
        if (this.realm != null) {
            buffer.append("realm='");
            buffer.append(this.realm);
            buffer.append("', ");
        }
        buffer.append("qop='");
        buffer.append(SASLQualityOfProtection.toString(this.allowedQoP));
        buffer.append("', ");
        if (this.kdcAddress != null) {
            buffer.append("kdcAddress='");
            buffer.append(this.kdcAddress);
            buffer.append("', ");
        }
        buffer.append(", refreshKrb5Config=");
        buffer.append(this.refreshKrb5Config);
        buffer.append(", useSubjectCredentialsOnly=");
        buffer.append(this.useSubjectCredentialsOnly);
        buffer.append(", useKeyTab=");
        buffer.append(this.useKeyTab);
        buffer.append(", ");
        if (this.keyTabPath != null) {
            buffer.append("keyTabPath='");
            buffer.append(this.keyTabPath);
            buffer.append("', ");
        }
        if (this.useTicketCache) {
            buffer.append("useTicketCache=true, requireCachedCredentials=");
            buffer.append(this.requireCachedCredentials);
            buffer.append(", renewTGT=");
            buffer.append(this.renewTGT);
            buffer.append(", ");
            if (this.ticketCachePath != null) {
                buffer.append("ticketCachePath='");
                buffer.append(this.ticketCachePath);
                buffer.append("', ");
            }
        } else {
            buffer.append("useTicketCache=false, ");
        }
        if (this.isInitiator != null) {
            buffer.append("isInitiator=");
            buffer.append(this.isInitiator);
            buffer.append(", ");
        }
        buffer.append("jaasClientName='");
        buffer.append(this.jaasClientName);
        buffer.append("', ");
        if (this.configFilePath != null) {
            buffer.append("configFilePath='");
            buffer.append(this.configFilePath);
            buffer.append("', ");
        }
        if (this.saslClientServerName != null) {
            buffer.append("saslClientServerName='");
            buffer.append(this.saslClientServerName);
            buffer.append("', ");
        }
        buffer.append("servicePrincipalProtocol='");
        buffer.append(this.servicePrincipalProtocol);
        buffer.append("', channelBindingType='");
        buffer.append(this.channelBindingType.getName());
        buffer.append("', suppressedSystemProperties={");
        Iterator<String> propIterator = this.suppressedSystemProperties.iterator();
        while (propIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(propIterator.next());
            buffer.append('\'');
            if (!propIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, enableGSSAPIDebugging=");
        buffer.append(this.enableGSSAPIDebugging);
        buffer.append(')');
    }
}

