/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.IfControllerSchema;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.util.JMeterUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfController
extends GenericController
implements Serializable,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(IfController.class);
    private static final long serialVersionUID = 242L;
    private static final String NASHORN_ENGINE_NAME = "nashorn";
    private static final String USE_RHINO_ENGINE_PROPERTY = "javascript.use_rhino";
    private static final boolean USE_RHINO_ENGINE = JMeterUtils.getPropDefault("javascript.use_rhino", false) || IfController.getInstance().getEngineByName("nashorn") == null;
    private static final ThreadLocal<ScriptEngine> NASHORN_ENGINE = ThreadLocal.withInitial(() -> IfController.getInstance().getEngineByName(NASHORN_ENGINE_NAME));
    private static final JsEvaluator JAVASCRIPT_EVALUATOR = USE_RHINO_ENGINE ? new RhinoJsEngine() : new NashornJsEngine();

    private static ScriptEngineManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    public IfController() {
    }

    public IfController(String condition) {
        this.setCondition(condition);
    }

    @Override
    public IfControllerSchema getSchema() {
        return IfControllerSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends IfController, ? extends IfControllerSchema> getProps() {
        return new PropertiesAccessor<IfController, IfControllerSchema>(this, this.getSchema());
    }

    public void setCondition(String condition) {
        this.set(this.getSchema().getCondition(), condition);
    }

    public String getCondition() {
        return this.get(this.getSchema().getCondition()).trim();
    }

    private boolean evaluateCondition(String cond) {
        log.debug("    getCondition() : [{}]", (Object)cond);
        return JAVASCRIPT_EVALUATOR.evaluate(this.getName(), cond);
    }

    private static boolean computeResultFromString(String condition, String resultStr) throws Exception {
        boolean result;
        switch (resultStr) {
            case "false": {
                result = false;
                break;
            }
            case "true": {
                result = true;
                break;
            }
            default: {
                throw new Exception(" BAD CONDITION :: " + condition + " :: expected true or false");
            }
        }
        log.debug("    >> evaluate Condition -  [{}] results is  [{}]", (Object)condition, (Object)result);
        return result;
    }

    private static boolean evaluateExpression(String cond) {
        log.debug("    >> evaluate Expression [{}] equals (ignoring case) 'true'", (Object)cond);
        return cond.equalsIgnoreCase("true");
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public Sampler next() {
        boolean result = true;
        if (this.isEvaluateAll() || this.isFirst()) {
            boolean bl = result = this.isUseExpression() ? IfController.evaluateExpression(this.getCondition()) : this.evaluateCondition(this.getCondition());
        }
        if (result) {
            return super.next();
        }
        try {
            this.initializeSubControllers();
            return this.nextIsNull();
        }
        catch (NextIsNullException e1) {
            return null;
        }
    }

    @Override
    public void triggerEndOfLoop() {
        super.initializeSubControllers();
        super.triggerEndOfLoop();
    }

    public boolean isEvaluateAll() {
        return this.get(this.getSchema().getEvaluateAll());
    }

    public void setEvaluateAll(boolean b) {
        this.set(this.getSchema().getEvaluateAll(), b);
    }

    public boolean isUseExpression() {
        return this.get(this.getSchema().getUseExpression());
    }

    public void setUseExpression(boolean selected) {
        this.set(this.getSchema().getUseExpression(), selected);
    }

    @Override
    public void threadStarted() {
    }

    @Override
    public void threadFinished() {
        NASHORN_ENGINE.remove();
    }

    private static class LazyHolder {
        public static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private LazyHolder() {
        }
    }

    private static interface JsEvaluator {
        public boolean evaluate(String var1, String var2);
    }

    private static class RhinoJsEngine
    implements JsEvaluator {
        private RhinoJsEngine() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evaluate(String testElementName, String condition) {
            boolean result = false;
            Context cx = Context.enter();
            try {
                Scriptable scope = cx.initStandardObjects(null);
                Object cxResultObject = cx.evaluateString(scope, condition, "<cmd>", 1, null);
                result = IfController.computeResultFromString(condition, Context.toString((Object)cxResultObject));
            }
            catch (Exception e) {
                log.error("{}: error while processing [{}]", new Object[]{testElementName, condition, e});
            }
            finally {
                Context.exit();
            }
            return result;
        }
    }

    private static class NashornJsEngine
    implements JsEvaluator {
        private NashornJsEngine() {
        }

        @Override
        public boolean evaluate(String testElementName, String condition) {
            try {
                SimpleScriptContext newContext = new SimpleScriptContext();
                newContext.setBindings(((ScriptEngine)NASHORN_ENGINE.get()).createBindings(), 100);
                Object o = ((ScriptEngine)NASHORN_ENGINE.get()).eval(condition, (ScriptContext)newContext);
                return IfController.computeResultFromString(condition, o.toString());
            }
            catch (Exception ex) {
                log.error("{}: error while processing [{}]", new Object[]{testElementName, condition, ex});
                return false;
            }
        }
    }
}

