/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.function;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.exparity.hamcrest.date.core.TemporalFunction;
import org.exparity.hamcrest.date.core.types.Interval;

public class LocalTimeFunction
implements TemporalFunction<LocalTime> {
    private static final String TIME_PATTERN = "hh:mm:ss a";

    @Override
    public boolean isAfter(LocalTime expected, LocalTime actual) {
        return expected.isAfter(actual);
    }

    @Override
    public boolean isBefore(LocalTime expected, LocalTime actual) {
        return expected.isBefore(actual);
    }

    @Override
    public boolean isSame(LocalTime expected, LocalTime actual) {
        return expected.equals(actual);
    }

    @Override
    public Interval interval(LocalTime expected, LocalTime other, ChronoUnit unit) {
        return Interval.of(expected.until(other, unit), unit);
    }

    @Override
    public String describe(LocalTime temporal, Locale locale) {
        return temporal.format(DateTimeFormatter.ofPattern(TIME_PATTERN, locale));
    }
}

