/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.IOException;
import java.io.Writer;

public final class StringBuilderWriter
extends Writer {
    private StringBuilder sb;

    public StringBuilderWriter() {
        this.sb = new StringBuilder();
        this.lock = null;
    }

    public StringBuilderWriter(StringBuilder sb) {
        this.sb = sb;
        this.lock = null;
    }

    public StringBuilderWriter(int initialSize) {
        this.sb = new StringBuilder(initialSize);
        this.lock = null;
    }

    @Override
    public void write(int c) {
        this.sb.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int start, int length) {
        this.sb.append(cbuf, start, length);
    }

    @Override
    public void write(String str) {
        this.sb.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.sb.append(str.substring(off, off + len));
    }

    @Override
    public StringBuilderWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public StringBuilderWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public StringBuilderWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

