/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.StatusLine;
import org.apache.juneau.Context;
import org.apache.juneau.ContextSession;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.logging.RestLogger;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatch;

public class RestSession
extends ContextSession {
    private static final String REST_PATHVARS_ATTR = "juneau.pathVars";
    private final Object resource;
    private final RestContext context;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private RestLogger logger;
    private UrlPath urlPath;
    private String pathInfoUndecoded;
    private long startTime = System.currentTimeMillis();
    private BeanStore beanStore;
    private Map<String, String[]> queryParams;
    private String method;
    private RestOpSession opSession;
    private UrlPathMatch urlPathMatch;

    public static Builder create(RestContext ctx) {
        return new Builder(ctx);
    }

    public RestSession(Builder builder) {
        super((ContextSession.Builder)builder);
        this.context = builder.ctx;
        this.resource = builder.resource;
        this.beanStore = BeanStore.of((BeanStore)this.context.getRootBeanStore(), (Object)this.resource).addBean(RestContext.class, (Object)this.context);
        this.req = (HttpServletRequest)this.beanStore.add(HttpServletRequest.class, (Object)builder.req);
        this.res = (HttpServletResponse)this.beanStore.add(HttpServletResponse.class, (Object)builder.res);
        this.logger = (RestLogger)this.beanStore.add(RestLogger.class, (Object)builder.logger);
        this.urlPath = (UrlPath)this.beanStore.add(UrlPath.class, (Object)builder.urlPath);
        this.pathInfoUndecoded = builder.pathInfoUndecoded;
    }

    public RestSession logger(RestLogger value) {
        this.logger = (RestLogger)this.beanStore.add(RestLogger.class, (Object)value);
        return this;
    }

    public RestSession debug(boolean value) throws IOException {
        if (value) {
            this.req = CachingHttpServletRequest.wrap(this.req);
            this.res = CachingHttpServletResponse.wrap(this.res);
            this.req.setAttribute("Debug", (Object)true);
        } else {
            this.req.removeAttribute("Debug");
        }
        return this;
    }

    public RestSession status(int value) {
        this.res.setStatus(value);
        return this;
    }

    public RestSession status(StatusLine value) {
        if (value != null) {
            this.res.setStatus(value.getStatusCode(), value.getReasonPhrase());
        }
        return this;
    }

    public RestSession exception(Throwable value) {
        this.req.setAttribute("Exception", (Object)value);
        this.beanStore.addBean(Throwable.class, (Object)value);
        return this;
    }

    public RestSession urlPathMatch(UrlPathMatch value) {
        this.urlPathMatch = (UrlPathMatch)this.beanStore.add(UrlPathMatch.class, (Object)value);
        return this;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public BeanStore getBeanStore() {
        return this.beanStore;
    }

    public Map<String, String> getPathVars() {
        Map m = (Map)this.req.getAttribute(REST_PATHVARS_ATTR);
        return m == null ? Collections.emptyMap() : m;
    }

    public UrlPathMatch getUrlPathMatch() {
        return this.urlPathMatch;
    }

    public Throwable getException() {
        return (Throwable)this.req.getAttribute("Exception");
    }

    public RestSession finish() {
        try {
            this.req.setAttribute("ExecTime", (Object)(System.currentTimeMillis() - this.startTime));
            if (this.opSession != null) {
                this.opSession.finish();
            } else {
                this.res.flushBuffer();
            }
        }
        catch (Exception e) {
            this.exception(e);
        }
        if (this.logger != null) {
            this.logger.log(this.req, this.res);
        }
        return this;
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public UrlPath getUrlPath() {
        if (this.urlPath == null) {
            this.urlPath = UrlPath.of(this.getPathInfoUndecoded());
        }
        return this.urlPath;
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathInfoUndecoded() {
        if (this.pathInfoUndecoded == null) {
            this.pathInfoUndecoded = RestUtils.getPathInfoUndecoded(this.req);
        }
        return this.pathInfoUndecoded;
    }

    public Map<String, String[]> getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = this.req.getMethod().equalsIgnoreCase("POST") ? RestUtils.parseQuery(this.req.getQueryString(), CollectionUtils.map()) : this.req.getParameterMap();
        }
        return this.queryParams;
    }

    public String getMethod() {
        if (this.method == null) {
            Object x;
            Set<String> s1 = this.context.getAllowedMethodParams();
            Set<String> s2 = this.context.getAllowedMethodHeaders();
            if (!s1.isEmpty() && (x = this.getQueryParams().get("method")) != null && (s1.contains("*") || s1.contains(x[0]))) {
                this.method = x[0];
            }
            if (this.method == null && !s2.isEmpty() && (x = this.req.getHeader("X-Method")) != null && (s2.contains("*") || s2.contains(x))) {
                this.method = x;
            }
            if (this.method == null) {
                this.method = this.req.getMethod();
            }
            this.method = this.method.toUpperCase(Locale.ENGLISH);
        }
        return this.method;
    }

    public int getStatus() {
        return this.res.getStatus();
    }

    public RestContext getContext() {
        return this.context;
    }

    public Object getResource() {
        return this.resource;
    }

    public RestOpSession getOpSession() throws InternalServerError {
        if (this.opSession == null) {
            throw new InternalServerError("Op Session not created.", new Object[0]);
        }
        return this.opSession;
    }

    public void run() throws Throwable {
        try {
            this.opSession = this.context.getRestOperations().findOperation(this).createSession(this).build();
            this.context.preCall(this.opSession);
            this.opSession.run();
            this.context.postCall(this.opSession);
            if (this.res.getStatus() == 0) {
                this.res.setStatus(200);
            }
            if (this.opSession.getResponse().hasContent()) {
                this.context.processResponse(this.opSession);
            }
        }
        catch (NotFound e) {
            if (this.getStatus() == 0) {
                this.status(404);
            }
            this.exception(e);
            this.context.handleNotFound(this);
        }
    }

    public static class Builder
    extends ContextSession.Builder {
        RestContext ctx;
        Object resource;
        HttpServletRequest req;
        HttpServletResponse res;
        RestLogger logger;
        String pathInfoUndecoded;
        UrlPath urlPath;

        protected Builder(RestContext ctx) {
            super((Context)ctx);
            this.ctx = ctx;
        }

        public Builder resource(Object value) {
            this.resource = value;
            return this;
        }

        public Builder req(HttpServletRequest value) {
            this.req = value;
            return this;
        }

        public HttpServletRequest req() {
            this.urlPath = null;
            this.pathInfoUndecoded = null;
            return this.req;
        }

        public Builder res(HttpServletResponse value) {
            this.res = value;
            return this;
        }

        public HttpServletResponse res() {
            return this.res;
        }

        public Builder logger(RestLogger value) {
            this.logger = value;
            return this;
        }

        public RestSession build() {
            return new RestSession(this);
        }

        public UrlPath getUrlPath() {
            if (this.urlPath == null) {
                this.urlPath = UrlPath.of(this.getPathInfoUndecoded());
            }
            return this.urlPath;
        }

        public String getPathInfoUndecoded() {
            if (this.pathInfoUndecoded == null) {
                this.pathInfoUndecoded = RestUtils.getPathInfoUndecoded(this.req);
            }
            return this.pathInfoUndecoded;
        }

        public Builder pathVars(Map<String, String> value) {
            if (value != null && !value.isEmpty()) {
                TreeMap<String, String> m = (TreeMap<String, String>)this.req.getAttribute(RestSession.REST_PATHVARS_ATTR);
                if (m == null) {
                    m = new TreeMap<String, String>();
                    this.req.setAttribute(RestSession.REST_PATHVARS_ATTR, m);
                }
                m.putAll(value);
            }
            return this;
        }
    }
}

