/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.serializer.SerializeException;

public abstract class ObjectSwap<T, S> {
    public static final ObjectSwap NULL = new ObjectSwap((Class)null, (Class)null){};
    private final Class<T> normalClass;
    private final Class<?> swapClass;
    private final ClassInfo normalClassInfo;
    private final ClassInfo swapClassInfo;
    private ClassMeta<?> swapClassMeta;
    private MediaType[] forMediaTypes;
    private String template;

    protected ObjectSwap() {
        ClassInfo ci = ClassInfo.of(this.getClass());
        this.normalClass = ci.getParameterType(0, ObjectSwap.class);
        this.swapClass = ci.getParameterType(1, ObjectSwap.class);
        this.normalClassInfo = ClassInfo.of(this.normalClass);
        this.swapClassInfo = ClassInfo.of(this.swapClass);
        this.forMediaTypes = this.forMediaTypes();
        this.template = this.withTemplate();
    }

    protected ObjectSwap(Class<T> normalClass, Class<?> swapClass) {
        this.normalClass = normalClass;
        this.swapClass = swapClass;
        this.normalClassInfo = ClassInfo.of(normalClass);
        this.swapClassInfo = ClassInfo.of(swapClass);
        this.forMediaTypes = this.forMediaTypes();
        this.template = this.withTemplate();
    }

    public MediaType[] forMediaTypes() {
        return null;
    }

    public String withTemplate() {
        return null;
    }

    public ObjectSwap<T, ?> forMediaTypes(MediaType[] mediaTypes) {
        this.forMediaTypes = mediaTypes;
        return this;
    }

    public ObjectSwap<T, ?> withTemplate(String template) {
        this.template = template;
        return this;
    }

    public int match(BeanSession session) {
        if (this.forMediaTypes == null) {
            return 1;
        }
        int i = 0;
        MediaType mt = session.getMediaType();
        if (mt == null) {
            return 0;
        }
        if (this.forMediaTypes != null) {
            for (MediaType mt2 : this.forMediaTypes) {
                i = Math.max(i, mt2.match(mt, false));
            }
        }
        return i;
    }

    public S swap(BeanSession session, T o) throws Exception {
        return this.swap(session, o, this.template);
    }

    public S swap(BeanSession session, T o, String template) throws Exception {
        throw new SerializeException("Swap method not implemented on ObjectSwap ''{0}''", ClassUtils.className(this));
    }

    public T unswap(BeanSession session, S f, ClassMeta<?> hint) throws Exception {
        return this.unswap(session, f, hint, this.template);
    }

    public T unswap(BeanSession session, S f, ClassMeta<?> hint, String template) throws Exception {
        throw new ParseException("Unswap method not implemented on ObjectSwap ''{0}''", ClassUtils.className(this));
    }

    public ClassInfo getNormalClass() {
        return this.normalClassInfo;
    }

    public ClassInfo getSwapClass() {
        return this.swapClassInfo;
    }

    public ClassMeta<?> getSwapClassMeta(BeanSession session) {
        if (this.swapClassMeta == null) {
            this.swapClassMeta = session.getClassMeta(this.swapClass);
        }
        return this.swapClassMeta;
    }

    public boolean isNormalObject(Object o) {
        if (o == null) {
            return false;
        }
        return this.normalClassInfo.isParentOf(o.getClass());
    }

    public boolean isSwappedObject(Object o) {
        if (o == null) {
            return false;
        }
        return this.swapClassInfo.isParentOf(o.getClass());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.getNormalClass().getSimpleName() + "," + this.getSwapClass().getSimpleName() + ">";
    }
}

