/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CachingHttpServletResponse
extends HttpServletResponseWrapper {
    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    final ServletOutputStream os;

    public static CachingHttpServletResponse wrap(HttpServletResponse res) throws IOException {
        if (res instanceof CachingHttpServletResponse) {
            CachingHttpServletResponse res2 = (CachingHttpServletResponse)res;
            return res2;
        }
        return new CachingHttpServletResponse(res);
    }

    protected CachingHttpServletResponse(HttpServletResponse res) throws IOException {
        super(res);
        this.os = res.getOutputStream();
    }

    public byte[] getContent() {
        return this.baos.toByteArray();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void close() throws IOException {
                CachingHttpServletResponse.this.os.close();
            }

            public void flush() throws IOException {
                CachingHttpServletResponse.this.os.flush();
            }

            public boolean isReady() {
                return CachingHttpServletResponse.this.os.isReady();
            }

            public void setWriteListener(WriteListener writeListener) {
                CachingHttpServletResponse.this.os.setWriteListener(writeListener);
            }

            public void write(int b) throws IOException {
                CachingHttpServletResponse.this.baos.write(b);
                CachingHttpServletResponse.this.os.write(b);
            }
        };
    }
}

