/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;

public class RmiRegistryFactory {
    private int port = 1099;
    private String host;
    private Registry registry;
    private boolean locate;
    private boolean create = true;
    private boolean locallyCreated;
    private BundleContext bundleContext;

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean isLocate() {
        return this.locate;
    }

    public void setLocate(boolean locate) {
        this.locate = locate;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Object getObject() throws Exception {
        return this.registry;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws RemoteException, UnknownHostException {
        if (this.registry == null && this.locate) {
            try {
                Registry reg = LocateRegistry.getRegistry(this.host, this.getPort());
                reg.list();
                this.registry = reg;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (this.registry == null && this.create) {
            if (this.host != null && !this.host.isEmpty()) {
                RMISocketFactory socketFactory = RMISocketFactory.getDefaultSocketFactory();
                InetAddress addr = InetAddress.getByName(this.host);
                KarafServerSocketFactory serverSocketFactory = new KarafServerSocketFactory(addr, this.port);
                this.registry = LocateRegistry.createRegistry(this.getPort(), socketFactory, serverSocketFactory);
            } else {
                this.registry = LocateRegistry.createRegistry(this.getPort());
            }
            this.locallyCreated = true;
        }
        if (this.registry != null) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("port", this.getPort());
            props.put("host", this.getHost());
            this.bundleContext.registerService(Registry.class, (Object)this.registry, props);
        }
    }

    public void destroy() throws RemoteException {
        if (this.registry != null && this.locallyCreated) {
            Registry reg = this.registry;
            this.registry = null;
            UnicastRemoteObject.unexportObject(reg, true);
        }
    }

    private static class KarafServerSocketFactory
    implements RMIServerSocketFactory {
        private final int port;
        private final InetAddress addr;

        private KarafServerSocketFactory(InetAddress addr, int port) {
            this.addr = addr;
            this.port = port;
        }

        @Override
        public ServerSocket createServerSocket(int i) throws IOException {
            return new ServerSocket(this.port, 0, this.addr);
        }
    }
}

