/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.ConfigInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.FeaturesServiceImpl;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureConfigInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private static final String CONFIG_KEY = "org.apache.karaf.features.configKey";
    private static final String FILEINSTALL_FILE_NAME = "felix.fileinstall.filename";
    private final ConfigurationAdmin configAdmin;
    private File storage;
    private boolean configCfgStore = true;

    public FeatureConfigInstaller(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        this.storage = new File(System.getProperty("karaf.etc"));
        this.configCfgStore = true;
    }

    public FeatureConfigInstaller(ConfigurationAdmin configAdmin, boolean configCfgStore) {
        this.configAdmin = configAdmin;
        this.storage = new File(System.getProperty("karaf.etc"));
        this.configCfgStore = configCfgStore;
    }

    private String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    private Configuration createConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            return configurationAdmin.createFactoryConfiguration(pid, null);
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    private Configuration findExistingConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        String filter;
        if (factoryPid == null) {
            filter = "(service.pid=" + pid + ")";
        } else {
            String key = this.createConfigurationKey(pid, factoryPid);
            filter = "(org.apache.karaf.features.configKey=" + key + ")";
        }
        Configuration[] configurations = configurationAdmin.listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    public void installFeatureConfigs(Feature feature, boolean verbose) throws IOException, InvalidSyntaxException {
        for (ConfigInfo config : feature.getConfigurations()) {
            Properties props = config.getProperties();
            String[] pid = this.parsePid(config.getName());
            Configuration cfg = this.findExistingConfiguration(this.configAdmin, pid[0], pid[1]);
            if (cfg == null) {
                Dictionary<String, String> cfgProps = this.convertToDict(props);
                cfg = this.createConfiguration(this.configAdmin, pid[0], pid[1]);
                String key = this.createConfigurationKey(pid[0], pid[1]);
                cfgProps.put(CONFIG_KEY, key);
                cfg.update(cfgProps);
                try {
                    this.updateStorage(pid[0], props);
                }
                catch (Exception e) {
                    LOGGER.warn("Can't update cfg file", (Throwable)e);
                }
                continue;
            }
            if (!config.isAppend()) continue;
            boolean update = false;
            Dictionary properties = cfg.getProperties();
            for (String key : props.stringPropertyNames()) {
                if (properties.get(key) != null) continue;
                properties.put(key, props.getProperty(key));
                update = true;
            }
            if (!update) continue;
            cfg.update(properties);
            try {
                this.updateStorage(pid[0], props);
            }
            catch (Exception e) {
                LOGGER.warn("Can't update cfg file", (Throwable)e);
            }
        }
        for (ConfigFileInfo configFile : feature.getConfigurationFiles()) {
            this.installConfigurationFile(configFile.getLocation(), configFile.getFinalname(), configFile.isOverride(), verbose);
        }
    }

    private Dictionary<String, String> convertToDict(Properties props) {
        Hashtable<String, String> cfgProps = new Hashtable<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = props.getProperty(key);
            ((Dictionary)cfgProps).put(key, val);
        }
        return cfgProps;
    }

    private String createConfigurationKey(String pid, String factoryPid) {
        return factoryPid == null ? pid : pid + "-" + factoryPid;
    }

    private void installConfigurationFile(String fileLocation, String finalname, boolean override, boolean verbose) throws IOException {
        File file;
        LOGGER.debug("Checking configuration file " + fileLocation);
        if (verbose) {
            System.out.println("Checking configuration file " + fileLocation);
        }
        String basePath = System.getProperty("karaf.base");
        if (finalname.indexOf("${") != -1) {
            int marker = finalname.indexOf("}");
            finalname = finalname.substring(marker + 1);
        }
        if ((file = new File(finalname = basePath + File.separator + finalname)).exists() && !override) {
            LOGGER.debug("configFile already exist, don't override it");
            return;
        }
        InputStream is = null;
        OutputStream fop = null;
        try {
            int bytesRead;
            is = new BufferedInputStream(new URL(fileLocation).openStream());
            if (!file.exists()) {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
            }
            fop = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((FileOutputStream)fop).write(buffer, 0, bytesRead);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fop != null) {
                fop.flush();
                ((FileOutputStream)fop).close();
            }
        }
    }

    protected void updateStorage(String pid, Dictionary props) throws IOException {
        if (this.storage != null && this.configCfgStore) {
            File cfgFile = new File(this.storage, pid + ".cfg");
            Configuration cfg = this.configAdmin.getConfiguration(pid, null);
            if (cfg != null && cfg.getProperties() != null) {
                Object val = cfg.getProperties().get(FILEINSTALL_FILE_NAME);
                try {
                    if (val instanceof URL) {
                        cfgFile = new File(((URL)val).toURI());
                    }
                    if (val instanceof URI) {
                        cfgFile = new File((URI)val);
                    }
                    if (val instanceof String) {
                        cfgFile = new File(new URL((String)val).toURI());
                    }
                }
                catch (Exception e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            LOGGER.trace("Update {}", (Object)cfgFile.getName());
            org.apache.felix.utils.properties.Properties properties = new org.apache.felix.utils.properties.Properties(cfgFile);
            Enumeration keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if ("service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key) || props.get(key) == null) continue;
                properties.put(key, props.get(key).toString());
            }
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            for (String key : properties.keySet()) {
                if (props.get(key) != null || "service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key)) continue;
                propertiesToRemove.add(key);
            }
            for (String key : propertiesToRemove) {
                properties.remove(key);
            }
            this.storage.mkdirs();
            properties.save();
        }
    }
}

