/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.ServletConfigImpl;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.runtime.ServletInfo;

public abstract class ServletHandler
implements Comparable<ServletHandler> {
    private final long contextServiceId;
    private final ServletInfo servletInfo;
    private final ExtServletContext context;
    private volatile Servlet servlet;
    protected volatile int useCount;

    public ServletHandler(long contextServiceId, ExtServletContext context, ServletInfo servletInfo) {
        this.contextServiceId = contextServiceId;
        this.context = context;
        this.servletInfo = servletInfo;
    }

    @Override
    public int compareTo(ServletHandler other) {
        return this.servletInfo.compareTo(other.servletInfo);
    }

    public long getContextServiceId() {
        return this.contextServiceId;
    }

    public ExtServletContext getContext() {
        return this.context;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    protected void setServlet(Servlet s) {
        this.servlet = s;
    }

    public void handle(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.servlet.service(req, res);
    }

    public ServletInfo getServletInfo() {
        return this.servletInfo;
    }

    public String getName() {
        String name = this.servletInfo.getName();
        if (name == null && this.servlet != null) {
            name = this.servlet.getClass().getName();
        }
        return name;
    }

    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        if (this.servlet == null) {
            return 5;
        }
        try {
            this.servlet.init((ServletConfig)new ServletConfigImpl(this.getName(), this.getContext(), this.getServletInfo().getInitParameters()));
        }
        catch (Exception e) {
            SystemLogger.error(this.getServletInfo().getServiceReference(), "Error during calling init() on servlet " + this.servlet, e);
            return 4;
        }
        ++this.useCount;
        return -1;
    }

    public boolean destroy() {
        if (this.servlet == null) {
            return false;
        }
        --this.useCount;
        if (this.useCount == 0) {
            try {
                this.servlet.destroy();
            }
            catch (Exception ignore) {
                SystemLogger.error(this.getServletInfo().getServiceReference(), "Error during calling destroy() on servlet " + this.servlet, ignore);
            }
            this.servlet = null;
            return true;
        }
        return false;
    }

    public boolean dispose() {
        this.useCount = 1;
        return this.destroy();
    }

    public int hashCode() {
        return 31 + this.servletInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServletHandler other = (ServletHandler)obj;
        return this.servletInfo.equals(other.servletInfo);
    }
}

