/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.runtime.dto.FailedDTOHolder;

public class FailureStateHandler {
    private final Map<AbstractInfo<?>, FailureStatus> serviceFailures = new ConcurrentHashMap();

    public void add(AbstractInfo<?> info, int reason) {
        this.add(info, 0L, reason);
    }

    public void add(AbstractInfo<?> info, long contextId, int reason) {
        Set<Long> contexts;
        FailureStatus status = this.serviceFailures.get(info);
        if (status == null) {
            status = new FailureStatus();
            this.serviceFailures.put(info, status);
        }
        contexts = (contexts = status.reasonToContextsMapping.get(reason)) == null ? new HashSet<Long>() : new HashSet<Long>(contexts);
        contexts.add(contextId);
        status.reasonToContextsMapping.put(reason, contexts);
    }

    public boolean remove(AbstractInfo<?> info) {
        return this.remove(info, 0L);
    }

    public boolean removeAll(AbstractInfo<?> info) {
        boolean result = this.remove(info, 0L);
        this.serviceFailures.remove(info);
        return result;
    }

    public boolean remove(AbstractInfo<?> info, long contextId) {
        FailureStatus status = this.serviceFailures.get(info);
        if (status != null) {
            Iterator<Map.Entry<Integer, Set<Long>>> i = status.reasonToContextsMapping.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Integer, Set<Long>> entry = i.next();
                if (!entry.getValue().contains(contextId)) continue;
                if (entry.getValue().size() == 1) {
                    i.remove();
                } else {
                    HashSet set = new HashSet(entry.getValue());
                    set.remove(contextId);
                    entry.setValue(set);
                }
                return true;
            }
        }
        return false;
    }

    public void getRuntimeInfo(FailedDTOHolder failedDTOHolder) {
        for (Map.Entry<AbstractInfo<?>, FailureStatus> entry : this.serviceFailures.entrySet()) {
            for (Map.Entry<Integer, Set<Long>> status : entry.getValue().reasonToContextsMapping.entrySet()) {
                for (long contextId : status.getValue()) {
                    failedDTOHolder.add(entry.getKey(), contextId, status.getKey());
                }
            }
        }
    }

    private static final class FailureStatus {
        public final Map<Integer, Set<Long>> reasonToContextsMapping = new ConcurrentHashMap<Integer, Set<Long>>();

        private FailureStatus() {
        }
    }
}

