/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.felix.webconsole.plugins.event.internal.EventListener;
import org.apache.felix.webconsole.plugins.event.internal.OptionalFeaturesHandler;
import org.apache.felix.webconsole.plugins.event.internal.PluginServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ServiceRegistration pluginRegistration;
    private EventListener eventListener;
    private PluginServlet plugin;
    private OptionalFeaturesHandler featuresHandler;

    public void start(BundleContext context) throws Exception {
        this.plugin = new PluginServlet();
        this.eventListener = new EventListener(this.plugin, context);
        this.featuresHandler = new OptionalFeaturesHandler(this.plugin, context);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Event Plugin for the Apache Felix Web Console");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("felix.webconsole.label", "events");
        ((Dictionary)props).put("felix.webconsole.title", "%plugin.events.title");
        ((Dictionary)props).put("felix.webconsole.css", "/events/res/ui/events.css");
        ((Dictionary)props).put("felix.webconsole.category", "OSGi");
        this.pluginRegistration = context.registerService(Servlet.class.getName(), (Object)this.plugin, props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.pluginRegistration != null) {
            this.pluginRegistration.unregister();
            this.pluginRegistration = null;
        }
        if (this.eventListener != null) {
            this.eventListener.destroy();
            this.eventListener = null;
        }
        if (this.featuresHandler != null) {
            this.featuresHandler.destroy();
            this.featuresHandler = null;
        }
        if (this.plugin != null) {
            this.plugin.destroy();
            this.plugin = null;
        }
    }
}

