/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryClientServiceFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.impl.CLIMasterService;
import org.apache.knox.gateway.services.security.impl.DefaultAliasService;
import org.apache.knox.gateway.services.security.impl.DefaultCryptoService;
import org.apache.knox.gateway.services.security.impl.DefaultKeystoreService;
import org.apache.knox.gateway.services.security.impl.RemoteAliasService;
import org.apache.knox.gateway.services.topology.impl.DefaultTopologyService;
import org.apache.knox.gateway.topology.Provider;

public class CLIGatewayServices
implements GatewayServices {
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private Map<String, Service> services = new HashMap<String, Service>();
    private CLIMasterService ms = null;
    private DefaultKeystoreService ks = null;

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        RemoteAliasService alias = new RemoteAliasService();
        RemoteConfigurationRegistryClientService registryClientService = RemoteConfigurationRegistryClientServiceFactory.newInstance((GatewayConfig)config);
        registryClientService.setAliasService((AliasService)alias);
        registryClientService.init(config, options);
        this.services.put("RemoteConfigRegistryClientService", (Service)registryClientService);
        this.ms = new CLIMasterService();
        this.ms.init(config, options);
        this.services.put("MasterService", this.ms);
        this.ks = new DefaultKeystoreService();
        this.ks.setMasterService(this.ms);
        this.ks.init(config, options);
        this.services.put("KeystoreService", this.ks);
        DefaultAliasService defaultAlias = new DefaultAliasService();
        defaultAlias.setKeystoreService(this.ks);
        defaultAlias.init(config, options);
        alias.setLocalAliasService(defaultAlias);
        alias.setMasterService(this.ms);
        alias.setRegistryClientService(registryClientService);
        alias.init(config, options);
        alias.start();
        this.services.put("AliasService", (Service)alias);
        DefaultCryptoService crypto = new DefaultCryptoService();
        crypto.setKeystoreService(this.ks);
        crypto.setAliasService(alias);
        crypto.init(config, options);
        this.services.put("CryptoService", (Service)crypto);
        DefaultTopologyService tops = new DefaultTopologyService();
        tops.init(config, options);
        this.services.put("TopologyService", (Service)tops);
    }

    public void start() throws ServiceLifecycleException {
        this.ms.start();
        this.ks.start();
        DefaultAliasService alias = (DefaultAliasService)this.services.get("AliasService");
        alias.start();
        DefaultTopologyService tops = (DefaultTopologyService)this.services.get("TopologyService");
        tops.start();
        this.services.get("RemoteConfigRegistryClientService").start();
    }

    public void stop() throws ServiceLifecycleException {
        this.ms.stop();
        this.ks.stop();
        DefaultAliasService alias = (DefaultAliasService)this.services.get("AliasService");
        alias.stop();
        DefaultTopologyService tops = (DefaultTopologyService)this.services.get("TopologyService");
        tops.stop();
    }

    public Collection<String> getServiceNames() {
        return this.services.keySet();
    }

    public <T> T getService(String serviceName) {
        return (T)this.services.get(serviceName);
    }

    public String getRole() {
        return "Services";
    }

    public String getName() {
        return "GatewayServices";
    }

    public void initializeContribution(DeploymentContext context) {
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void contributeFilter(DeploymentContext context, Provider provider, org.apache.knox.gateway.topology.Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }

    public void finalizeContribution(DeploymentContext context) {
    }
}

