/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import com.nimbusds.jose.JWSHeader;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.impl.JWT;

public abstract class AbstractJWTFilter
implements Filter {
    public static final String JWT_EXPECTED_ISSUER = "jwt.expected.issuer";
    public static final String JWT_DEFAULT_ISSUER = "KNOXSSO";
    public static final String JWT_EXPECTED_SIGALG = "jwt.expected.sigalg";
    public static final String JWT_DEFAULT_SIGALG = "RS256";
    static JWTMessages log = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    protected List<String> audiences;
    protected JWTokenAuthority authority;
    protected RSAPublicKey publicKey = null;
    private String expectedIssuer;
    private String expectedSigAlg;

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void init(FilterConfig filterConfig) throws ServletException {
        GatewayServices services;
        ServletContext context = filterConfig.getServletContext();
        if (context != null && (services = (GatewayServices)context.getAttribute("org.apache.knox.gateway.gateway.services")) != null) {
            this.authority = (JWTokenAuthority)services.getService("TokenService");
        }
    }

    protected void configureExpectedParameters(FilterConfig filterConfig) {
        this.expectedIssuer = filterConfig.getInitParameter(JWT_EXPECTED_ISSUER);
        if (this.expectedIssuer == null) {
            this.expectedIssuer = JWT_DEFAULT_ISSUER;
        }
        this.expectedSigAlg = filterConfig.getInitParameter(JWT_EXPECTED_SIGALG);
        if (this.expectedSigAlg == null) {
            this.expectedSigAlg = JWT_DEFAULT_SIGALG;
        }
    }

    protected List<String> parseExpectedAudiences(String expectedAudiences) {
        ArrayList<String> audList = null;
        if (!StringUtils.isEmpty((String)expectedAudiences)) {
            String[] audArray = expectedAudiences.split(",");
            audList = new ArrayList<String>();
            for (String a : audArray) {
                audList.add(a.trim());
            }
        }
        return audList;
    }

    protected boolean tokenIsStillValid(JWT jwtToken) {
        Date expires = jwtToken.getExpiresDate();
        return expires == null || expires != null && new Date().before(expires);
    }

    protected boolean validateAudiences(JWT jwtToken) {
        boolean valid = false;
        String[] tokenAudienceList = jwtToken.getAudienceClaims();
        if (this.audiences == null) {
            valid = true;
        } else if (tokenAudienceList != null) {
            for (String aud : tokenAudienceList) {
                if (!this.audiences.contains(aud)) continue;
                log.jwtAudienceValidated();
                valid = true;
                break;
            }
        }
        return valid;
    }

    protected void continueWithEstablishedSecurityContext(Subject subject, final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        Principal principal = (Principal)subject.getPrincipals(PrimaryPrincipal.class).toArray()[0];
        AuditContext context = auditService.getContext();
        if (context != null) {
            context.setUsername(principal.getName());
            String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
            if (sourceUri != null) {
                auditor.audit("authentication", sourceUri, "uri", "success");
            }
        }
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    protected Subject createSubjectFromToken(JWT token) {
        String principal = token.getSubject();
        HashSet emptySet = new HashSet();
        HashSet<PrimaryPrincipal> principals = new HashSet<PrimaryPrincipal>();
        PrimaryPrincipal p = new PrimaryPrincipal(principal);
        principals.add(p);
        Subject subject = new Subject(true, principals, emptySet, emptySet);
        return subject;
    }

    protected boolean validateToken(HttpServletRequest request, HttpServletResponse response, FilterChain chain, JWT token) throws IOException, ServletException {
        boolean verified = false;
        try {
            verified = this.publicKey == null ? this.authority.verifyToken(token) : this.authority.verifyToken(token, this.publicKey);
        }
        catch (TokenServiceException e) {
            log.unableToVerifyToken((Exception)((Object)e));
        }
        if (verified) {
            try {
                String receivedSigAlg = JWSHeader.parse((String)token.getHeader()).getAlgorithm().getName();
                if (!receivedSigAlg.equals(this.expectedSigAlg)) {
                    verified = false;
                }
            }
            catch (ParseException e) {
                log.unableToVerifyToken(e);
                verified = false;
            }
        }
        if (verified) {
            if (this.expectedIssuer.equals(token.getIssuer())) {
                if (this.tokenIsStillValid(token)) {
                    boolean audValid = this.validateAudiences(token);
                    if (audValid) {
                        Date nbf = token.getNotBeforeDate();
                        if (nbf == null || new Date().after(nbf)) {
                            return true;
                        }
                        log.notBeforeCheckFailed();
                        this.handleValidationError(request, response, 400, "Bad request: the NotBefore check failed");
                    } else {
                        log.failedToValidateAudience();
                        this.handleValidationError(request, response, 400, "Bad request: missing required token audience");
                    }
                } else {
                    log.tokenHasExpired();
                    this.handleValidationError(request, response, 400, "Bad request: token has expired");
                }
            } else {
                this.handleValidationError(request, response, 401, null);
            }
        } else {
            log.failedToVerifyTokenSignature();
            this.handleValidationError(request, response, 401, null);
        }
        return false;
    }

    protected abstract void handleValidationError(HttpServletRequest var1, HttpServletResponse var2, int var3, String var4) throws IOException;
}

