/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class HadoopAuthCookieStore
extends BasicCookieStore {
    private static SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    private GatewayConfig gatewayConfig;

    HadoopAuthCookieStore(GatewayConfig config) {
        this.gatewayConfig = config;
    }

    public void addCookie(Cookie cookie) {
        if ((cookie.getName().equals("hadoop.auth") || cookie.getName().equals("hive.server2.auth")) && HadoopAuthCookieStore.isKnoxCookie(this.gatewayConfig, cookie)) {
            Wrapper wrapper = new Wrapper(cookie);
            LOG.acceptingServiceCookie((Cookie)wrapper);
            super.addCookie((Cookie)wrapper);
        }
    }

    private static boolean isKnoxCookie(GatewayConfig config, Cookie cookie) {
        String value;
        boolean result = false;
        if (cookie != null && (value = cookie.getValue()) != null && !value.isEmpty()) {
            String principal = null;
            String[] cookieParts = value.split("&");
            if (cookieParts.length > 1) {
                String krb5Config;
                String[] elementParts = cookieParts[1].split("=");
                if (elementParts.length == 2) {
                    principal = elementParts[1];
                }
                if (principal != null && (krb5Config = config.getKerberosLoginConfig()) != null && !krb5Config.isEmpty()) {
                    Properties p = new Properties();
                    try (InputStream in = Files.newInputStream(Paths.get(krb5Config, new String[0]), new OpenOption[0]);){
                        p.load(in);
                        String configuredPrincipal = p.getProperty("principal");
                        if (configuredPrincipal.startsWith("\"")) {
                            configuredPrincipal = configuredPrincipal.substring(1, configuredPrincipal.length() - 1);
                        }
                        result = principal.equals(configuredPrincipal);
                    }
                    catch (IOException e) {
                        LOG.errorReadingKerberosLoginConfig(krb5Config, e);
                    }
                }
            }
        }
        return result;
    }

    private static class Wrapper
    extends BasicClientCookie {
        private Cookie delegate;

        Wrapper(Cookie delegate) {
            super(delegate.getName(), delegate.getValue());
            this.delegate = delegate;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public String getValue() {
            String value = this.delegate.getValue();
            if (value != null && !value.isEmpty()) {
                if (!value.startsWith("\"")) {
                    value = "\"" + value;
                }
                if (!value.endsWith("\"")) {
                    value = value + "\"";
                }
            }
            return value;
        }

        public String getComment() {
            return this.delegate.getComment();
        }

        public String getCommentURL() {
            return this.delegate.getCommentURL();
        }

        public Date getExpiryDate() {
            return this.delegate.getExpiryDate();
        }

        public boolean isPersistent() {
            return this.delegate.isPersistent();
        }

        public String getDomain() {
            return this.delegate.getDomain();
        }

        public String getPath() {
            return this.delegate.getPath();
        }

        public int[] getPorts() {
            return this.delegate.getPorts();
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public int getVersion() {
            return this.delegate.getVersion();
        }

        public boolean isExpired(Date date) {
            return this.delegate.isExpired(date);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this){

                protected boolean accept(Field f) {
                    return super.accept(f) && !f.getName().equals("delegate");
                }
            }.toString();
        }
    }
}

